{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; array list with dynamic allocation

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBDAT;

const NumberOfElements = 100;

var MyList : ArrayListObjectType; Timer : TimerObjectType;
    Word1, Word2 : word;


begin
     Randomize; Timer.Initialize;

     WriteLn ('* Array list with dynamic allocation *');

     { Generate an array list with 100 entries an then display them all }

     with MyList do begin
          { Initialize a array list with a fixed number of elements }
          Initialize (NumberOfElements, SizeOf(Word1));
                     { Elements }       { Element size }

          { Sequential writing to array (write numbers 1 ... n in reversed
            order) }
          for Word2 := 1 to NumberOfElements do
              Add (Word2);

          { Reverse element order (swap first and last element and decrement
            interval until all elements have been swapped) }
          for Word2 := 1 to Elements div 2 do
              Swap (Word2, Succ(Elements - Word2));

          { Display entries }
          for Word2 := Elements downto 1 do Write (Word(ElementPointer(Word2)^):8);

          WriteLn;
          WriteLn ('Used ', Elements, ' elements of an array with storage capacity of ', Capacity, ' elements.');
          Intercept;
     end;

     with Timer do begin WriteLn (StringMS); Intercept; end;
     if GlobalDataError then WriteLn ('Error(s) reported!');
end.