/*--------------------------------------------------------------------*/
/*                      H P D E S C . H                               */
/*--------------------------------------------------------------------*/
/* FILE:         HPDESC.H                                             */
/* DESCRIPTION:  Header file defining font and char descriptors       */
/* COMPILER(s):  Borland 2.0+, MS 5.0+, Zortech C/C++                 */
/* AUTHOR:       Marv Luse, Ithaca Street Software, Inc.              */
/* DATE:         Sept, 1989                                           */
/* COPYRIGHT:    Uses freely but acknowledge source.                  */
/*--------------------------------------------------------------------*/

typedef struct
_font_desc                         /* font descriptor */
    {
    unsigned int   fd_size;        /* font descriptor size */
             char  resv_1;         /* reserved */
    unsigned char  font_type;      /* font type */
             int   resv_2;         /* reserved */
    unsigned int   bl_dist;        /* baseline distance */
    unsigned int   cell_width;     /* cell width */
    unsigned int   cell_height;    /* cell height */
    unsigned char  orient;         /* 0 = portrait, 1=landscape */
    unsigned char  proportional;   /* 0=fixed, 1=proportional */
    unsigned int   sym_set;        /* symbol set */
    unsigned int   pitch;          /* pitch */
    unsigned int   height;         /* height */
    unsigned int   xheight;        /* x height */
             char  wid_typ;        /* width type */
    unsigned char  style;          /* style */
             char  stroke_weight;  /* stroke weight */
    unsigned char  typeface;       /* typeface */
             char  resv_3;         /* reserved */
    unsigned char  serif_style;    /* serif style */
             int   resv_4;         /* reserved */
             char  ul_dist;        /* underline distance */
    unsigned char  ul_height;      /* underline height */
    unsigned int   txt_height;     /* text height */
    unsigned int   txt_width;      /* text width */
             int   resv_5;         /* reserved */
             int   resv_6;         /* reserved */
    unsigned char  pitch_ext;      /* pitch extended */
    unsigned char  height_ext;     /* height extended */
             int   resv_7;         /* reserved */
             int   resv_8;         /* reserved */
             int   resv_9;         /* reserved */
             char  font_name[16];  /* font name - this field's length */
                                   /* and contents can vary: the font */
                                   /* desc seq implies actual length. */
    }
font_desc;

typedef struct
_char_desc                         /* char descriptor */
    {
    unsigned char  format;         /* use 4 for LJ II */
             char  continue_flag;  /* only used for multi-desc chars */
    unsigned char  desc_size;      /* use 14 */
    unsigned char  desc_class;     /* use 1 */
    unsigned char  orient;         /* 0=Portrait, 1=Landscape */
             char  resv_1;         /* reserved */
             int   left_ofs;       /* offset to left edge of char */
             int   top_ofs;        /* offset to top of char */
    unsigned int   char_width;     /* width in dots */
    unsigned int   char_height;    /* height in dots */
             int   delta_x;        /* left_ofs + char_width */
          /* char  data[?]; */     /* place holder for char bitmap */
    }
char_desc;

/* macro to swap bytes in a 16-bit int, signed or unsigned */
#define HL2LH( v )   ( (v << 8) | ((v >> 8) & 0x00FF) )
