// LDIR.CXX
#include "filelist.hxx"

// The following strings contain no punctuation between them.
// An ANSI C preprocessor will concatenate all these strings
// into a single string.  This is convenient because it allows
// easy creation of a large block of display text, and easy
// modification of that block:
char * errmsg =
"ldir in C++ by Bruce Eckel.  A Unix-like file listing program.\n"
"Usage: ldir [filespec] [flags]\n"
"optional filespec must be second argument, but flags can be\n"
"in any order.  Available options are:\n"
"   -r    recursively expands subdirectories\n"
"   -s    displays sizes\n"
"   -t    displays times\n"
"   -d    displays dates\n"
"   -a    displays attributes\n";

main(int argc, char ** argv) {
  display_format format = 0;
  char * arg = "*.*";  // default file spec to all files

  // Here's a nice, expandable way to process command-line
  // switches:
  if (argc > 1 && argv[1][0] != '-')
    arg = argv[1];
  for(int a = argc -1;  a > 0; a--) {
    if(argv[a][0] == '-') {
      switch ( argv[a][1] ) {
        // ever wonder why you have to use "break" in switch
        // statements? it's so you can clump more than one case
        // together, like this:
        case 'r' : case 'R' : format |= subdirs; break;
        case 's' : case 'S' : format |= sizes; break;
        case 't' : case 'T' : format |= times; break;
        case 'd' : case 'D' : format |= dates; break;
        case 'a' : case 'A' : format |= attributes; break;
        default :
            fprintf(stderr, "unknown switch: %s\n", argv[a]);
            fprintf(stderr, "%s\n", errmsg);
            exit(1);
      }
    }
  }
  // Notice that the bulk of main() is taken up with the user
  // interface (above), and all the complicated work is hidden in 
  // the classes.  This is as it should be for a good design, and
  // it allows you to use the same user interface for many
  // different programs.
  file_list files(arg);
  if(format & subdirs) files.expand_list();
  files.display_all(format);
}
  
