// FILELIST.CXX
#include "filelist.hxx"
#include <direct.h>

#ifndef __ZTC__
#error Unmodified code may not compile/link on systems other than Zortech
#error because of the function calls to findfirst(), findnext(), getcwd()...
#endif

void directory_item::display(display_format format) {
  printf("%-14s", name);
  if (format & sizes) printf("%-8d", size);
  if (format & times) ; // Add code to show time
  if (format & dates) ; // Add code to show date
  if (format & attributes) ; // Add code to show attributes
}

subdir::subdir(FIND * p, char * afn) : (p) {
  expanded = 0;  // subdirectory is not expanded
  strcpy(pattern, afn);
  char buf[150];
  getcwd(buf, 149);  // store path information
  strlwr(buf);  // lower case
  path = new char[strlen(buf) + 1];
  strcpy(path, buf);
}

subdir::~subdir() {
  delete subdir_list;  // no effect if it's NULL
  delete path;  // ditto
}

void subdir::expand() {
  if ( *name != '.') {  // don't create subdirs for . or ..
    chdir(name);
    printf("expanding %s\\%s\n", path, name);
    subdir_list = new file_list(pattern);
    subdir_list->expand_list();  // expand any subdirectories
    chdir("..");
    expanded = 1; // subdirectory is now expanded
  }
}

void subdir::display(display_format format) {
  if (format & subdirs) {
    if( *name != '.') {
      printf("\n%s\\%s\n", path, name);
      if(expanded) {
        subdir_list->display_all(format);
        putchar('\n');
      }
    }
  } else {
    printf("\\%-13s", name);
  }
}

unsigned long subdir::bytes() {
  if (!expanded) return 0;
  char buf[165];
  sprintf(buf, "%s\\%s", path, name);
  return subdir_list->disk_space(buf);
}

void file::display(display_format format) {
  if(format & subdirs) return;  // quit if this is for subdirs
  if (attribute & FA_RDONLY) putchar('(');
  if (attribute & FA_HIDDEN) putchar('[');
  if (attribute & FA_SYSTEM) { putchar('$'); putchar(' '); }
  directory_item::display(format);
  if (attribute & FA_RDONLY) putchar(')');
  if (attribute & FA_HIDDEN) putchar(']');
}

file_list::file_list(char * afn) : () {
  // find all different file entries:
  FIND * p = findfirst(afn,
    FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_LABEL | FA_DIREC);
  while(p) {
    switch(p->attribute) {
      case FA_DIREC : 
          append(new subdir(p, afn)); // all directories at end
          break;
      default :
          insert(new file(p));  // all files at beginning
    }
    p = findnext();
  }
}

void file_list::expand_list() {
  // expand all the subdirectories:
  reset();
  while(!end()) {
    value()->expand();
    next();
  }
}  

unsigned long file_list::disk_space(char * msg) {
  reset();
  unsigned long space = 0;
  while(!end()) {
    space += value()->bytes();
    next();
  }
  if(*msg) printf("%s : %lu\n", msg, space);
  return space;
}

void file_list::display_all(display_format format) {
  reset();
  int i = 0;
  display_format no_subdirs = format & (~subdirs); // turn off subdirs bit
  while(!end()) {
    value()->display(no_subdirs);
    next();
    if ( (++i % 4) == 0 )
    putchar('\n');
  }
  if(format & subdirs) {
    reset();
    while(!end()) {
      value()->display(format);
      next();
    }
  }
}
