; SH_RL.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

; These two routines shift the display right or left to allow
; editing files which contain lines longer than 80 columns
;

include	model.inc

public	sh_right, sh_left
extrn	cursor_col:near

include	dataseg.inc
extrn	left_margin:word
extrn	cur_posn:word
extrn	save_column:byte
extrn	dirty_bits:byte
@curseg	ends

include	codeseg.inc
sh_right	proc	near
	cmp	left_margin,65535-8
	cmc
	jc	short no_shift
	add	left_margin,8	; this moves the margin over
sh_return:
	call	cursor_col	; compute column for cursor
	mov	dx,cur_posn
	mov	save_column,dl	; save the current column
	or	dirty_bits,1	; redraw the screen
no_shift:
	ret
sh_right	endp

sh_left	proc	near
	cmp	left_margin,0	; already at start of line?
	je	no_shift
	sub	left_margin,8	; move the window over
	jmp	sh_return
sh_left	endp

@curseg	ends
	end
