; LOAD.ASM for E32 - Copyright (C) 1994 - 1996 Douglas Herr
;  all rights reserved

; This subroutine prompts for a new filename.  If the
; file exists, it replaces the previous file in the buffer.

; 02/24/1996 DH: added default '*.*' in current directory if
;                no existing filename

; 03/29/1996 DH: input filename with wildcard character runs ASM32:MarkFile
;                via file_list instead of ASM32:PickFile

include	model.inc

public	load, edit_filename
extrn	qfname:near, tprintce:near, strlen:near
extrn	strchr:near, menuoption:near
extrn	strnchr:near, tedit:near
extrn	clearkey:near, getkey:near
extrn	strrchr:near, stricmp:near
extrn	error:near

extrn	new:near
extrn	yesno_message:near
extrn	swap_files:near
extrn	file_list:near

extrn	number_of_files:abs
extrn	file_data_ptr:dword
extrn	file_data_len:abs

temp_filename	equ	byte ptr [ebp-64]

include	dataseg.inc

; data for LOAD
extrn	filename:dword
extrn	dirty_bits:byte, rows:byte, warning:byte, inverse:byte
extrn	verify_msg:byte
star_dot_star	db '*.*',0
load_mess	db ' Load: ',0
load_len	equ $-load_mess-1

; data for READFILE
extrn	display_mode:byte
extrn	file_read_error:byte
extrn	filesel:word
extrn	filesiz:dword			; file size
extrn	buffersiz:dword
extrn	dirty_bits:byte
extrn	cur_posn:byte			; really a word
no_file		db 'file not found',0
@curseg	ends

include	codeseg.inc
load	proc	near
	enter	64,0
	cld
	mov	esi,filename		; point to existing filename

; if no existing filename, default to '*.*' in current directory
	mov	ebx,esi
	call	strlen
	test	ecx,ecx
	jnz	short l0
	lea	ebx,star_dot_star
	call	qfname			; ret: ESI -> drive:\path\*.*

; copy filename to temporary buffer
l0:	lea	edi,temp_filename
	push	ss
	pop	es
	mov	ecx,64/4
	rep	movsd

	test	dirty_bits,10000000b	; has the file has been changed?
	jz	short l1
	mov	ah,warning
	lea	esi,verify_msg
	call	yesno_message
	cmp	al,'N'
	je	load_exit

l1:
prompt_for_load:
	mov	esi,offset load_mess
	call	edit_filename
	cmp	ax,27			; Esc key?
	je	load_exit

; qualify the filename
l2:	mov	ebx,esi			; DS:[EBX] points to filename
	call	qfname
	mov	edi,ebx
	push	ds
	pop	es
	cld
	rep	movsb		; copy qualified filename to buffer
	mov	al,cl
	stosb

; look for wildcard characters
	lea	ebx,temp_filename	; DS:[EBX] points to filename
	mov	al,'?'		; look for wildcard characters
	call	strchr		; returns with CX = string length
	jnc	short load01	; if CF = 0, found the '?' character
	mov	al,'*'		;  else look for '*'
	call	strnchr
	jc	short load02		; no wildcards if CF = 1
load01:
; print qualified filespec
	mov	esi,ebx
	mov	dh,rows
	inc	dh
	mov	dl,load_len
	mov	ah,inverse
	call	tprintce
	call	file_list
;	jmp	short load_exit
	cmp	ax,0Dh
	je	prompt_for_load		; continue if Enter pressed
	jmp	short load_exit

load02:
	lea	edx,temp_filename
	call	ok_to_load		; can I load this file?
	jc	prompt_for_load

	and	dirty_bits,01111111b
	call	new
	lea	edx,temp_filename
	call	_readfile		; skip ok_to_load
	jc	l1			; ask for new filename if error

; copy temporary filename to file buffer
	mov	edi,filename
	lea	esi,temp_filename
	push	ds
	push	ds
	pop	es			; ES:[EDI] -> filename buffer
	push	ss
	pop	ds			; DS:[ESI] -> temporary buffer
	mov	ecx,64/4
	rep	movsd
	pop	ds
	or	dirty_bits,1
load_exit:
	clc
	leave
	ret

load	endp


edit_filename:
	or	dirty_bits,00010000b	; re-do FKey display
	mov	dh,rows
	inc	dh		; last row of screen
	xor	dl,dl
	mov	ah,inverse
	call	tprintce	; print prompt string
	add	dl,cl
	lea	esi,temp_filename
	mov	ecx,63
	mov	al,01000b	; clear input string if first key
				; not cursor control
	call	tedit
	ret


; READFILE.ASM for E32 - Copyright (C) 1994 - 1996 Douglas Herr
;  all rights reserved

; call with DS:[EDX] -> ASCIIZ filename

; 02/24/1996 DH: added checking for subdirectory if file not exist


CR	equ	0Dh
LF	EQU	0Ah

public	readfile
extrn	fexist:near, subexist:near
extrn	working:near
extrn	fileloadfar:near
extrn	display_screen:near
extrn	display_hex:near

extrn	error:near

readfile	proc	near
	call	ok_to_load		; is this a loadable file?
	jc	short exit		;  no, ret to prompt

_readfile:
	call	is_loaded		; file already loaded?
	jc	short _rf0		;  no, read it
	call	swap_files
	mov	fs,filesel
	ret

_rf0:
	call	working
	call	fileloadfar
	jnc	short r1
	lea	edx,file_read_error
	jmp	short bad_exit
r1:
	xchg	bx,filesel		; get old selector in BX
	mov	filesiz,eax
	mov	buffersiz,eax
	sys	RelMem
	or	dirty_bits,00100000b
	call	is_it_hex
	sbb	eax,eax
	mov	ah,al
	inc	al
	not	ah
	shl	al,2
	mov	display_mode,al
	and	ah,10
	mov	cur_posn,ah
	clc
	mov	fs,filesel
exit:
	ret

bad_exit:
	call	error
	ret


alphanum	equ	dword ptr [ebp-4]
notalpha	equ	dword ptr [ebp-8]

is_it_hex:
	enter	8,0
	push	es
	mov	ecx,100h
	cmp	filesiz,ecx
	jae	size_ok
	mov	ecx,filesiz
size_ok:
	jecxz	short end_test
	mov	es,filesel
	assume	es:nothing
	mov	edx,-1
	mov	ebx,filesiz
	push	ecx
	call	test_it
	pop	ecx
	jnc	end_test
	mov	ebx,edx			; EBX = -1
	neg	edx			; EDX = 1
	call	test_it

end_test:
	pop	es
	leave
	ret

test_it:
	xor	eax,eax
	mov	alphanum,eax
	mov	notalpha,eax
test_byte:
	add	ebx,edx
	mov	al,es:[ebx]
	cmp	al,'z'
	ja	short its_not_alpha
	cmp	al,0Dh
	je	short its_alpha
	cmp	al,0Ah
	je	short its_alpha
	cmp	al,' '
	jb	short its_not_alpha

its_alpha:
	inc	alphanum
	loop	test_byte
	jmp	short compare

its_not_alpha:
	inc	notalpha
	loop	test_byte

compare:
	mov	eax,notalpha
	cmp	eax,alphanum
	ret

readfile	endp


;
; test filename for load
; call with DS:[EDX] -> filename
;
ok_to_load:
	call	fexist		; file exist?
	jnc	short ok9	;  yup, proceed
	call	subexist	; is it a sub?
	jc	short ok1	;  no, do error stuff
	mov	ebx,edx		; filename ptr
	call	strlen		;  else add '*.*' to path & re-prompt
	mov	edi,ebx
	add	edi,ecx
	mov	al,'\'
	cmp	[edi-1],al	; have trailing backslash?
	je	short ok0	;  yup, don't add one
	stosb			;  else add trailing backslash
ok0:	
	lea	esi,star_dot_star
	movsd			; append '*.*' to end of path
	jmp	short ok8
ok1:
	lea	edx,no_file	; error message in READFILE.ASM
	call	error
ok8:
	stc
ok9:
	ret

;
; see if file is already loaded
; call with DS:[EDX] -> filename
;
is_loaded:

	pushad
	push	es
	mov	eax,ds
	mov	es,eax

	mov	esi,file_data_ptr
	mov	edi,edx			; ES:[EDI] -> filename to check
	mov	ecx,number_of_files
	mov	edx,file_data_len
	xor	eax,eax
	xor	ebx,ebx			; record index
loaded0:
	push	esi
	mov	esi,[esi]		; filename ptr
	cmp	esi,-1			; empty buffer?
	je	short empty
	cmp	byte ptr [esi],0	; NUL filename?
	je	short empty		;  new file, or empty
	call	stricmp			; compare name with file to load
	pop	esi
	je	short loaded8		; file IS loaded, exit
	push	esi
empty:
	pop	esi
loaded1:
	add	esi,edx			; point to next record
	inc	ebx			; record index
	loop	loaded0
	stc				; file not loaded, set CF
	jmp	short loaded9


; file IS loaded, clear CF
loaded8:
	clc
loaded9:
	pop	es
	mov	[StackEBX],ebx
	popad
	ret

@curseg	ends
	end
