; CURS_COL.ASM for E32

include	model.inc

public	cursor_col
extrn	find_start:near

CR	equ	0Dh
TAB	equ	09h

include	dataseg.inc
extrn	cursor:dword
extrn	cur_posn:word
extrn	columns:word
extrn	left_margin:word
extrn	dirty_bits:byte
@curseg	ends

include	codeseg.inc
;
; compute the correct column for the cursor.  No
; inputs.  On exit, cur_posn is set and DX has the row/col
;
cursor_col	proc	near
	push	ebp
	push	edi
	mov	esi,cursor
	call	find_start
	mov	ecx,cursor
	sub	ecx,esi

; set DL = -columns so I can use ZF as a flag to adjust left_margin
	mov	dl,byte ptr columns
	neg	dl
	jecxz	col_done

; use a similar trick for margin_count
	mov	di,left_margin	; DI = margin_count
	neg	di

; move constants to registers for speed
	mov	bp,ds		; data segment
	shl	ebp,16
	mov	bp,fs
	mov	dh,CR
	mov	bx,8
	mov	ah,TAB

cursor_loop:
	mov	ds,bp
	lodsb
	rol	ebp,16
	mov	ds,bp
	rol	ebp,16

	cmp	al,dh		; DH = CR
	je	short col_done
	cmp	al,ah		; AH = TAB
	jne	short not_a_TAB

	or	di,00000111b	; DI = margin_count
	js	short not_a_tab
	or	dl,00000111b
not_a_TAB:
	inc	di		; DI = margin_count
	jle	short out_of_window	; increment column only if margin_count > 0 
	inc	dl		; we're at next column now
	jnz	short out_of_window
	add	left_margin,bx	; adjust left_margin if column = 0
	add	di,bx		; DI = margin_count
	sub	dl,bl
	or	dirty_bits,1

out_of_window:
	loop	cursor_loop
col_done:
	add	dx,columns	; normalize

column_ok:
	clc
	mov	byte ptr cur_posn,dl	; store the column
	pop	edi
	pop	ebp
	ret
cursor_col	endp

@curseg	ends
	end
