#ifdef __IBMC__
#pragma strings(readonly)
#endif
/* strnicmp.c (emx+gcc) -- Copyright (c) 1990-1995 by Eberhard Mattes */

#include <string.h>

#include <os2/types.h>

INLINE int tolower (int c)
{
    if (c >= 'A' && c <= 'Z') 
        return c + 'a' - 'A';
    else
        return c;
}

int strnicmp (const char *string1, const char *string2, size_t count)
{
  int d;

  while (count != 0)
    {
      d = tolower ((unsigned char)*string1)
        - tolower ((unsigned char)*string2);
      if (d != 0 || *string1 == 0 || *string2 == 0)
        return d;
      ++string1; ++string2;
      --count;
    }
  return 0;
}
