#ifndef _ASM_GENERIC_BITOPS_H_
#define _ASM_GENERIC_BITOPS_H_

/*
 * For the benefit of those who are trying to port Linux to another
 * architecture, here are some C-language equivalents.  You should
 * recode these in the native assembly language, if at all possible.
 * To guarantee atomicity, these routines call cli() and sti() to
 * disable interrupts while they operate.  (You have to provide inline
 * routines to cli() and sti().)
 *
 * Also note, these routines assume that you have 32 bit integers.
 * You will have to change this if you are trying to port Linux to the
 * Alpha architecture or to a Cray.  :-)
 * 
 * C language equivalents written by Theodore Ts'o, 9/26/92
 */
INLINE void cli(void) {_disable();}
INLINE void sti(void) {_enable();}

INLINE int set_bit(int nr,int * addr)
{
	int	mask, retval;

	addr += nr >> 5;
	mask = 1 << (nr & 0x1f);
	cli();
	retval = (mask & *addr) != 0;
	*addr |= mask;
	sti();
	return retval;
}

INLINE int clear_bit(int nr, int * addr)
{
	int	mask, retval;

	addr += nr >> 5;
	mask = 1 << (nr & 0x1f);
	cli();
	retval = (mask & *addr) != 0;
	*addr &= ~mask;
	sti();
	return retval;
}

INLINE int test_bit(int nr, int * addr)
{
	int	mask;

	addr += nr >> 5;
	mask = 1 << (nr & 0x1f);
	return ((mask & *addr) != 0);
}


/*
 * find the first occurrence of byte 'c', or 1 past the area if none
 */
INLINE void * memscan(void * cs, long c, long n) {
    unsigned char  *x  = (unsigned char *)cs;
    unsigned char   cc = (unsigned char)c;
    long i = 0;

    while ((x[i] != cc) && (i < n)) i++;
    return (x[i] == cc ? x + i : x + n);
}

INLINE unsigned long ffz(unsigned long word) {
    unsigned long temp = 0;
    word = ~word;
    while (!test_bit(temp, (int *)&word)) temp++;
    return temp;

}

INLINE int find_first_zero_bit(void *addr, unsigned size) {
    unsigned long i = 0L, j = 0L;
    unsigned long *x = (unsigned long *)addr;
    size = size / 32L;
    while ((i < size) && (x[i]==~0L)) i++;
    if  (i == size) return (i << 5L);
    while ((j < 32L) && ((x[i] & (1L << j)) != 0L)) j++;
   return ((i << 5L) + j );
}

INLINE int find_next_zero_bit (void * addr, int size, int offset)
{
	unsigned long * p = ((unsigned long *) addr) + (offset >> 5L);
	long set = 0L, bit = offset & 31L, res;
	unsigned long q = (*p) >> bit;

	if (bit) {
            set = find_first_zero_bit(&q, 32L);
            if (set < 32L - bit) {
                return set + offset;
            }
            set = 32L - bit;
            p++;
	}
	/*
	 * No zero yet, search remaining full bytes for a zero
	 */
	res = find_first_zero_bit (p, size - 32L * (p - (unsigned long *) addr));

	return (offset + set + res);
}


#endif /* _ASM_GENERIC_BITOPS_H */
