#ifdef __IBMC__
#pragma strings(readonly)
#endif
//
// $Header: D:/32bits/ext2-os2/RCS/files.c,v 1.1 1996/09/22 23:13:48 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM 
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <os2/DevHlp32.h>
#include <os2/os2proto.h>
#include <os2/errors.h>

#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <linux/ext2_proto.h>
#include <os2/log.h>         /* Prototypes des fonctions de log.c                      */
#include <os2/files.h>       /* Prototypes des fonctions de files.c                    */
#include <os2/fnmatch.h>

//
// These routines will be eventually rewritten and splitted between ext2/namei.c
// (namei()), vfs/namei.c (dir_namei, open_namei, ....) and vfs/open.c (do_open ...)
//

struct file *_open_by_inode(struct super_block * p_volume, UINT32 ino_no, UINT32 openmode)
{
    struct file   *      p_file;
    int           rc;

#ifdef FS_TRACE
    kernel_printf("open_by_inode( %lu )", ino_no);
#endif
    /*******************************************************************/
    /*** Allocates a file descriptor                                 ***/
    /*******************************************************************/
    if ((p_file = get_empty_filp()) == 0) {
        fs_err(FUNC_OPEN_BY_INODE, FUNC_ALLOC_HFILE, 0, FILE_FILES_C, __LINE__);
        return 0;
    }
    /*******************************************************************/

    /*******************************************************************/
    /*** Gets the v-inode (if already exists) or allocates a new one ***/
    /*******************************************************************/
    if ((p_file->f_inode = iget(p_volume, ino_no)) == NULL) {
        fs_err(FUNC_OPEN_BY_INODE, FUNC_GET_VINODE, rc, FILE_FILES_C, __LINE__);
        put_filp(p_file);
        return 0;
    }
    /*******************************************************************/


    p_file->f_pos            = 0;
    p_file->f_mode           = openmode;
    if (p_file->f_inode->i_op)
        p_file->f_op = p_file->f_inode->i_op->default_file_ops;

    return p_file;
}

int vfs_close(struct file *f)
{
    int           rc;

#ifdef FS_TRACE
    kernel_printf("close( %lu )", f->f_inode->i_ino);
#endif

    if (f->f_inode)
        iput(f->f_inode);

    if ((rc = put_filp(f)) != NO_ERROR) {
        fs_err(FUNC_CLOSE, FUNC_FREE_HFILE, rc, FILE_FILES_C, __LINE__);
        return rc;
    }

    return NO_ERROR;
}






struct file *_open_by_name(struct super_block * p_volume, pchar pName, UINT32 openmode)
{
    char        *left;
    char        *right;
    char        *pNom;
	int fn_flag;
    char        *pTmp, *pTmpUpper1, *pTmpUpper2;
    struct file    *    p_file;
    int          ok;
    int          Fin;
    int          FinPath;
    UINT32       ino_no;
    struct dirent          Dir;
    int          rc;

#ifdef FS_TRACE
    kernel_printf("open_by_name( %s )", pName);
#endif
    /*******************************************************************/
    /*** We allocate a working buffer                                ***/
    /*******************************************************************/
//    if ((pNom = G_malloc(3 * CCHMAXPATH)) == 0) {
//        fs_err(FUNC_OPEN_BY_NAME, FUNC_G_malloc, rc, FILE_FILES_C, __LINE__);
//        return 0;
//    } /* end if */
    if ((rc = DevHlp32_VMAlloc(3 * CCHMAXPATH, VMDHA_NOPHYSADDR, VMDHA_SWAP, __StackToFlat(&pNom))) != NO_ERROR) {
        fs_err(FUNC_OPEN_BY_NAME, FUNC_G_malloc, rc, FILE_FILES_C, __LINE__);
        return 0;
    }
    memset(pNom, '\0', CCHMAXPATH);
    pTmpUpper1 = pNom + CCHMAXPATH;
    pTmpUpper2 = pTmpUpper1 + CCHMAXPATH;
    /*******************************************************************/

    pTmp = DecoupePath(pName, pNom);
    /*******************************************************************/
    /*** If it is the root directory we've finished                  ***/
    /*******************************************************************/
    if (pTmp == 0) {
        /*******************************************************************/
       /*** Frees the working buffer                                    ***/
        /*******************************************************************/
        if ((rc = DevHlp32_VMFree(pNom)) != NO_ERROR) {
            fs_err(FUNC_OPEN_BY_NAME, FUNC_G_free, rc, FILE_FILES_C, __LINE__);
            return 0;
        } /* end if */
        /*******************************************************************/
        return _open_by_inode(p_volume, EXT2_ROOT_INO, openmode);
    } /* end if */
    /*******************************************************************/

    /*******************************************************************/
    /*** We loop on the path components                              ***/
    /*******************************************************************/
    ino_no  = EXT2_ROOT_INO;
    FinPath = 0;
    while (FinPath == 0) {
        /*******************************************************************/
        /*** Opens the "." file of the directory                         ***/
        /*******************************************************************/
        if ((p_file = _open_by_inode(p_volume, ino_no, OPENMODE_READONLY)) == 0) {
            fs_err(FUNC_OPEN_BY_NAME, FUNC_OPEN_BY_INODE, 0, FILE_FILES_C, __LINE__);
            if ((rc = DevHlp32_VMFree(pNom)) != NO_ERROR) {
                fs_err(FUNC_OPEN_BY_NAME, FUNC_G_free, rc, FILE_FILES_C, __LINE__);
                return 0;
            } /* end if */
            return 0;
        } /* end if */
        /*******************************************************************/

            ok = 0;
            Fin = 0;
            /*** Lookup inside the "." file of the parent directory ***/
            while (Fin == 0) {
                if (VFS_readdir(p_file, __StackToFlat(&Dir)) != 0) {
                    Fin = 1;
                } else {
                    /*
                     * We do a case insensitive comparaison if needed
                     */
                    if (openmode & OPENMODE_DOSBOX) {
//                        FSH_UPPERCASE(pNom, CCHMAXPATH, pTmpUpper1);
//                        left  = pTmpUpper1;
//                        FSH_UPPERCASE(Dir.d_name, CCHMAXPATH, pTmpUpper2);
//                        right = pTmpUpper2;
	          	fn_flag = _FNM_OS2 | _FNM_IGNORECASE;
                    } else {
//                        left  = pNom;
//                        right = Dir.d_name;
			fn_flag = _FNM_OS2;
                    }
//                    if (strcmp(left, right) == 0) {
       	            if (fnmatch(pNom, __StackToFlat(Dir.d_name), fn_flag) == 0) {
                        Fin = 1;
                        ok  = 1;
                    } /* end if */
                } /* end if */
            } /* end while */
            /*** si pas trouv on retourne 0 ***/
            if (ok == 0) {
                if ((rc = vfs_close(p_file)) != NO_ERROR) {
                    fs_err(FUNC_OPEN_BY_NAME, FUNC_CLOSE, rc, FILE_FILES_C, __LINE__);
                    return 0; /*** FSH_INTERR() ***/
                } /* end if */
               if ((rc = DevHlp32_VMFree(pNom)) != NO_ERROR) {
                   fs_err(FUNC_OPEN_BY_NAME, FUNC_G_free, rc, FILE_FILES_C, __LINE__);
                   return 0;
               } /* end if */
//               kernel_printf("open_by_name() ok = 0 - pTmp = %s - pName = %s - pNom = %s", pTmp, pName, pNom);
               return 0;
            } /* end if */
            /*** If found we go down a level ***/
            ino_no = Dir.d_ino;
            if ((rc = vfs_close(p_file)) != NO_ERROR) {
                fs_err(FUNC_OPEN_BY_NAME, FUNC_CLOSE, rc, FILE_FILES_C, __LINE__);
                return 0; /*** FSH_INTERR() ***/
            } /* end if */

        if ((pTmp = DecoupePath(pTmp, pNom)) == 0) {
            FinPath = 1;
        } /* end if */

    } /* end while */
    /*******************************************************************/

    /*******************************************************************/
    /*** Frees the working buffer.                                   ***/
    /*******************************************************************/
    if ((rc = DevHlp32_VMFree(pNom)) != NO_ERROR) {
        fs_err(FUNC_OPEN_BY_NAME, FUNC_G_free, rc, FILE_FILES_C, __LINE__);
        return 0;
    } /* end if */
    /*******************************************************************/

    return _open_by_inode(p_volume, ino_no, openmode);
}

