; Template file: LIST.APL
; Type         : AreaMgr
;
; This template generates one list of all the fileechos with the access
; code in the first collumn.
;
@assign(@count,0)
@groupbegin
@assign(@doneheader,"No")
@areabegin
@test(@doneheader,=,"No")
@test(@count,=,0)
  The following is a list of the fileechos and your access level:
@end

  Group   : @group
  Comment : @groupname

  Fileecho      Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
@echostat @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
@end
@end
@test(@count,=,0)
  You are not connected to any fileechos
@else

  You are connected to @count fileecho(s)

"+"  You are connected to the fileecho and only receive files from our system.
"*"  You are connected to the fileecho and only send files to our system.
"&"  You are connected to the fileecho and both send and receive files.
"-"  You do not have access to the fileecho.
" "  You are not connected to the fileecho.
@end

---
 * Origin: use %HELP for help using the AreaMgr in ALLFIX (@akatouse)
