#ifndef __MDL_HEADER__
#define __MDL_HEADER__

#include "header.h"

#define IDPO ((dword)(('O'<<24)+('P'<<16)+('D'<<8)+('I')))

typedef struct {
  dword unknown;
  dword width;
  dword height;
  byte *data;
} raw_image;

typedef struct {
  float x,y,z;
} vector;

typedef struct {
  dword onseam;
  dword s;    // convert to u/v later
  dword t;
} tvert;

typedef struct {
  dword front;
  dword vert[3];
} tri;

typedef struct {
  byte x,y,z;  // packed coords
  byte normal; // index
} vert;

typedef struct {
  dword unknown;
  vert min;
  vert max;
  byte name[16];
  vert *vert_ptr;
} frame;

typedef struct {
   dword id;
   dword version;
   vector scale;
   vector origin;
   float radius;
   vector eye_pos;
   dword skin_num;
   dword skin_width;   // divisible by 8
   dword skin_height;  // same
   dword vert_num;
   dword tri_num;
   dword frame_num;
   dword sync_type;
   dword flags;
   float size;
} mdl_header;

typedef struct {
 mdl_header head;
 raw_image *rimg;
 tvert *tvert_ptr;
 tri *tri_ptr;
 frame *frame_ptr;
} mdl_object;

//
word frame_info ( frame *frame_ptr, mdl_header *head );
word load_mdl ( byte *filename, mdl_object *obj );
word free_mdl ( mdl_object *obj );

#endif

