/* LOG.CMD - REXX program to manage Lora's logfile, ver. 1.70
  - 25 October, 1996 by Elliott Goodman, 1:2004/102 -
*/

/* check whether RxFuncs are loaded. If not, load them. */       
                                                                 
if RxFuncQuery('SysLoadFuncs') then                              
do                                                               
        call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
        call SysLoadFuncs                                        
end                                                              

path.1 = 'd:\lora'		/* set up directories */
path.2 = 'd:\lora\lang'

/* call the date function and get a unique number based on it */
day_index = SPECIFIED_DATE_IN_DAYS( DATE('U') )
day_index = day_index - 1	/* if it's after midnight, when we are
				going to do our stuff, we want
				yesterday's date */

init_file = 'd:\lora\lang\init.log' /* file to initialize lora.zip */
call SysFileDelete(init_file)            /* kill old file, if present */ 
door_file = 'd:\lora\lang\doors.txt'

m_txt = 'This is Lora.Zip'
call lineout init_file, m_txt

call directory path.2		/* move to proper dir */
old = 0				/* flag to indicate oldlora.zip exists */

call SysFileTree path.2||'\oldlora.zip', files, 'F'
if files.0 \= 0 then
  do
	old = 1			/* if it exists, set flag */
  end

/* all this is to get a month index for the current lora.zip file */
call SysFileTree path.2||'\lora.zip', files, 'F'
if files.0 = 0 then
  do
	'zip lora.zip init.log'
  end
  else
  do
      parse var files.1,
         file_date,                  
         file_time,                  
         file_size,                  
         file_attr,                  
         file_name                   

	parse var file_date,
	  mm '/',
	  dd '/',
	  yy

	lora_zip_month = mm
  end

/* set initial conditions: make sure a lora.log exists in the \lang subdir */
call SysFileTree path.2||'\lora.log', files, 'F'
if files.0 = 0 then 
  do
	'copy d:\lora\lora.log d:\lora\lang'
	'del d:\lora\lora.log'
	'exit'
  end

/* this is an error condition that should never happen */
if files.0 > 1 then
  do
	say 'More than one log file in d:\lora\lang'
	'exit'
  end

/* okay, files.0 = 1 (one lora.log file in \lora\lang exists)
this is all to get the date of the file */
do
      parse var files.1,         /* log file in d:\lora\lang */
         file_date,                  
         file_time,                  
         file_size,                  
         file_attr,                  
         file_name                   
      file_name = STRIP( file_name ) 
	lang_log = file_name
	lang_date = file_date

/* now get the date of the current lora.log file in lora's subdir */
	call SysFileTree path.1||'\lora.log', files, 'F'
      parse var files.1,         /* log file in d:\lora */
         file_date,                  
         file_time,                  
         file_size,                  
         file_attr,                  
         file_name                   
      file_name = STRIP( file_name ) 
	lora_log = file_name
	lora_date = file_date

/* set a month index for the logfile for comparison with lora.zip */
	parse var file_date,
	  mm '/',
	  dd '/',
	  yy

	lora_month = mm

/* if dates are equal, it's the same day so just append the log to
the save log and erase the current one */
      if lora_date = lang_date then
	do
		'cd \lora\lang'
		'copy lora.log+d:\lora\lora.log lora.log'
		'del d:\lora\lora.log'
		'exit'
	end

/* okay, dates are NOT equal. That means a new day has rolled by.
First, now test if a new month has also passed. If so.... */
if lora_month \= lora_zip_month then
  do
/* ...and we have an oldlora.zip file (a month's worth of logs)
delete it and rename the current month's lora.zip to oldlora.zip */
	if old = 1 then
	  do
		'del d:\lora\lang\oldlora.zip'
	  end
	'ren d:\lora\lang\lora.zip oldlora.zip'

/* attempt to run in background.... */
        'detach d:\lora\lang\eom.cmd > d:\lora\lang\eom.rpt'
/*        call "d:\lora\lang\eom.cmd" */

/* create a new lora.zip with a 20 byte nul file so we can
move lora.logs into it without error */
	'zip lora.zip init.log'
  end

/* delete yesterday's door tracking file */
  call SysFileDelete(door_file)
  call SysSleep 1

/* now, finally, create a unique name for yesterday's logfile and
move it into our zip file. */	
      'cd \lora\lang'

        say 'Door Tracker....'
        call Door_tracker
        call SysSleep 1
/* might need to change for YOUR system */
        'copy d:\lora\lang\doors.txt d:\lora\misc\bullet10.bbs'

        say "Running MSGCNT.CMD. Please wait...." 
        call "d:\lora\lang\msgcnt.cmd"            

        say "Running CALLERS.CMD...."  
        call "d:\lora\lang\callers.cmd"

        say 'Remove routine....'
	call remove_stuff

        say 'Zipping....'
      temp_name = day_index||'.log'
      'ren d:\lora\lang\lora.log '||temp_name
      'zip -m lora.zip '||temp_name

/* copy today's logfile into our storage area and delete the 
current one */
      'copy d:\lora\lora.log d:\lora\lang'
      'del d:\lora\lora.log'
      'exit'
end

'exit'

/* end of LOG.CMD */

/*------------------------------------------------*/  
/* Convert calendar date to consistent date index 		   */  
/*------------------------------------------------*/  
SPECIFIED_DATE_IN_DAYS:                               
   Procedure                                          
                                                      
parse arg,                                            
   mm '/',                                            
   dd '/',                                            
   yy                                                 
                                                      
days_by_month = '31 28 31 30 31 30 31 31 30 31 30 31' 
current_number_of_days = (yy * 365) + dd              
do m = 1 while m < mm                                 
   current_number_of_days = current_number_of_days +, 
      WORD( days_by_month, m )                        
end                                                   
return current_number_of_days                         
/* the above procedure was written by Dick Goran. I could come up
with something that does the same thing but I like the way he does
it so copied it. Doubt he'd mind since he posted it in a public echo! */

/*------------------------------------------------*/  
/* removes lines from the log with certain key words         */
/*------------------------------------------------*/  
Remove_stuff:

/* we're in \lora\lang and we have one lora.log file there.
we're going to move the file into the zip archive so this
is only done once a day, just before the previous day's logfile
is zipped. */

/* time process */
call time('R')

/* first, set up the phrases we DON'T want */

phrase. = ''
phrase.1 = 'UL-Z/32'
phrase.2 = 'Nothing to send'
phrase.3 = 'sharing enabled'
phrase.4 = 'STATS:'
phrase.5 = 'Ring'
phrase.6 = 'Deleted DIR Xflag'
phrase.7 = 'ALLFIX+'
phrase.8 = 'EMSI'
phrase.9 = 'Type=2+'
phrase.10 = 'Return code'
phrase.11 = 'Remote Uses'
phrase.12 = 'Offer:'
phrase.13 = 'Aka:'
phrase.14 = 'D:\LORA\INET.CMD'
phrase.15 = 'Flags:'
phrase.16 = 'DL-Z/32'

/* Total number of phrases */
R_S_Items = 16

/* create file to store phrase frequencies */
remove_file = 'D:\LORA\LANG\1REMOVE.TXT'
/* remove previous Output file, if present */  
/* call SysFileDelete(remove_file) */

talley. = ''

/* zero talley scores */
do talley_count = 1 to R_S_Items
    talley.talley_count = 0
    end

/* track # of successful finds */
skip_line = 0

'ren lora.log lora.bak'		/* save it, just in case */
in_name = 'lora.bak'		/* set up work names */
out_name = 'lora.log'
do until lines(in_name) = 0		/* read in each line */
  work_line = linein(in_name)		/* current line to examine */
  found_phrase = 0			/* zero flag */
  do i = 1 to R_S_Items		/* cycle thru phrases */
  j = wordpos(phrase.i, work_line)	/* look for the phrase */
  if j \= 0 then do			/* phrase found */
      found_phrase = 1		/* set flag */
      talley.i = talley.i + 1
      leave i				/* stop looking in this line */
      end	/* end if j \= */
  end		/* end do i */
  if found_phrase = 1 then do		/* if found, don't write line */
      skip_line = skip_line + 1
      iterate				/* skip to next line */
      end	/* end if found */
  else do				/* phrase not found */
      call lineout out_name, work_line	/* write line */
      end	/* end else do */
end		/* end do until */
call lineout in_name			/* close files */
call lineout out_name
'del lora.bak'			/* done with backup file */

/* talley & # of lines not written */
m_txt = 'Phrase Frequencies'
call lineout remove_file, m_txt
m_txt = date('U') 
m_txt = 'Date:' m_txt
call lineout remove_file, m_txt
m_txt = ''
call lineout remove_file, m_txt
m_txt = 'Use to tune this module; put most frequent phrases first'
call lineout remove_file, m_txt
m_txt = ''
call lineout remove_file, m_txt


do talley_count = 1 to R_S_Items
    m_txt = 'Phrase' || talley_count '=' talley.talley_count 
    call lineout remove_file, m_txt
    end

m_txt = "Lines skipped:" skip_line
call lineout remove_file, m_txt

/* Determine time elapsed */                                        
time_spent = trunc( time('E'))

/* calculate a "kill rate" to monitor tuning progress */
kill_rate = skip_line / time_spent
kill_rate = trunc(kill_rate, 2)
m_txt = 'Lines skipped per second:' kill_rate
call lineout remove_file, m_txt

m_txt = 'Time:'
if time_spent > 3599 then do
  hours = time_spent % 3600
  time_spent = time_spent - (3600 * hours)
  if hours > 1 then
    m_txt = m_txt hours 'hours'
  else
    m_txt = m_txt hours 'hour'
  end

if time_spent > 59 then do
  minutes = time_spent % 60
  time_spent = time_spent - (60 * minutes)
  if minutes > 1 then
    m_txt = m_txt minutes 'minutes'
  else
    m_txt = m_txt minutes 'minute'
  end

if time_spent > 1 then
  m_txt = m_txt time_spent 'seconds.'
else
  m_txt = m_txt time_spent 'second.'

call lineout remove_file, m_txt

Call SysSleep 2
Call lineout remove_file
return				/* continue processing lora.log */

/*------------------------------------------------*/  
/* Door tracker - Tracks door usage                            */
/*------------------------------------------------*/  

Door_tracker:  Procedure

phrase = 'External'                                                   
phrase2 = 'Returned'
phrase3 ='D:\LORA\LORD1.BAT'
phrase4 = 'D:\LORA\DOORS\EZELS.BAT'
phrase5 ='D:\LORA\PLANET1.BAT'
phrase6 = 'Write'
phrase7 = 'Connect FAX'
phrase8 = 'Calls=1,'
phrase9 = 'System call'
phrase10 = 'Receiving' 
phrase12 = 'D:\LORA\DOORS\EZVOTE\EZVOTE.BAT'
phrase13 = 'D:\LORA\DOORS\SPIKE\SPIKE.BAT'  
phrase14 = 'D:\LORA\ICECHAT.BAT'
phrase15 = 'D:\LORA\DOORS\USURP\USURP.BAT'
phrase16 = 'D:\LORA\DOORS\INET\INET.EXE'
phrase17 = 'D:\LORA\BMAST.BAT'
phrase19 = 'D:\LORA\WOT1.BAT'
phrase20 = 'D:\LORA\SDL.BAT'
phrase21 = 'D:\LORA\TC.BAT'
phrase22 = 'D:\LORA\FILE\TOSS.CMD'

color = "[0;1;33m[2J[18C"
count = 0                       /* count of times door is entered */
ice = 0
lord = 0                                                            
planet = 0                                                          
ezrom = 0                                                           
ezvote = 0 
spike = 0  
chat = 0
bota = 0
inet = 0
bmast = 0
wot = 0
sdl = 0
top = 0
olr = 0
fax_count = 0
Sys_Txt = 'No System Calls??'
BBS_calls = 0
max_time = (24 * 3600)                                                
total_time = 0                                                        
save_file = 'd:\lora\lang\doors.txt'                                  
total_hours = 0                                                       
total_minutes = 0                                                     
total_seconds = 0                                                     

m_txt = color                                                                      
call lineout save_file, m_txt                                         
m_txt = date('U')                                                     
call lineout save_file, m_txt                                         
m_txt = "--------"
call lineout save_file, m_txt

in_name = 'lora.log'            /* set up work names */

do until lines(in_name) = 0             /* read in each line */
  work_line = linein(in_name)           /* current line to examine */
  j = wordpos(phrase, work_line)      /* look for the phrase */
  if j \= 0 then do                     /* phrase found */
      next_line = linein(in_name)
      k = wordpos(phrase2, next_line)
      if k \= 0 then do
/* Okay, work_line has 'External' in it and next_line has 'Returned' in it.
Therefore, a user has gone to a door and returned. Now, let's parse the lines */

        count = count + 1
/* find out which door was run */                             
                                                              
        n = wordpos(phrase3, work_line) /* Test for Legend */ 
          if n \= 0 then
            lord = lord + 1
                                                              
        n = wordpos(phrase4, work_line) /* Test for EZ-Rom */
          if n \= 0 then
            ezrom = ezrom + 1
                                                              
        n = wordpos(phrase5, work_line) /* Test for Planets */
          if n \= 0 then
            planet = planet + 1

        n = wordpos(phrase12, work_line)   /* Test for EZ-Vote */ 
          if n \= 0 then
            ezvote = ezvote + 1
                                                                  
        n = wordpos(phrase13, work_line)  /* test for Spiked! */  
          if n \= 0 then
            spike = spike + 1

        n = wordpos(phrase14, work_line)  /* test for IceChat */
          if n \= 0 then
            chat = chat + 1

        n = wordpos(phrase15, work_line)  /* test for Usurper */
          if n \= 0 then
            bota = bota + 1

        n = wordpos(phrase16, work_line)  /* test for Inet */
          if n \= 0 then
            inet = inet + 1

        n = wordpos(phrase17, work_line)  /* test for BoardMaster */
          if n \= 0 then
            bmast = bmast + 1

        n = wordpos(phrase19, work_line)  /* World of Tears */
          if n \= 0 then
            wot = wot + 1

        n = wordpos(phrase20, work_line)  /* Stardock Loco */
          if n \= 0 then
            sdl = sdl + 1

        n = wordpos(phrase21, work_line)  /* Top Cop */
          if n \= 0 then
            top = top + 1

        n = wordpos(phrase22, work_line)  /* TOSS.CMD */
          if n \= 0 then
            count = count - 1

        parse var work_line ':' start_time junk
        parse var next_line ':' end_time junk
        parse var start_time shour ':' smin ':' ssec
        parse var end_time ehour ':' emin ':' esec
        stotal = (3600 * shour) + (60 * smin) + ssec
        etotal = (3600 * ehour) + (60 * emin) + esec
        if stotal > etotal then
          this_time = (max_time - stotal) + etotal
        else
          this_time = etotal - stotal
        total_time = total_time + this_time

        end /* k \= */
      k = wordpos(phrase6, next_line)
      if k \= 0 then do
	ice = ice + 1
        count = count + 1
      end /* if k \= 0 */     

   end       /* end if j \= */

/* check for a few other lines in the log */
    else do                           

/* check for offline messages written */
      j = wordpos(phrase6, work_line) 
      if j \= 0 then                  
        olr = olr + 1

/* check for fax calls */
      j = wordpos(phrase7, work_line) 
      if j \= 0 then                  
        fax_count = fax_count + 1     

/* check for new callers. if found, announce in track file */
      j = wordpos(phrase8, work_line)                              
      if j \= 0 then                                               
         do                                                        
           parse upper var work_line . . first_name last_name 'OFF-LINE.' dummy
           m_txt = "New caller: " first_name last_name
           call lineout save_file, m_txt
           end /* j \= 0 */

/* track high system call number */
       j = wordpos(phrase9, work_line)
       if j \= 0 then
       do
           parse var work_line . . Sys_Txt
           BBS_calls = BBS_calls +1
           end

/* monitor files received */
        j = wordpos(phrase10, work_line)
        if j \= 0 then
        do
            parse var work_line . . to_where dummy 
            select                                           
               when left(to_where, 13) = 'FILE\UNCHECK\' then do
                  m_txt = 'File Uploaded:' to_where              
                  call lineout save_file, m_txt
                  end
               otherwise                                     
                  iterate                                    
               end                                           
            end

      end /* else j */

end             /* end do until */
call lineout in_name                    /* close files */

/* save high system call number */
m_txt = "BBS Calls:" BBS_calls || ", High" || Sys_Txt
call lineout save_file, m_txt

if total_time > 3600 then do
  total_hours = total_time % 3600
  total_time = total_time // 3600
  end

if total_time > 60 then do
  total_minutes = total_time % 60
  total_time = total_time // 60
  end

total_seconds = total_time

/* change total to EXCLUDE Ice Edit */
/* count = count - ice */

m_txt = "Total times in doors yesterday =" count
call lineout save_file, m_txt
m_txt = "LORD =" lord "EZ-ELS =" ezrom "EZ-Vote =" ezvote
call lineout save_file, m_txt
m_txt = "Spiked! =" spike "Usurper =" bota "Planets =" planet
call lineout save_file, m_txt
m_txt = "Bmast'r =" bmast  "World of Tears =" wot
call lineout save_file, m_txt
m_txt = "Stardock Loco =" sdl "Top Cop! =" top
call lineout save_file, m_txt
m_txt = " "
call lineout save_file, m_txt

m_txt = "Time in doors: Hours:" total_hours||", Minutes:" total_minutes
call lineout save_file, m_txt

m_txt = " "
call lineout save_file, m_txt

if ice = 1 then                        
   m_txt = "Ice Edit wrote" ice "message." 
else                                   
   m_txt = "Ice Edit wrote" ice "messages."
call lineout save_file, m_txt

if olr = 1 then
   m_txt = "One Offline message received."
else
   m_txt = olr "Offline messages received."
call lineout save_file, m_txt

if chat = 1 then                      
   m_txt = "Ice Chat called" chat "time." 
else                                  
   m_txt = "Ice Chat called" chat "times."
call lineout save_file, m_txt

if inet = 1 then                      
   m_txt = "Inet called" inet "time." 
else                                  
   m_txt = "Inet called" inet "times."
call lineout save_file, m_txt

m_txt = "Faxes received:" fax_count
call lineout save_file, m_txt
m_txt = "------------------------------"
call lineout save_file, m_txt
call lineout save_file

return
