/* STARTPF - START at Position with Font */

os2language = 'ENGLISH'     /* enter your OS/2's language here!   */
                            /* supported values: ENGLISH, DEUTSCH */
                            
Parse Upper arg arg1 .

If arg1='SETXYWH' Then      /* recursively called ! */
  Do
    Parse arg arg1 mode x y w h
    '@d:\os2\mode' mode            /* set video mode */
    '@setwin move' x y      /* set xy coordinate of window */
    '@setwin size' w h      /* set wh size of window */
  End
Else                        /* User called */
  Do
    Parse arg '"'title'"' mode x y w h font runcmd

    If RxFuncQuery('SysLoadFuncs')=1 Then
      Do
        Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
        Call SysLoadFuncs
      End

    If Pos('X', translate(font))>0 Then
      Do
        Parse Upper Value font With fh 'X' fw
        fontsize=d2c(fw*256+fh)
      End
    Else
      Signal Help

    If translate(os2language)='ENGLISH' Then
      tag='~Font Size...'
    Else
    If translate(os2language)='DEUTSCH' Then
      tag='Schrif~tartgre...'
    Else
      Signal Help

    savesize=SysIni('USER', 'Shield', tag)       /* save user ini font size  */
    call SysIni 'USER', 'Shield', tag, fontsize  /* modify font size in ini  */
    '@START "'title'" /WIN /N' runcmd /*run!*/
    call SysIni 'USER', 'Shield', tag, savesize  /* restore font size in ini */
    /* call SysSleep 5 */
  End
Exit 0

Help:
  Say 'STARTPF - START at Position and select Font'
  Say 'Freeware by Thomas Waldmann, using SETWIN of Michael Thompson.'
  Say
  Say 'Usage: startpf "title" mode x y w h font'
  Say
  Say '  title    = Window title'
  Say '  mode     = argument for mode command e.g.: co80,25 or co80,50'
  Say '  x y      = Window x/y pixel coordinates 0/0 is bottom left'
  Say '  w h      = Window width / height in pixels'
  Say '  font     = Font for window (8x8, 10x6, ...)'
  Say
  call charout ,'Press any key to exit ...'
  Pull Dummy
  Exit 1

