/*
//	$Id: ygrep.h 1.12 1996/06/17 22:01:30 Y.Roumazeilles Exp Y.Roumazeilles $
//
//	(C) 1992-93-94-95-96 Yves Roumazeilles
//
//      Version 5.0
*/

#ifndef	__YGREP_H__
#define	__YGREP_H__	
#ifdef __cplusplus
extern "C" {
#endif


#ifdef	WINVER
#define	YGCALL	FAR PASCAL
#else
#define	YGCALL	
#endif

WORD	YGCALL	YGrepVersion( void );
BOOL	YGCALL	YGrepIsDebug( void );
void	YGCALL	YGrepMessages( BOOL bMessagesAllowed );




/* YGrep Search Engine Error Codes */
#define AGERR_UNKNOWN_TYPE		-1
#define AGERR_NO_ERROR			0
#define AGERR_STATE			1
#define AGERR_ALLOC_MEM			2
#define AGERR_TOO_SHORT			3
#define AGERR_TOO_LONG			4
#define AGERR_NO_PREVIOUS		5
#define AGERR_NO_PATTERN		6

#define RGERR_MUNGED_AUTO		20
#define RGERR_MISS_BRACKET		25
#define RGERR_EMPTY_ENCL		26
#define RGERR_ILLEGAL_ENCL		27
#define RGERR_TOO_MANY_PAR		28
#define RGERR_NULL_IN_PAR		29
#define RGERR_UNMATCHED			30
#define RGERR_NULL_IN_CRO		31
#define RGERR_CYCLICAL_REF		32
#define RGERR_UNDETERM_REF		33
#define RGERR_UNMATCHED_PAR		34

#define	MATCH		0
#define	MISMATCH	1
#define	EXACTMATCH	2
#define	MAXSYM		256	/* Size of the alphabet (in chars) */
#define	WORD_SIZE	512	/* (in bits) */
#define MAXTAG		10

#include	"bitlist.h"

typedef struct tagAGrepInfo {
	int	iErrorCode;
	char	cPat[WORD_SIZE];
	LPSTR	TagStart[MAXTAG];
	LPSTR	TagEnd[MAXTAG];
	int	bMatchCase;
	int	bMessages;
	BLIST	uMask;		/* internal structures */
	BLIST	uOvMask;
	BLIST	uLimit;
	BLIST	blState;	/* temporary AGrep() structures */
	BLIST	blOverflow;
	BLIST	blTemp;
	BLIST	uTable[MAXSYM];	/* characteristic vector table */
	int	iBitsPerState;
	int	iWordSize;	/* actual word size of BLIST's */
	int	iType;		/* MATCH or MISMATCH */
	char	cUPat[WORD_SIZE];
} AGREPINFO;
#ifdef	WINVER
typedef	AGREPINFO*	PAGREPINFO;
typedef	AGREPINFO FAR*	LPAGREPINFO;
#else
typedef	AGREPINFO*	PAGREPINFO;
typedef	AGREPINFO*	LPAGREPINFO;
#endif

int	YGCALL	CompileAGrep( LPCSTR GrepString, int k, BOOL bMatchCase, LPAGREPINFO pGI );
int	YGCALL	AGrep( LPCSTR StringToSearch, LPAGREPINFO pGI );
int	YGCALL	AGrepInit( LPAGREPINFO pGI );
int	YGCALL	AGrepEmpty( LPAGREPINFO pGI );
int	YGCALL	AGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, int iSize, LPAGREPINFO pGI );
int	YGCALL	AGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, int iSize, LPAGREPINFO pGI );
int	YGCALL	SCompileAGrep( LPCSTR GrepString, int k, BOOL bMatchCase );
int	YGCALL	SAGrep( LPCSTR StringToSearch );
int	YGCALL	SAGrepInit( void );
int	YGCALL	SAGrepEmpty( void );
int	YGCALL	SAGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, int iSize );
int	YGCALL	SAGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, int iSize );






#define	MAXDFA	2*WORD_SIZE

typedef struct tagRGrepInfo {
	int	iErrorCode;
	char	cPat[WORD_SIZE];
	LPSTR	TagStart[MAXTAG];
	LPSTR	TagEnd[MAXTAG];
	int	bMatchCase;
	int	bMessages;
	int	iCircf;		/* internal structures */
	char	cDFA[MAXDFA];
} RGREPINFO;
#ifdef	WINVER
typedef	RGREPINFO*	PRGREPINFO;
typedef	RGREPINFO FAR*	LPRGREPINFO;
#else
typedef	RGREPINFO*	PRGREPINFO;
typedef	RGREPINFO*	LPRGREPINFO;
#endif

int	YGCALL	CompileRGrep( LPCSTR GrepString, BOOL bMatchCase, LPRGREPINFO pGI );
int	YGCALL	RGrep( LPCSTR StringToSearch, LPRGREPINFO pGI );
int	YGCALL	RGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, int iSize, LPRGREPINFO pGI );
int	YGCALL	RGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, int iSize, LPRGREPINFO pGI );
void	YGCALL	InitWordCharTable( void );
void	YGCALL	AddWordChar( LPSTR s );
void	YGCALL	RemoveWordChar( LPSTR s );
int	YGCALL	SCompileRGrep( LPCSTR GrepString, BOOL bMatchCase );
int	YGCALL	SRGrep( LPCSTR StringToSearch );
int	YGCALL	SRGrepSubsBuild( LPSTR lpszPattern, LPSTR lpszDest, int iSize );
int	YGCALL	SRGrepSubstitute( LPSTR SearchedString, LPSTR lpszPattern, LPSTR lpszDest, int iSize );





#define	OP_NOP	0
#define	OP_NOT	1
#define	OP_AND	2
#define	OP_OR	3
#define	OP_NAND	4
#define	OP_NOR	5
#define	OP_ADD	6
#define	OP_SUB	7
#define	OP_UCMP	8
#define	OP_BAND	9
#define	OP_BOR	10
#define	OP_BXOR	11
#define	OP_BNAND	12
#define	OP_BNOR	13

typedef	struct tagYGrepInfo {
	union {
		int		opI;	/* One of OP_* values */
		AGREPINFO	aGI;
		RGREPINFO	rGI;
	} info;
#ifdef	WINVER
	struct tagYGrepInfo FAR*	pInfo;
#else
	struct tagYGrepInfo *   	pInfo;
#endif
	int	iTypeOfInfo;	/* One of IT_* values */
} YGREPINFO;
#ifdef	WINVER
typedef	YGREPINFO*	PYGREPINFO;
typedef	YGREPINFO FAR*	LPYGREPINFO;
#else
typedef	YGREPINFO*	PYGREPINFO;
typedef	YGREPINFO*	LPYGREPINFO;
#endif

#define	IT_NONE	-1
#define	IT_OP	0
#define	IT_AG	1
#define	IT_RG	2

int	YGCALL	PushYInfo( LPYGREPINFO pGI );
int	YGCALL	YGrep( LPCSTR StringToSearch );



void	YGCALL	SFileSetFlags( BOOL bPrintFileName, BOOL bPrintBlockNumber, BOOL bPrintLineNumber, BOOL bCountsOnly, BOOL bNonMatching );
BOOL	YGCALL	SFileOpen( LPCSTR strFileName );
LPSTR	YGCALL	SFileAGrep();
LPSTR	YGCALL	SFileRGrep();
long	YGCALL	SFileClose();



#ifdef __cplusplus
} /* extern "C" */
#endif
#endif	/* __YGREP_H__ */
