/****************************************************************** ITEMS.CPP
 *                                                                          *
 *                     Display Item Class Functions                         *
 *                                                                          *
 ****************************************************************************/

#define INCL_BASE
#define INCL_PM
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "Config.h"
#include "Debug.h"
#include "DQPS.h"
#include "Support.h"
#include "ReString.h"

#include "Items.h"

static void FormatValue ( ULONG Value, char Text[], COUNTRYINFO &CountryInfo, int ShowK=SHOWK_ABOVE512, int Scale=1 ) {

   switch ( ShowK ) {
      case SHOWK_NEVER:
         sprintf ( Text, "%lu", Value*Scale ) ;
         break;
      case SHOWK_ALWAYS:
         sprintf ( Text, "%lu", (Value+(512/Scale))/(1024/Scale) ) ;
         break;
      case SHOWK_ABOVE512:
      default:
         if ( Value < 0x80000/Scale )
            sprintf ( Text, "%lu", Value*Scale ) ;
         else
            sprintf ( Text, "%lu", (Value+(512/Scale))/(1024/Scale) ) ;
         break;
   } /* endswitch */

   char Work[100] ;
   char *p1 = Text ;
   char *p2 = Work ;
   while ( *p1 ) {
      *p2 = *p1 ;
      p1 ++ ;
      p2 ++ ;
      if ( *p1 ) {
         if ( strlen(p1) % 3 == 0 ) {
            *p2 = CountryInfo.szThousandsSeparator [0] ;
            p2 ++ ;
         } /* endif */
      } /* endif */
   } /* endwhile */
   *p2 = 0 ;
   strcpy ( Text, Work ) ;

   p2 = Text + strlen(Text) ;
   *(p2+1) = 0 ;
   switch ( ShowK ) {
      case SHOWK_NEVER:
         *p2 = ' ' ;
         break;
      case SHOWK_ALWAYS:
         *p2 = 'K' ;
         break;
      case SHOWK_ABOVE512:
      default:
         if ( Value < 0x80000/Scale )
            *p2 = ' ' ;
         else
            *p2 = 'K' ;
         break;
   } /* endswitch */
}


void Item::FormatLine ( char *Buffer, int MaxWidth ) {

   // Get the left and right texts for the line.
   char Label[100], Text[100] ;
   FormatText ( Label, Text, QueryValue() ) ;

   // Format the line.
   strcat ( Buffer, Label ) ;
   sprintf ( Buffer+strlen(Buffer), "%*s", MaxWidth-strlen(Label)-strlen(Text), "" ) ;
   strcat ( Buffer, Text ) ;
   strcat ( Buffer, "\r\n" ) ;
}


void Item::DdeUpdate ( char *Text ) {

   int Format, Size ; PVOID Data ;
   pDdeItem->Query ( Format, Data, Size ) ;

   int NewSize = strlen(Text) + 1 ;
   if ( Data && memcmp ( Text, Data, NewSize ) )
      pDdeItem->Update ( DDEFMT_TEXT, Text, NewSize ) ;
}


void Item::Paint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, 
   char *Label, char *Text, ULONG NewValue ) {

   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle,
      TextColor, BackColor, DT_RIGHT | DT_BOTTOM | DT_ERASERECT ) ;

   WinDrawText ( hPS, strlen(Label), PSZ(Label), &Rectangle,
      TextColor, BackColor, DT_LEFT | DT_BOTTOM ) ;

   Value = NewValue ;
}


int Clock::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   if ( CountryInfo.fsDateFmt != DATEFMT_YY_MM_DD ) {
      Result = sprintf ( Text, " MMM, MM-DD HH:MM%s%s ", ShowSeconds?":SS":"", CountryInfo.fsTimeFmt?"":"xx" ) ;
   } else {
      Result = sprintf ( Text, " MM-DD MMM HH:MM%s%s ", ShowSeconds?":SS":"", CountryInfo.fsTimeFmt?"":"xx" ) ;
   } /* endif */
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}

struct Date_Time {
   unsigned Weekday : 3 ;
   unsigned Month : 4 ;
   unsigned Day : 5 ;
   unsigned Hours : 5 ;
   unsigned Minutes : 6 ;
   unsigned Seconds : 6 ;
} ;

ULONG Clock::NewValue ( void ) {

  DATETIME DateTime ;
  DosGetDateTime ( &DateTime ) ;

  struct Date_Time Dttm = { 
     DateTime.weekday, 
     DateTime.month, 
     DateTime.day, 
     DateTime.hours, 
     DateTime.minutes, 
     0 
  } ;

  if ( ShowSeconds ) 
     Dttm.Seconds = DateTime.seconds ;

  ULONG Time = * ( (PULONG) &Dttm ) ;

  return ( Time ) ;
}


void Clock::FormatText ( char *Label, char *Text, ULONG Time ) {

   strcpy ( Label, CurrentLabel ) ;

   struct Date_Time Dttm = * ( (struct Date_Time*) &Time ) ;
   ULONG Dow    = Dttm.Weekday ;
   ULONG Month  = Dttm.Month ;
   ULONG Day    = Dttm.Day ;
   ULONG Hour   = Dttm.Hours ;
   ULONG Minute = Dttm.Minutes ;
   ULONG Second = Dttm.Seconds ;

   switch ( CountryInfo.fsDateFmt ) {

      case DATEFMT_DD_MM_YY:
         sprintf ( Text, "%0.*s, %02lu%s%02lu ",
            strlen(PCHAR(*DaysOfWeek))/7, PSZ(*DaysOfWeek) + Dow*(strlen(PCHAR(*DaysOfWeek))/7),
            Day, CountryInfo.szDateSeparator, Month ) ;
         break ;

      case DATEFMT_YY_MM_DD:
         sprintf ( Text, "%02lu%s%02lu %0.*s ",
            Month, CountryInfo.szDateSeparator, Day,
            strlen(PCHAR(*DaysOfWeek))/7, PSZ(*DaysOfWeek) + Dow*(strlen(PCHAR(*DaysOfWeek))/7) ) ;
         break ;

      case DATEFMT_MM_DD_YY:
      default:
         sprintf ( Text, "%0.*s, %02lu%s%02lu ",
            strlen(PCHAR(*DaysOfWeek))/7, PSZ(*DaysOfWeek) + Dow*(strlen(PCHAR(*DaysOfWeek))/7),
            Month, CountryInfo.szDateSeparator, Day ) ;
         break ;

   } /* endswitch */

   if ( CountryInfo.fsTimeFmt ) {
      if ( ShowSeconds )
         sprintf ( Text+strlen(Text), "%02lu%s%02lu%s%02lu",
             Hour, CountryInfo.szTimeSeparator, Minute, CountryInfo.szTimeSeparator, Second ) ;
      else
         sprintf ( Text+strlen(Text), "%02lu%s%02lu",
             Hour, CountryInfo.szTimeSeparator, Minute ) ;
   } else {
      PCHAR AmPm ;
      if ( Hour ) {
         if ( Hour < 12 ) {
            AmPm = szAm ;
         } else if ( Hour == 12 ) {
            if ( Minute )
               AmPm = szPm ;
            else
               AmPm = szAm ;
         } else if ( Hour > 12 ) {
            Hour -= 12 ;
            AmPm = szPm ;
         } /* endif */
      } else {
         Hour = 12 ;
         if ( Minute )
            AmPm = szAm ;
         else
            AmPm = szPm ;
      } /* endif */
      if ( ShowSeconds )
         sprintf ( Text+strlen(Text), "%02lu%s%02lu%s%02lu%s",
             Hour, CountryInfo.szTimeSeparator, Minute, CountryInfo.szTimeSeparator, Second, AmPm ) ;
      else
         sprintf ( Text+strlen(Text), "%02lu%s%02lu%s",
             Hour, CountryInfo.szTimeSeparator, Minute, AmPm ) ;
   } /* endif */

   DdeUpdate ( Text ) ;
}


void Clock::FormatLine ( char *Buffer, int MaxWidth ) {

   // Get the left and right texts for the line.
   char Label[100], Text[100] ;
   FormatText ( Label, Text, QueryValue() ) ;

   // Format the line.
   sprintf ( Buffer+strlen(Buffer), "%*s%s%*s", 
      (MaxWidth-strlen(Text))/2, "", Text, 
      MaxWidth-strlen(Text)-(MaxWidth-strlen(Text))/2, "" ) ;
   strcat ( Buffer, "\r\n" ) ;
}


void Clock::Repaint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Time = NewValue ( ) ;
   if ( Mandatory || ( Time != Value ) ) {
      char Label[100], Text [100] ;
      FormatText ( Label, Text, Time ) ;
      WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle,
         TextColor, BackColor, DT_CENTER | DT_BOTTOM | DT_ERASERECT ) ;
      Value = Time ;
   } /* endif */
}


int ElapsedTime::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   Result = sprintf ( Text, "%s XX %s, XX:XX%s", QueryCurrentLabel(), PSZ(*Days), ShowSeconds?":XX":"" ) ;
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}


ULONG ElapsedTime::NewValue ( void ) {
   ULONG Milliseconds ;
   DosQuerySysInfo ( QSV_MS_COUNT, QSV_MS_COUNT, &Milliseconds, sizeof(Milliseconds) ) ;
   return ( Milliseconds / 1000 ) ;
}


void ElapsedTime::FormatText ( char *Label, char *Text, ULONG Time ) {

   strcpy ( Label, CurrentLabel ) ;

   *Text = 0 ;

   ULONG NumberOfDays = Time / ( 60 * 60 * 24 ) ;
   Time -= NumberOfDays * 60 * 60 * 24 ;
   ULONG Hours   = Time / ( 60 * 60 ) ;
   Time -= Hours * 60 * 60 ;
   ULONG Minutes = Time / 60 ;
   ULONG Seconds = Time % 60 ;

   if ( NumberOfDays ) {
      sprintf ( Text, "%lu %s, ",
         NumberOfDays, NumberOfDays > 1 ? PSZ(*Days) : PSZ(*Day) ) ;
   } /* endif */

   if ( ShowSeconds )
      sprintf ( Text+strlen(Text), "%lu%s%02lu%s%02lu",
         Hours, CountryInfo.szTimeSeparator, Minutes,
         CountryInfo.szTimeSeparator, Seconds ) ;
   else
      sprintf ( Text+strlen(Text), "%lu%s%02lu",
         Hours, CountryInfo.szTimeSeparator, Minutes ) ;

   DdeUpdate ( Text ) ;
}

void ElapsedTime::Repaint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Time = NewValue ( ) ;
   if ( Mandatory || ( Time != Value ) ) {
      char Label[100], Text[100] ;
      FormatText ( Label, Text, Time ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Time ) ;
   } /* endif */
}


int MemoryFree::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   if ( ShowK != SHOWK_NEVER ) {
      Result = sprintf ( Text, "%s 123,456K", QueryCurrentLabel() ) ;
   } else {
      Result = sprintf ( Text, "%s 123,456,789K", QueryCurrentLabel() ) ;
   } /* endif */
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}


ULONG MemoryFree::NewValue ( void ) {
   APIRET16 APIENTRY16 Dos16MemAvail ( PULONG pulAvailMem ) ;
   ULONG Value ;
   Dos16MemAvail ( &Value ) ;
   return ( Value ) ;
}


void MemoryFree::FormatText ( char *Label, char *Text, ULONG Value ) {
   strcpy ( Label, CurrentLabel ) ;
   FormatValue ( Value, Text, CountryInfo, ShowK ) ;
   DdeUpdate ( Text ) ;
}


void MemoryFree::Repaint ( HPS hPS, RECTL &Rectangle, 
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Size = NewValue ( ) ;
   if ( Mandatory || ( Size != Value ) ) {
      char Label[100], Text [100] ;
      FormatText ( Label, Text, Size ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Size ) ;
   } /* endif */
}


int VirtualFree::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   if ( ShowK != SHOWK_NEVER ) {
      Result = sprintf ( Text, "%s 123,456K", QueryCurrentLabel() ) ;
   } else {
      Result = sprintf ( Text, "%s 123,456,789K", QueryCurrentLabel() ) ;
   } /* endif */
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}


ULONG VirtualFree::NewValue ( void ) {
   ULONG Space ;
   DosQuerySysInfo ( QSV_TOTAVAILMEM, QSV_TOTAVAILMEM, &Space, sizeof(Space) ) ;
   return ( Space ) ;
}


void VirtualFree::FormatText ( char *Label, char *Text, ULONG Value ) {

   strcpy ( Label, CurrentLabel ) ;

   FormatValue ( Value, Text, CountryInfo, ShowK ) ;

   DdeUpdate ( Text ) ;
}


void VirtualFree::Repaint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Size = NewValue ( ) ;
   if ( Mandatory || ( Size != Value ) ) {
      char Label[100], Text [100] ;
      FormatText ( Label, Text, Size ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Size ) ;
   } /* endif */
}


int SwapSize::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   if ( ShowK != SHOWK_NEVER ) {
      Result = sprintf ( Text, "%s 123,456K", QueryCurrentLabel() ) ;
   } else {
      Result = sprintf ( Text, "%s 123,456,789K", QueryCurrentLabel() ) ;
   } /* endif */
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}


ULONG SwapSize::NewValue ( void ) {

   char Path [_MAX_PATH+1] ;
   strcpy ( Path, (PCHAR)SwapPath ) ;

   if ( Path[strlen(Path)-1] != '\\' )
      strcat ( Path, "\\" ) ;

   strcat ( Path, "SWAPPER.DAT" ) ;

   ULONG SwapSize = 0 ;
   FILESTATUS3 Status ;
   if ( DosQueryPathInfo ( (PSZ)Path, FIL_STANDARD, &Status, sizeof(Status) ) == 0 ) 
      SwapSize = Status.cbFileAlloc ;

   return ( SwapSize ) ;
}


void SwapSize::FormatText ( char *Label, char *Text, ULONG Value ) {

   strcpy ( Label, CurrentLabel ) ;

   FormatValue ( Value, Text, CountryInfo, ShowK ) ;

   DdeUpdate ( Text ) ;
}


void SwapSize::Repaint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Size = NewValue ( ) ;
   if ( Mandatory || ( Size != Value ) ) {
      char Label[100], Text [100] ;
      FormatText ( Label, Text, Size ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Size ) ;
   } /* endif */
}


int SwapFree::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   if ( ShowK != SHOWK_NEVER ) {
      Result = sprintf ( Text, "%s 123,456K", QueryCurrentLabel() ) ;
   } else {
      Result = sprintf ( Text, "%s 123,456,789K", QueryCurrentLabel() ) ;
   } /* endif */
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}


ULONG SwapFree::NewValue ( void ) {

   DosError ( FERR_DISABLEHARDERR ) ;
   FSALLOCATE Allocation ;
   DosQueryFSInfo ( SwapPath[0]-'A'+1, FSIL_ALLOC, PBYTE(&Allocation), sizeof(Allocation) ) ;
   DosError ( FERR_ENABLEHARDERR ) ;

   ULONG SwapFree = Allocation.cUnitAvail*Allocation.cSectorUnit*Allocation.cbSector ;

   if ( SwapFree < ULONG(MinFree*1024) )
      return ( 0 ) ;
   else
      return ( ULONG ( ( SwapFree - ULONG(MinFree*1024) ) / (1024*1024) ) * (1024*1024) ) ;
}


void SwapFree::FormatText ( char *Label, char *Text, ULONG Value ) {

   strcpy ( Label, CurrentLabel ) ;

   FormatValue ( Value, Text, CountryInfo, ShowK ) ;

   DdeUpdate ( Text ) ;
}


void SwapFree::Repaint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Size = NewValue ( ) ;
   if ( Mandatory || ( Size != Value ) ) {
      char Label[100], Text [100] ;
      FormatText ( Label, Text, Size ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Size ) ;
   } /* endif */
}


int SpoolSize::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   if ( ShowK != SHOWK_NEVER ) {
      Result = sprintf ( Text, "%s 123,456K", QueryCurrentLabel() ) ;
   } else {
      Result = sprintf ( Text, "%s 123,456,789K", QueryCurrentLabel() ) ;
   } /* endif */
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}


ULONG SpoolSize::NewValue ( void ) {

   ULONG PathSize ;
   DosQuerySysInfo ( QSV_MAX_PATH_LENGTH, QSV_MAX_PATH_LENGTH, &PathSize, sizeof(PathSize) ) ;

   PBYTE Path = PBYTE ( malloc ( size_t(PathSize) ) ) ;
   if ( Path == NULL ) 
      return ( 0 ) ;

   PFILEFINDBUF3 Found = PFILEFINDBUF3 ( malloc ( size_t( PathSize + sizeof(FILEFINDBUF3) ) ) ) ;
   if ( Found == NULL ) {
      free ( Path ) ;
      return ( 0 ) ;
   } /* endif */

   strcpy ( (PCHAR)Path, (PCHAR)SpoolPath ) ;
   strcat ( (PCHAR)Path, "\\*.*" ) ;

   HDIR hDir = (HDIR) HDIR_CREATE ;
   ULONG Count = 1 ;
   ULONG TotalSize = 0 ;

   if ( !DosFindFirst2 ( Path, &hDir,
      FILE_NORMAL | FILE_READONLY | FILE_DIRECTORY | FILE_ARCHIVED,
      Found, PathSize+sizeof(FILEFINDBUF3), &Count, FIL_STANDARD ) ) {

      do {

         if ( !strcmp ( (PCHAR)Found->achName, "." ) OR !strcmp ( (PCHAR)Found->achName, ".." ) )
            continue ;

         if ( Found->attrFile & FILE_DIRECTORY ) {
 
            HDIR hDir2 = (HDIR) HDIR_CREATE ;

            strcpy ( (PCHAR)Path, (PCHAR)SpoolPath ) ;
            strcat ( (PCHAR)Path, "\\" ) ;
            strcat ( (PCHAR)Path, (PCHAR)Found->achName ) ;
            strcat ( (PCHAR)Path, "\\*.*" ) ;

            ULONG Count2 = 1 ;
            if ( !DosFindFirst2 ( Path, &hDir2,
               FILE_NORMAL | FILE_READONLY | FILE_ARCHIVED,
               Found, PathSize+sizeof(FILEFINDBUF3), &Count2, FIL_STANDARD ) ) {
               do {
                  TotalSize += Found->cbFileAlloc ;
               } while ( !DosFindNext ( hDir2, Found, PathSize+sizeof(FILEFINDBUF3), &Count2 ) ) ;
               DosFindClose ( hDir2 ) ;
            } /* endif */
         } else {
            TotalSize += Found->cbFileAlloc ;
         } /* endif */
      } while ( !DosFindNext ( hDir, Found, PathSize+sizeof(FILEFINDBUF3), &Count ) ) ;

      DosFindClose ( hDir ) ;

   } /* enddo */

   free ( Path ) ;
   free ( Found ) ;

   return ( TotalSize ) ;
}


void SpoolSize::FormatText ( char *Label, char *Text, ULONG Value ) {

   strcpy ( Label, CurrentLabel ) ;

   FormatValue ( Value, Text, CountryInfo, ShowK ) ;

   DdeUpdate ( Text ) ;
}


void SpoolSize::Repaint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Size = NewValue ( ) ;
   if ( Mandatory || ( Size != Value ) ) {
      char Label[100], Text [100] ;
      FormatText ( Label, Text, Size ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Size ) ;
   } /* endif */
}


int CpuLoad::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   Result = sprintf ( Text, "%s 100%", QueryCurrentLabel() ) ;
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}


ULONG CpuLoad::NewValue ( void ) {
   MaxCount = (ULONG) max ( MaxCount, *IdleCount ) ;
   ULONG Load = ( ( MaxCount - *IdleCount ) * 100 ) / MaxCount ;
   return ( Load ) ;
}


void CpuLoad::FormatText ( char *Label, char *Text, ULONG Value ) {

   strcpy ( Label, CurrentLabel ) ;

   sprintf ( Text, "%lu%%", Value ) ;

   DdeUpdate ( Text ) ;
}


void CpuLoad::Repaint ( HPS hPS, RECTL &Rectangle, 
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Load = NewValue ( ) ;
   if ( Mandatory || ( Load != Value ) ) {
      char Label[100], Text [100] ;
      FormatText ( Label, Text, Load ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Load ) ;
   } /* endif */
}


int TaskCount::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   Result = sprintf ( Text, "%s 999 ", QueryCurrentLabel() ) ;
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}


ULONG TaskCount::NewValue ( void ) {
   return ( WinQuerySwitchList ( Anchor, PSWBLOCK(NULL), 0 ) ) ;
}


void TaskCount::FormatText ( char *Label, char *Text, ULONG Value ) {

   strcpy ( Label, CurrentLabel ) ;

   sprintf ( Text, "%lu ", Value ) ;

   DdeUpdate ( Text ) ;
}


void TaskCount::Repaint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Count = NewValue ( ) ;
   if ( Mandatory || ( Count != Value ) ) {
      char Label[100], Text [100] ;
      FormatText ( Label, Text, Count ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Count ) ;
   } /* endif */
}


int DriveFree::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   if ( ShowFileSystemName && *FileSystem ) {
      if ( ShowDiskLabel && *DiskLabel ) {
         if ( ShowK != SHOWK_NEVER ) {
            Result = sprintf ( Text, "%s (%s,%s) 1,234,567K", QueryCurrentLabel(), DiskLabel, FileSystem ) ;
         } else {
            Result = sprintf ( Text, "%s (%s,%s) 1,234,567,890K", QueryCurrentLabel(), DiskLabel, FileSystem ) ;
         } /* endif */
      } else {
         if ( ShowK != SHOWK_NEVER ) {
            Result = sprintf ( Text, "%s (%s) 1,234,567K", QueryCurrentLabel(), FileSystem ) ;
         } else {
            Result = sprintf ( Text, "%s (%s) 1,234,567,890K", QueryCurrentLabel(), FileSystem ) ;
         } /* endif */
      } /* endif */
   } else {
      if ( ShowDiskLabel && *DiskLabel ) {
         if ( ShowK != SHOWK_NEVER ) {
            Result = sprintf ( Text, "%s (%s) 1,234,567K", QueryCurrentLabel(), DiskLabel ) ;
         } else {
            Result = sprintf ( Text, "%s (%s) 1,234,567,890K", QueryCurrentLabel(), DiskLabel ) ;
         } /* endif */
      } else {
         if ( ShowK != SHOWK_NEVER ) {
            Result = sprintf ( Text, "%s 1,234,567K", QueryCurrentLabel() ) ;
         } else {
            Result = sprintf ( Text, "%s 1,234,567,890K", QueryCurrentLabel() ) ;
         } /* endif */
      } /* endif */
   } /* endif */
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}


ULONG DriveFree::NewValue ( void ) {

   if ( Error ) 
      return ( 0 ) ;

   DosError ( FERR_DISABLEHARDERR ) ;

   FSALLOCATE Allocation ;
   APIRET Status = DosQueryFSInfo ( DriveNumber, FSIL_ALLOC, (PBYTE)&Allocation, sizeof(Allocation) ) ;

   DosError ( FERR_ENABLEHARDERR ) ;

   if ( Status ) {
      Error = TRUE ;
      return ( 0 ) ;
   } /* endif */

   return ( Allocation.cUnitAvail*Allocation.cSectorUnit*Allocation.cbSector ) ;
}


void DriveFree::FormatText ( char *Label, char *Text, ULONG Value ) {

   if ( ShowFileSystemName && *FileSystem ) {
      if ( ShowDiskLabel && *DiskLabel ) {
         sprintf ( Label, "%s (%s,%s)", QueryCurrentLabel(), DiskLabel, FileSystem ) ;
      } else {
         sprintf ( Label, "%s (%s)", QueryCurrentLabel(), FileSystem ) ;
      } /* endif */
   } else {
      if ( ShowDiskLabel && *DiskLabel ) {
         sprintf ( Label, "%s (%s)", QueryCurrentLabel(), DiskLabel ) ;
      } else {
         sprintf ( Label, "%s", QueryCurrentLabel() ) ;
      } /* endif */
   } /* endif */

   if ( Error )
      strcpy ( Text, PCHAR(*DriveError) ) ;
   else
      FormatValue ( Value, Text, CountryInfo, ShowK ) ;

   DdeUpdate ( Text ) ;
}


void DriveFree::Repaint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Size = NewValue ( ) ;
   if ( Mandatory || ( Size != Value ) ) {
      char Label[100], Text [100] ;
      FormatText ( Label, Text, Size ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Size ) ;
   } /* endif */
}


int TotalFree::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   if ( ShowK != SHOWK_NEVER ) {
      Result = sprintf ( Text, "%s 0,123,456K", QueryCurrentLabel() ) ;
   } else {
      Result = sprintf ( Text, "%s 0,123,456,789K", QueryCurrentLabel() ) ;
   } /* endif */
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}


ULONG TotalFree::NewValue ( void ) {

   ULONG Free = 0 ;
   ULONG Mask = Drives >> 2 ;

   for ( int Drive=3; Drive<=26; Drive++ ) {
      if ( Mask & 1 ) {

         DosError ( FERR_DISABLEHARDERR ) ;

         FSALLOCATE Allocation ;
         APIRET Status = DosQueryFSInfo ( Drive, FSIL_ALLOC, (PBYTE)&Allocation, sizeof(Allocation) ) ;

         DosError ( FERR_ENABLEHARDERR ) ;

         if ( Status )
            Drives &= ~ ( 1 << (Drive-1) ) ;
         else
            Free += Allocation.cUnitAvail*Allocation.cSectorUnit*(Allocation.cbSector/256) ;
      } /* endif */
      Mask >>= 1 ;

   } /* endfor */

   return ( Free ) ;
}


void TotalFree::FormatText ( char *Label, char *Text, ULONG Value ) {

   strcpy ( Label, CurrentLabel ) ;

   FormatValue ( Value, Text, CountryInfo, ShowK, 256 ) ;

   DdeUpdate ( Text ) ;
}


void TotalFree::Repaint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Size = NewValue ( ) ;
   if ( Mandatory || ( Size != Value ) ) {
      char Label[100], Text [100] ;
      FormatText ( Label, Text, Size ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Size ) ;
   } /* endif */
}


int SwapSlack::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   if ( ShowK != SHOWK_NEVER ) {
      Result = sprintf ( Text, "%s 123,456K", QueryCurrentLabel() ) ;
   } else {
      Result = sprintf ( Text, "%s 123,456,789K", QueryCurrentLabel() ) ;
   } /* endif */
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}

ULONG SwapSlack::NewValue ( void ) {
   LONG Slack = pVirtualFree->QueryFlag() ? pVirtualFree->QueryValue() : pVirtualFree->NewValue() ;
   Slack -= pSwapFree->QueryFlag() ? pSwapFree->QueryValue() : pSwapFree->NewValue() ;
   Slack -= pMemFree->QueryFlag() ? pMemFree->QueryValue() : pMemFree->NewValue() ;
   return ( ULONG ( max ( 0, Slack ) ) ) ;
}

void SwapSlack::FormatText ( char *Label, char *Text, ULONG Value ) {

   strcpy ( Label, CurrentLabel ) ;

   FormatValue ( Value, Text, CountryInfo, ShowK ) ;

   DdeUpdate ( Text ) ;
}

void SwapSlack::Repaint ( HPS hPS, RECTL &Rectangle,
   COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {

   ULONG Size = NewValue ( ) ;
   if ( Mandatory || ( Size != Value ) ) {
      char Label[100], Text[100] ;
      FormatText ( Label, Text, Size ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Size ) ;
   } /* endif */
}


int ProcessCount::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   Result = sprintf ( Text, "%s 123 ", QueryCurrentLabel() ) ;
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}

ULONG ProcessCount::NewValue ( void ) {

   if ( DosQProcStatus ( DQPS_Buffer, 0xFFFF ) ) 
      return ( 0 ) ;

   qsPrec_s *pProcRecord = ((qsPtrRec_s*)DQPS_Buffer)->pProcRec ;
   int ProcessCount = 0 ;
   while ( pProcRecord->RecType == 1 ) {
      int Size = sizeof(qsPrec_s) ;
      Size += pProcRecord->cTCB * sizeof(qsTrec_s) ;
      Size += pProcRecord->c16Sem * sizeof(short) ;
      Size += pProcRecord->cLib * sizeof(short) ;
      Size += pProcRecord->cShrMem * sizeof(short) ;
      pProcRecord = (qsPrec_s*) ( (char*)pProcRecord + Size ) ;
      ProcessCount ++ ;
   } /* endwhile */
   return ( ProcessCount ) ;
}

void ProcessCount::FormatText ( char *Label, char *Text, ULONG Value ) {
   strcpy ( Label, CurrentLabel ) ;
   sprintf ( Text, "%lu ", Value ) ;
   DdeUpdate ( Text ) ;
}

void ProcessCount::Repaint ( HPS hPS, RECTL &Rectangle, COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {
   ULONG Size = NewValue ( ) ;
   if ( Mandatory || ( Size != Value ) ) {
      char Label[100], Text[100] ;
      FormatText ( Label, Text, Size ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Size ) ;
   } /* endif */
}


int ThreadCount::Measure ( HPS hPS, RECTL &Rectangle ) {
   int Result ;
   char Text [100] ;
   Result = sprintf ( Text, "%s 123 ", QueryCurrentLabel() ) ;
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(Text), PSZ(Text), &Rectangle, 0, 0, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
   return ( Result ) ;
}

ULONG ThreadCount::NewValue ( void ) {

   if ( DosQProcStatus ( DQPS_Buffer, 0xFFFF ) )
      return ( 0 ) ;

   return ( ((qsPtrRec_s*)DQPS_Buffer)->pGlobalRec->cThrds ) ;
}

void ThreadCount::FormatText ( char *Label, char *Text, ULONG Value ) {
   strcpy ( Label, CurrentLabel ) ;
   sprintf ( Text, "%lu ", Value ) ;
   DdeUpdate ( Text ) ;
}

void ThreadCount::Repaint ( HPS hPS, RECTL &Rectangle, COLOR TextColor, COLOR BackColor, BOOL Mandatory ) {
   ULONG Size = NewValue ( ) ;
   if ( Mandatory || ( Size != Value ) ) {
      char Label[100], Text[100] ;
      FormatText ( Label, Text, Size ) ;
      Paint ( hPS, Rectangle, TextColor, BackColor, Label, Text, Size ) ;
   } /* endif */
}

