#include "fullscr.h"

// Macros to store the variables as window properties

#define GET_FULL_SCREEN_STATE(hWnd) \
    (BOOL)GetProp (hWnd, "FullScreen")
#define SET_FULL_SCREEN_STATE(hWnd, x) \
    SetProp (hWnd, "FullScreen", (HANDLE)x)
#define GET_MAXIMIZED_STATE(hWnd) \
    (BOOL)GetProp (hWnd, "Maximized")
#define SET_MAXIMIZED_STATE(hWnd, x) \
    SetProp (hWnd, "Maximized", (HANDLE)x)

#define LARGE_NUMBER 5000

static int nyCaption;
static int nxFrame;
static int nyFrame;
static int nxScreen;
static int nyScreen;
static int nyMenu;


/* Init - initialize various window dimensions */
static void Init(void)
    {
    nyCaption   = GetSystemMetrics(SM_CYCAPTION);
    nxFrame     = GetSystemMetrics(SM_CXFRAME);
    nyFrame     = GetSystemMetrics(SM_CYFRAME);
    nxScreen    = GetSystemMetrics(SM_CXSCREEN);
    nyScreen    = GetSystemMetrics(SM_CYSCREEN);
    nyMenu      = GetSystemMetrics(SM_CYMENU);
    }


int GetFullScreenState(HWND hWnd)
    {
    return GET_FULL_SCREEN_STATE(hWnd);
    }


/*****************************************************************
 SetFullScreen - call this function to set the full screen mode.
 Parameter: Handle of window, flag indicating full screen or not.
 Note: If a window is maximized, calling ShowWindow 
 (SW_MAXIMIZE) has no effect. Therefore use SetWindowPos.
 LARGE_NUMBER is just an arbitrary large number (5000), so that 
 Windows calls WM_GETMINMAXINFO to get the maximized position.
*****************************************************************/

void SetFullScreen (HWND hWnd, BOOL bFullScreen)
{
    int x, y;

    if(!nyCaption)
        Init();

    x = -1 * nxFrame;

    SET_FULL_SCREEN_STATE (hWnd, bFullScreen);
    if (bFullScreen) {
        // Store maximized status
        SET_MAXIMIZED_STATE (hWnd, IsZoomed (hWnd));
        if (GET_MAXIMIZED_STATE (hWnd)) { // Use SetWindowPos explicitly
            y = -1 * (nyFrame + nyCaption + nyMenu);
            SetWindowPos (hWnd, NULL, x, y, LARGE_NUMBER,
                            LARGE_NUMBER, SWP_NOZORDER);
        }
        else
            ShowWindow (hWnd, SW_SHOWMAXIMIZED);
    }
    else {            // Restore to normal position.
        if (GET_MAXIMIZED_STATE (hWnd)) {
            y = -1 * nyFrame;
            SetWindowPos (hWnd, NULL, x, y, LARGE_NUMBER, 
                            LARGE_NUMBER, SWP_NOZORDER);
        }
        else
            ShowWindow (hWnd, SW_RESTORE);
    }
}

/*****************************************************************
 OnGetMinMaxInfo - handler for WM_GETMINMAXINFO
 Called from MainWndProc.
 If full screen is on, set maxsize and max track size to screen 
 + caption + 2 * frame. Else, set it to screen + 2 * frame.
*****************************************************************/

void OnGetMinMaxInfo (HWND hWnd, WPARAM wParam, LPARAM lParam)
{
    MINMAXINFO FAR * lpMMI = (MINMAXINFO FAR *)lParam;

    if(!nyCaption)
        Init();

    DefWindowProc (hWnd, WM_GETMINMAXINFO, wParam, lParam);

    if (GET_FULL_SCREEN_STATE (hWnd)) {
        lpMMI->ptMaxPosition.y = -1 * (nyFrame + 
                            nyCaption + nyMenu);
        lpMMI->ptMaxSize.y = lpMMI->ptMaxTrackSize.y = nyScreen + 
                2 * nyFrame + nyCaption + nyMenu;
    }
    else {
        lpMMI->ptMaxPosition.y = -1 * nyFrame;
        lpMMI->ptMaxSize.y = lpMMI->ptMaxTrackSize.y = nyScreen + 
                            2 * nyFrame; 
    }
    lpMMI->ptMaxPosition.x = -1 * nxFrame;
    lpMMI->ptMaxSize.x = lpMMI->ptMaxTrackSize.x =
                nxScreen + (2 * nxFrame);
}

