//
// Listing 1 - BUG0996.CPP
//
// This listing demonstrates a bug in Visual
// C++ 4.1 and 1.5.  The creation of object foo in
// main() is done with an integer initializer.
// In theory, this will require the creation
// of a temporary using the int constructor of
// type T, followed by an invocation of the
// copy constructor to create foo.
//
// Most compilers shortcut this process by
// directly invoking T(int) instead.   This
// is a legal shortcut, but it still has to
// obey the access rules for the copy ctor.
//
// This is discussed in some detail in 12.6.1
// of the ARM.
//

#include<iostream.h>

class T {
    private :
        T( const T& );
    public:
        T() { cout << "T::T()" << endl; }
        T( int x ) { cout << "T::T(int)" << endl; }
        ~T() { cout << "T::~T()" << endl; }
};

int main() {
    T foo = 2;  //Requires T(int) and T( T& )
    return 0;
}

//EOF
