
#include <windows.h>
#include <stdio.h>

#define HIGH 0
#define LOW  1

DWORD ThreadProc_High(PVOID);
DWORD ThreadProc_Low(PVOID);

HANDLE hEvent = NULL;
CHAR   gChar = 0x0;

VOID main(int argc, char **argv)
{
    HANDLE hThread[2];
    DWORD  ThreadID;

    hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

    hThread[HIGH] = CreateThread(NULL, 0, ThreadProc_High,
        NULL, CREATE_SUSPENDED, &ThreadID);

    hThread[LOW] = CreateThread(NULL, 0, ThreadProc_Low,
        NULL, CREATE_SUSPENDED, &ThreadID);

    SetThreadPriority(hThread[HIGH],
        THREAD_PRIORITY_HIGHEST);

    SetThreadPriority(hThread[LOW],
        THREAD_PRIORITY_LOWEST);

    ResumeThread(hThread[HIGH]);
    ResumeThread(hThread[LOW]);

    WaitForMultipleObjects(2, hThread, TRUE, INFINITE);
    printf("Last thread to finish was %c\n", gChar);
    return;
}

DWORD ThreadProc_High(PVOID Param)
{
    WaitForSingleObject(hEvent, INFINITE);
    gChar = 'H';
    OutputDebugString("ThreadProc_High");
    return TRUE;
}

DWORD ThreadProc_Low(PVOID Param)
{
    SetEvent(hEvent);
    gChar = 'L';
    OutputDebugString("ThreadProc_Low");
    return TRUE;
}



