{
  * Unit Name: listdlg.pas
  * Author:    William Stamatakis
  * Created:   11 '95
  *
  * Note:      ListBox Editor Dialog for Items property of
               Multi-Char Listbox Component (TListEditor)
}

unit Listdlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, StdCtrls, TBillist;

type
  TListEditor = class(TForm)
    lstItems: TBillListBox;
    btnAdd: TButton;
    GroupBox1: TGroupBox;
    edtItem: TEdit;
    btnEdit: TButton;
    btnDelete: TButton;
    Bevel1: TBevel;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    procedure btnAddClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OK_CancelClick(Sender: TObject);
  private
    PriorValue: String;
  public
    procedure SetReferenceTo(ARef: TObject);
  end;

var
  ListEditor: TListEditor;

const
  CAP_ADD    :string = 'Add >>';
  CAP_EDIT   :string = '<< Edit';
  CAP_DELETE :string = 'Delete';
  CAP_UPDATE :string = 'Update';
  CAP_CANCEL :string = 'Cancel';

implementation

var  ListBox: TBillListBox;

{$R *.DFM}

procedure TListEditor.SetReferenceTo(ARef: TObject);
begin
  ListBox := (ARef as TBillListBox);
end;

procedure TListEditor.btnAddClick(Sender: TObject);
begin

if (edtItem.Text <> '') then
begin
  if (btnAdd.Caption = CAP_ADD) then        {Add button}
    lstItems.Items.Add(edtItem.Text)
  else                                      {Update button}
  begin
    lstItems.Items[lstItems.ItemIndex] := edtItem.Text;
    btnAdd.Caption := CAP_ADD;
    btnEdit.Caption := CAP_EDIT;
    btnDelete.Enabled := True;
  end;
end;

end;

procedure TListEditor.btnDeleteClick(Sender: TObject);
begin
if (lstItems.ItemIndex > -1) then
   lstItems.Items.Delete(lstItems.ItemIndex);
   lstItems.SetFocus;
end;

procedure TListEditor.btnEditClick(Sender: TObject);
begin

if (lstItems.ItemIndex > -1) then
begin
   if (btnEdit.Caption = CAP_EDIT) then  {Edit button}
     begin
     PriorValue := edtItem.Text;
     edtItem.Text := lstItems.Items[lstItems.ItemIndex];
     edtItem.SetFocus;
     btnAdd.Caption := CAP_UPDATE;
     btnEdit.Caption := CAP_CANCEL;
     btnDelete.Enabled := False;
     end
   else                                  {Cancel Button}
     begin
     edtItem.Text := PriorValue;
     btnAdd.Caption := CAP_ADD;
     btnEdit.Caption := CAP_EDIT;
     btnDelete.Enabled := True;
     end;
end;

end;

procedure TListEditor.FormCreate(Sender: TObject);
begin
  btnAdd.Caption := CAP_ADD;
  btnEdit.Caption := CAP_EDIT;
  btnDelete.Caption := CAP_DELETE;
end;

procedure TListEditor.OK_CancelClick(Sender: TObject);
begin
  if (Sender = btnOK) then
  begin

      if (btnAdd.Caption <> CAP_ADD) then
      begin
        ShowMessage('Select Update or Cancel before pressing OK.');
        ModalResult := mrNone;
      end
      else
        begin
        ListBox.Clear;
        ListBox.Items.AddStrings(lstItems.Items);
        ModalResult := mrOk;
        end;
  end
  else if (Sender = btnCancel) then
  begin
      if (btnEdit.Caption = CAP_CANCEL) then
        btnEditClick(btnEdit);

      ModalResult := mrCancel;
  end;
end;

end.
