/* REXX *********************************************/
/*                                                  */
/* Program name: SAVEPRE                            */
/* Function    : Save current installation - an     */
/*               example for the pre-install exit   */
/*                                                  */
/* Syntax      : Call from the INSTALL.DAT via:     */
/*    START_REXX_BY_START_INSTALL=SAVEPRE dest_path */
/*                                                  */
/* Changes     :                                    */
/*                                                  */
/* Made use of GREED.  21 May 1996 / 19:50:29   JRK */
/****************************************************/
Parse Arg destPath
/*-------------(Write lines into file)--------------*/
filename    = destPath'\install.log'
rc = LineOut( filename, 'Destination Directory:' destPath)

/*==============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

Call On NOTREADY

/*==========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

delRC = SysFileDelete( destPath'\greed.ini' )
/*--------------(Make directory)---------------*/
directory = destPath||'\SAVEPREV'
rc = LineOut( filename, 'Save Directory:' directory )
rc = SysMkDir( directory )
rc = LineOut( filename, 'Make Save Directory RC='rc )
rc = LineOut( filename, "Save" destPath||"\*.*" directory"\" )
"unpack" destPath||"\*.*" directory"\"
rc = LineOut( filename, 'Save Previous Installation RC='rc )

/*----------(Set command for file system)-----------*/
status = Stream( filename, 'C', 'Close' )

/*================(End this program)================*/
Return

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
Return

NOTREADY: Procedure
  Parse Var response . ':' errcode
  Say SysGetMessage(errcode)
  Say
  Call ,"Retry (Y/N)? "
  Pull response
  If response = 'N' Then Exit

Return

