/*****************************************************************************/
/*
    FFTNWIN.H: Defines FFTNWIN.DLL resp. FFTNWN32.DLL application interface.
    This interface can be included by C or C++ code

    Copyright (C) Juergen Mueller (J.M.) 1988-1996
    All rights reserved.

    You are expressly prohibited from selling this software in any form,
    distributing it with another product, or removing this notice.

    THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
    EITHER EXPRESSED OR IMPLIED, INCLUDING, WITHOUT LIMITATION, THE
    IMPLIED WARRANTIES OF MERCHANTIBILITY OR FITNESS FOR A PARTICULAR
    PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE
    PROGRAM AND DOCUMENTATION IS WITH YOU.

    written by: Juergen Mueller, Aldingerstrasse 22, D-70806 Kornwestheim,
                GERMANY

    FILE       : FFTNWIN.C
    REVISION   : 01-Jan-1996
                 11:28:31
 */
/*****************************************************************************/

/* work-arounds due to the different DLL EXPORT syntax in WIN16 and WIN32 */
/* NOTE: the WIN32 part is currently not supported */
#if defined(_X86_) || defined(WIN32)    /***** WIN32 *****/
 #ifdef DLLBUILD                        /* only for DLL compilation */
  #define SXTNDLLAPI    __declspec(dllexport) LONG WINAPI   /** exporting **/
 #else                                  /* DLL-API for applications */
  #define SXTNDLLAPI    __declspec(dllimport) LONG WINAPI   /** importing **/
 #endif
#else                                   /***** WIN16 *****/
 #define SXTNDLLAPI     LONG WINAPI _export                 /** both **/
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* GENERAL OVERVIEW:                                                */
/* the user has to declare all string arrays in his application,    */
/* and pass pointers to them as function parameters                 */
/* the resulting output values require a string with 300 characters */
/* return value 101 means succesful, all others no success          */
/* LPSTR dbfname: pointer to string with database name              */

/* get location (file line) for 'name', result is in 'location' */
SXTNDLLAPI fftnGetLocation(LPSTR dbfname,               /* IN */
                           LPSTR name,                  /* IN */
                           LPSTR location               /* OUT [300] */
                          );

/* get first name from database, result is in 'name', */
/* called once before GetNextName                     */
SXTNDLLAPI fftnGetFirstName(LPSTR dbfname,              /* IN */
                            LPSTR name                  /* OUT [300]*/
                           );

/* get next name from database, result is in 'name', */
/* called after GetFirstName                         */
SXTNDLLAPI fftnGetNextName(LPSTR dbfname,               /* IN */
                           LPSTR name                   /* OUT [300]*/
                          );

/* get first defined name from database, result is in 'name', */
/* called once before GetNextDefName                          */
SXTNDLLAPI fftnGetFirstDefName(LPSTR dbfname,           /* IN */
                               LPSTR name               /* OUT [300]*/
                              );

/* get next name defined from database, result is in 'name', */
/* called after GetFirstDefName                              */
SXTNDLLAPI fftnGetNextDefName(LPSTR dbfname,            /* IN */
                              LPSTR name                /* OUT [300]*/
                             );

/* get first called item from database, result is in 'calleditem', */
/* called once before GetNextCalledItem                            */
SXTNDLLAPI fftnGetFirstCalledItem(LPSTR dbfname,        /* IN */
                                  LPSTR caller,         /* IN */
                                  LPSTR calleditem,     /* OUT [300]*/
                                  LPSTR location        /* OUT [300]*/
                                 );

/* get next called item from database, result is in 'calleditem', */
/* called after GetFirstCalledItem                                */
SXTNDLLAPI fftnGetNextCalledItem(LPSTR dbfname,         /* IN */
                                 LPSTR caller,          /* IN */
                                 LPSTR calleditem,      /* OUT [300]*/
                                 LPSTR location         /* OUT [300]*/
                                );

/* get first filename from database, result is in 'name', */
/* called once before GetNextFile                         */
SXTNDLLAPI fftnGetFirstFile(LPSTR dbfname,              /* IN */
                            LPSTR filename              /* OUT [300]*/
                           );

/* get next filename from database, result is in 'name', */
/* called after GetFirstFile                             */
SXTNDLLAPI fftnGetNextFile(LPSTR dbfname,               /* IN */
                           LPSTR filename               /* OUT [300] */
                          );

#ifdef __cplusplus
}
#endif

