unit Arrtest8;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TEnlargedViewDlg = class(TForm)
    LstView: TListBox;
    BtnClose: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnCloseClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

implementation

{$R *.DFM}

procedure TEnlargedViewDlg.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TEnlargedViewDlg.BtnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TEnlargedViewDlg.FormResize(Sender: TObject);
Var
  dy: Integer;
begin
  (* size the listbox so that it fills the client area with the exception
     of an area at the bottom that has double the height of the button.
     The button is centered in this space *)
  dy := (3 * BtnClose.Height) shr 1;
  LstView.Height := ClientHeight-dy;
  BtnClose.Left := (ClientWidth - BtnClose.Width) shr 1;
  Btnclose.Top  := ClientHeight - dy + BtnClose.Height shr 2 ;
end;

end.
