;
; INT 2F handler for Psharec
;
;
;
PUBLIC      _int21stub
PUBLIC      _int2Fstub
PUBLIC      _int17stub
PUBLIC      _Chain21
PUBLIC      _Chain2F
PUBLIC      _Chain17
PUBLIC      _glob
PUBLIC      _IPXEntry
PUBLIC      _CallOld17
PUBLIC      _IPXGetAddr
PUBLIC      _myIPXLocation
PUBLIC      _UnloadTSR



DOSSEG
.MODEL LARGE


.DATA

.CODE

EXTRN       _MyINT21  : PROC
EXTRN       _MyINT2F  : PROC
EXTRN       _MyINT17  : PROC









_int21stub    PROC FAR
              mov     word ptr cs:tmpax,ax

              mov     word ptr cs:tmpss,ss
              mov     word ptr cs:tmpsp,sp
              mov     ax,cs
              mov     ss,ax
              mov     sp,offset cs:tmpStkEnd

              mov     ax,word ptr cs:tmpax

              pushf
              push    ax
              push    bx
              push    cx
              push    dx
              push    ds
              push    es
              push    bp
              push    si
              push    di
                      
              mov     bp,sp
              call    _MyINT21

              pop     di
              pop     si
              pop     bp
              pop     es
              pop     ds
              pop     dx
              pop     cx
              pop     bx
              pop     ax
              popf

              mov     ss,word ptr cs:tmpss
              mov     sp,word ptr cs:tmpsp

              jmp     dword ptr cs:_Chain21

_int21stub    ENDP













_int2Fstub    PROC FAR
              pushf
              push    ax
              push    bx
              push    cx
              push    dx
              push    ds
              push    es
              push    bp
              push    si
              push    di

              mov     bp,sp
              call    _MyINT2F

              pop     di
              pop     si
              pop     bp
              pop     es
              pop     ds
              pop     dx
              pop     cx
              pop     bx

              test    ax,255
              jz      chain_2f

              pop     ax
              popf

              iret             



chain_2f:     pop     ax
              popf

              jmp     dword ptr cs:_Chain2F

_int2Fstub    ENDP















_int17stub    PROC FAR
              pushf
              push    ax
              push    bx
              push    cx
              push    dx
              push    ds
              push    es
              push    bp
              push    si
              push    di

              mov     bp,sp

              call    _MyINT17

              pop     di
              pop     si
              pop     bp
              pop     es
              pop     ds
              pop     dx
              pop     cx
              pop     bx

              test    ax,255
              jz      chain_17

              pop     ax
              popf
              iret             



chain_17:     pop     ax
              popf

              jmp     dword ptr cs:_Chain17

_int17stub    ENDP








_IPXEntry     PROC    FAR
            call    cs:_myIPXLocation
            retf
_IPXEntry     ENDP




_CallOld17    PROC    FAR
            push    cx
            push    si
            push    di
            push    bp
            push    ds
            push    es

            pushf
            call    dword ptr cs:_Chain17

            pop     es
            pop     ds
            pop     bp
            pop     di
            pop     si
            pop     cx
            retf
_CallOld17    ENDP





_myIPXLocation      dd      0
_Chain21            dd      0
_Chain2F            dd      0
_Chain17            dd      0


tmpStack            dw      64 dup (0)
tmpStkEnd           dw      0

tmpax               dw      0
tmpss               dw      0
tmpsp               dw      0

_glob               db      01000h dup (0)



;
;
; resident part of PSC ends inside the _glob object;
;
;   &_glob + sizeof(GLOBALS)   (rounded up to next paragraph boundry)
;
;



save_ss     dw      0
save_sp     dw      0
mypsp       dw      0








_UnloadTSR    PROC  FAR
            push  cx
            push  dx
            push  ds
            push  es
            push  bp
            push  si
            push  di
            pushf

            cld

            mov   bx,ax                   ; passed in 
            mov   es,bx                   ; psp of tsr 

            mov   di,10
            mov   ax, offset cs:tsrTerm   ; store exit handler offset 
            stosw
            mov   ax,cs                   ; store exit handler seg 
            stosw
            mov   di,16h
            mov   ax,cx                   ; passed in 
            stosw                         ; set tsr's parent to my PSP 

            mov   [word ptr mypsp],ax     ; save my psp for later 

            mov   [word ptr save_ss], ss
            mov   [word ptr save_sp], sp


            mov   ah,50h
            int   21h                     ; using BX, set current PSP to tsr 

            mov   ax,4c00h
            int   21h                     ; terminate tsr; doesn't return


tsrTerm:    mov   ss,[word ptr save_ss]
            mov   sp,[word ptr save_sp]

            mov   ah,50h         
            mov   bx,[word ptr mypsp]
            int   21h                     ; reset current PSP to me 

            popf
            pop   di
            pop   si
            pop   bp
            pop   es
            pop   ds
            pop   dx
            pop   cx

            retf
_UnloadTSR    ENDP




_IPXGetAddr   PROC  FAR
            push    cx
            push    dx
            push    ds
            push    es
            push    si
            push    di
            push    bp

            mov     AX, 7A00h
            int     2Fh

            mov     [word ptr _myIPXLocation], di
            mov     [word ptr _myIPXLocation + 2], es

            pop     bp
            pop     di
            pop     si
            pop     es
            pop     ds
            pop     dx
            pop     cx

            retf
_IPXGetAddr   ENDP




              END


