/* YARNDIAL.CMD v 1.34(beta) by Jerry Levy 	17 Sep 1996
Comments appreciated: send to jlevy@ibm.net
(Jerry Levy, Marblehead, MA USA) */

version = '1.34(beta)'

/*

=======ERROR TRAPPING   =========
We can trap and identify various types of ReXX error
conditions:  Error, Syntax, Failure, Novalue, Halt
and Notready, by setting 
	local_error_trapping = 1

Default is
	local_error_trapping = 0
but if you have problems, briefly setting this equal
to 1 may help you identify source of an error.
==================================

*/
local_error_trapping = 0
/*
===========History============
See YD.DOC for details.

YARNDIAL.CMD v 1.34	17 Sep 96

	and companion installer:
YDINSTL.CMD  v 0.94	17 Sep 96


==========COPYRIGHT NOTICE AND DISCLAIMER=============
YDINSTL.CMD is Copyright 1996 by Jerry Levy (all rights reserved)
YARNDIAL.CMD is Copyright 1995 and 1996 by Jerry Levy (all rights reserved)

These are provided as-is and without charge, with no warranty expressed
or implied as to merchantability or fitness for any particular purpose.  All
responsibility for any and all incidental and consequential damages is
disclaimed.  These programs and associated text files are freeware.  They
may be distributed without restriction providing: (1) this notice and
disclaimer remain intact, (2) all programs and files are included and
unchanged, and (3) they are distributed either in the original .zip archive
or the archive after being unzipped into a folder or onto a disk or other
medium.  Use of either or both of these programs constitutes acceptance
of these terms by all users.

================INSTALLATION======================
You could read YD.DOC.
Or you could read README.1ST (shorter, recommended).

If YARN and SOUPER are installed and run OK...

...and if you are using the IAK Dialer to connect to Advantis,
or the Dial-Other-Internet_Providers utility (SLIPPM.EXE)...

then just run YDINSTL.CMD.
==================================================
 
*/

arg otherparms		/* for later contingency */

cr = d2c(13)		/* enter key, as well as carriage return */
crlf = d2c(13) || d2c(10)	/* carriage return + linefeed */
escape = d2c(27)	/* escape character */
ctrl_Q = d2c(17)
ctrl_R = d2c(18)
bs = d2c(8)	/* Backspace */
tab = d2c(9)	/* tab */
X1 = d2c(0)	/* Extended key */
X2 = d2c(224)	/* Extended key */

say ''
say 'YRNDIAL.CMD v' || version
say '(c) 1995 & 1996 by Jerry Levy (all rights reserved)'
say 'jlevy@ibm.net	Marblehead, MA USA'
say ''
say 'Dials in, gets or posts news, mail and replies.'
say 'Normal operation is to sign off when done.' crlf
time1 = time()
date1 = date('S')
date1 = left(date1,4) || '/' || substr(date1,5,2) || '/' || right(date1,2)
/* format date as yyyy/mm/dd */

/* This program has been tested with various recent YARN and
SOUPER versions through YRN2_091 and SOUPER15 */

if local_error_trapping then signal on failure
if local_error_trapping then signal on halt
if local_error_trapping then signal on syntax
if local_error_trapping then signal on notready
if local_error_trapping then signal on error
if local_error_trapping then signal on novalue

trace 'N'

timeout = 0
/* Flag is reset to 1 if dialer times out */

Abandon = 0     /* Initialize*/
replies_zip = 1	/* if we try to export mail and there is none, this is reset to 0 */
do_catchup_on_news = 0	/* initialize the flag to no news catchup */

/* MAIN PROGRAM */

/* Load Rexx Util functions if not already loaded */
if RxFuncQuery('SysLoadFuncs') \= 0 then
   do
      call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
      call SysLoadFuncs
   end

/* Initialize these filenames */
go_exe = 'GO.EXE'
ydinstl_cmd = 'YDINSTL.CMD'
ydparms_dat = 'YD_PARMS.DAT'
killjoy_exe = 'KILLJOY.EXE'
alt_dialer_exe = 'SLIPPM.EXE'

'@echo off'				/* No echoing of any os/2 commands */
home = directory()			/* Where we are executing this pgm from */
home = translate(home)

ydparms_dat = home || '\' || ydparms_dat /* All the parameters we need are here */
/* Abort if can't locate the ydparms_dat.  Means we never ran the installer */
if stream(ydparms_dat, 'c', 'query exists') = '' then
   do
      go_exe = home || '\' || go_exe	/* assume that's where it is */
      call beep 1000, 200
      say 'Cannot find YD_PARMS.DAT, the file containing parameters'
      say 'YARNDIAL needs in order to run.  This is normal if you have'
      say 'not yet run the installer,' ydinstl_cmd || '.'
      say ''
      say 'Aborting.  Press any key to exit.  Then run' ydinstl_cmd
      call SysGetKey 'NOECHO'
      signal goodbye
   end

say 'Please wait while parameters load and we perform our setup...'


do_not_kill = 0

/* Read parameters in from the ydparms.dat datafile */
call parms_from_ydparms_dat
/*
============
DO NOT KILL OPTION
If the DO_NOT_KILL_CONNECTION parameter in YD_PARMS.DAT =1
we can have the option come up in the main menu to kill or not
to kill the connection when YARNDIAL finishes.  If it is zero,
we always kill the connection at the end.

dnk.1 thru .7 are the "do-not-kill" alternatives to
1-7 and on the main menu.  If do_not_kill is enabled (=1)
you can execute the same functions as 1-7 but dialers, slip,
etc. are not shut down when done.

For non-US keyboards, you should edit DNK_STRING in YD_PARMS.DAT
for appropriate, convenient alternative keyboard chars to the
US-keyboard default of !@#$%^& (shift-1 thru shift-7).

We parse the dnk_string to the 7 individual dnk.i alternate chars.
============
*/
if pos(do_not_kill_connection, '01') = 0 then do_not_kill_connection = 0

dnk_string = '!@#$%^&'	/* shift-1 thru shift-7 on a US keyboard */

do i = 1 to 7
   if substr(dnk_string, i, 1) \= '' & substr(dnk_string, i, 1) \= ' ' then
      dnk.i = substr(dnk_string, i, 1)
   else dnk.i = i
end

/*
==================
Get alt_dialer_exe filename.  Strip path, "." and extension,
and also strip any options that may have been entered.
alt_dialer_exe stores the name of the dialer executable. 
==================
*/
parse var alt_dialer_exe alt_dialer_name alt_dialer_options	/* strip options */
alt_dialer_name = translate(alt_dialer_name)   		/* upper case */
alt_dialer_name = filespec('name', alt_dialer_name)		/* eliminate drive and path */
parse var alt_dialer_name alt_dialer '.' ext			/*...and extension */


/*
====================
(Re)set HOME and YARN environmental variables.
Later, in the dialup_server() routine, we will (re)set
the NNTPSERVER (newsserver, =default_news) environmental variable.
In dialup_server() routine we decide the correct
newsserver assignment, then we set NNTPSERVER to that.
====================
*/

x = SetLocal()
x = value('home', home, 'OS2ENVIRONMENT')
x = value('yarn', yarn, 'OS2ENVIRONMENT')

/* We look for some obvious inconsistencies or omissions in YDPARMS_DAT */
call fatal_error_check

call directory_maintenance

/* are we connected? to whom? is it the right connection? */
call get_current_connection

/*
=============================================
This is the main menu.  If we select 7 (souper options)
we first dial in to the system and only after we're connected
do we get to select the options.  Then we get another menu
asking if we want to get or send stuff.
=============================================
*/
   say ''
   say 'MAIN SELECTION MENU'
   say '1  Only import Mail'
   say '2  Only import News Articles'
   say '3  Only import, but both Mail AND News'
   say '4  Only export (send Mail, Posts, Replies, and Follow-ups)'
   say '5  Everything: Get mail and news AND send Posts, Replies, and Follow-ups'
   say '6  Complete an interrupted importation of mail/news'
   say '         or rebuild a corrupted YARN history file'
   say '7  Souper options:  one-time-only changes in how souper runs:'
   say '      Catchup on News'
   say '      Maximum News Packet Size'
   say '      Do not retrieve newsgroup articles longer than set number of lines'
   say '      Read-only for Mail: Don''t empty POP3 mailbox'
   say 'Press:'
   say '    1 2 3 4 5 6 7   Executes functions as shown; goes off-line when done'
   if do_not_kill_connection then	/* ...then we have a choice */
      do
         say ' or' dnk.1 dnk.2 dnk.3 dnk.4 dnk.5 dnk.6 dnk.7,
          '  Same functions; connection remains up'   
      end
   say 'Enter Selection'
   say '  [or Escape key to exit now which also closes connection]:'
 
do until pos(choice, '1234567' || Escape) \= 0 
   choice = SysGetKey('NOECHO')

/*
==================
We can select dnk.1 thru 7 whereby we elect to do the same things
as for choices 1 thru 7 except we do not close down dialer
and other connection stuff at the end.  If any of the dnk. characters
are the 1,2,3,4,5,6, or 7, the numeric choice takes 

dnk.1 thru 7 default to the shift-key characters
[on a US keyboard !@#$%^&] for keypresses 12345677]
==================
*/

   select
      when choice = Escape then
         do
            say 'Quitting...'
            signal goodbye
         end
      when pos(choice, '1234567') = 0 & \do_not_kill_connection then
         do
            say ''
            say 'Selection must be 1-7 or Escape key.  Try again...'
            say ''
        end
      when pos(choice, '1234567') = 0,
         & do_not_kill_connection,
         & pos(choice, dnk_string) = 0 then
         do
            say ''
            say 'Not an allowable selection, try again...'
            say ''
        end
      when pos(choice, '1234567') = 0,
          & pos(choice, dnk_string) \=0  then
         do
            do_not_kill = 1 
            if choice = dnk.1 then choice = 1
            if choice = dnk.2 then choice = 2
            if choice = dnk.3 then choice = 3
            if choice = dnk.4 then choice = 4
            if choice = dnk.5 then choice = 5
            if choice = dnk.6 then choice = 6
            if choice = dnk.7 then choice = 7
         end
      otherwise NOP
   end	/* of Select */
   dnk_alert = ''
   if do_not_kill = 1 then dnk_alert = '  (connection will stay up when finished)'
   say ''
   say 'Menu Selection: ' choice dnk_alert
   say ''
end	/* of Do Until Pos(choice, '1234567' || Escape) */

/*
====================
A home\replies folder (empty) may be left behind as trash
after execution of mail/news retrieval from some Yarn/Souper
installations. We get rid of it if your setup of Yarn/Souper
leaves one behind.
====================
*/
replies_dir = home || '\replies'
call SysRmDir replies_dir

   /* Fix the interrupted import */
if choice = pos(choice, 'xxxxx6x') then
   do
      call fix_import
      signal goodbye			/* Exit the program when done */
   end
if choice = pos(choice, 'xxxxxx7') then
   do
      call SysCls
      say ''
      say 'You selected to modify souper options.'
      say ''
      say 'We will first dial in.'
      say ''
      say 'After a connection is successfully established you will'
      say 'be asked to select your one-time-only souper options.'
      say ''
      say 'When you are finished with that, another menu will pop'
      say 'up asking if you want to get news or mail, or send posts.'
      say ''
      say 'To quit now, press Escape'
      say 'Any other key starts the dialup connection or uses one already up'
      if SysGetKey('NOECHO') = Escape then signal goodbye
      else NOP
    end
call dialup_server
call time('R')		/* start clock recording time on line */

/*
=================
These next conditionals process selections we made from the main menu.
Choices 1-5 selected below from menu2 perform the identical functions
to those for functions 1-5, respectively, selectable from main menu
=================
*/
      if choice = pos(choice, 'xxxxxx7') then
         do
            call souper_options
            choice = menu2()
         end
      if choice = pos(choice, '1x3x5xx') then call import_mail
      if choice = pos(choice, 'x23x5xx') then call import_news
      if choice = pos(choice, 'xxx45xx') then call exporter

call kill_dialers_slip_ppp_slattach		/* Kill these and slattach, too */

call restore_zip	/* If sending went south on you, you can restore to send again */
call toss_old_news

signal Depart				/* Exit and report times */

/*
=================
End of main program
=================
*/

/*
=======================================
fatal_error_check()

We check for some obvious flaws in the data
returned from YDPARMS_DAT
=======================================
*/

fatal_error_check:
service = translate(service)		/* Upper case */

if pos(connection_type, '134567') = 0 then	/* 2 is reserved for future use */
   do
      say 'Fatal error in' ydparms_dat '; the connection_type'
      say 'can only be 1, or 3-7'
      say ''
      Abandon = 1
   end

if connection_type = pos(connection_type, '13457') & dialup_string = '' then
   do
      say 'Fatal error in' ydparms_dat
      say 'Dialup_string is blank.  Cannot be blank if connection_type is 1, 3-5, or 7.'
      say ''
      Abandon = 1
   end

if service = '' then
   do
      say 'Possible error in' ydparms_dat '; SERVICE field is blank.'
   end

if pos(interface_removal, '012') = 0 then
   do
      say 'Fatal error in' ydparms_dat '; interface_removal'
      say 'can only be 0, 1 or 2'
      if pos(interface_removal, 'Oo') \=0 then
         say 'You have the letter' pos(interface_removal, 'Oo') 'there now.'
      say ''
      Abandon = 1
   end

if Abandon = 1 then
   do
      say 'Aborting...'
      signal goodbye
   end
RETURN

/*
=================
get_current_connection()

(1)  Check whether slippm.exe, slip.exe, ppp.exe, in-joy.exe,
IAK Dialer, ilink2.exe are running.  Are what is running the right
processes for our connection_type and service (SLIP or PPP)?
Of these processes:
	SLIP.EXE
	PPP.EXE
	SLIPPM.EXE
	IN-JOY.EXE
	ILINK2.EXE
	the IAK Dialer
        whatever alt_dialer_exe is

Close down any that are not consistent with
our connection_type.

Then determine: which ones are (left) running?

(2)  Get full path to tcpos2.ini  and to the resolv file.  The
directories for both are pointed to by the etc environment
variable.

Then query the CONNECTION app in TCPOS2.INI.  The
CURRENT_CONNECTION key tells us to whom we are
connected (if we are connected), but this only applies to
dialups made by SLIPPM.EXE, PPP.EXE, SLIP.EXE, ILINK2.EXE
and any others that use TCPOS2.INI (IN-JOY does not).

We should also see clues to what provider we are connected to
(nameserver, domain) in the RESOLV file. 

(3)  Check for sl and ppp router interfacess
====================
*/
get_current_connection:
say 'Check for an existing connection, and whether it is correct for us:'
say '   Active dialers? Active SLIP?  Active PPP?'

if connection_type = 1 then	/* IBM/Advantis IAK Dialer only */
   do
      service = 'SLIP'	/* must be SLIP for the IAK Dialer */
      call close_down 'ppp'	/* ...because none of these should be running */
      call close_down 'slippm'
      call close_down 'in-joy'
      call close_down 'ilink2'
      if alt_dialer \= 'DIALER' then
         call close_down alt_dialer
   end

/* for connection_type 6 (pot luck) we check (almost) nothing */
if connection_type = 6 then
   do
      if service = 'PPP' then call close_down 'slip'
      if service = 'SLIP' then call close_down 'ppp'
   end

if pos(connection_type, '45') \= 0,
   & alt_dialer = 'SLIPPM' then
   do
      call close_down 'in-joy'
      call close_down 'dialer'
      call close_down 'ilink2'
   end

if pos(connection_type, '45') \= 0,
   & alt_dialer = 'IN-JOY' then
   do
      call close_down 'slip'	/* IN-JOY doesn't use this...*/
      call close_down 'ppp'	/* ...or these...*/
      call close_down 'slippm'
      call close_down 'ilink2'
      call close_down 'dialer'	/*...IAK Dialer */
   end

if pos(connection_type, '45') \= 0,
   & alt_dialer = 'ILINK2' then
   do
      call close_down 'in-joy'
      call close_down 'dialer'
      call close_down 'slippm'
   end

if pos(connection_type, '45') \= 0,
   & alt_dialer \= 'SLIPPM',
   & alt_dialer \= 'ILINK2',
   & alt_dialer \= 'DIALER',
   & alt_dialer \= 'IN-JOY' then
   do
      call close_down 'slippm'
      call close_down 'ilink2'
      call close_down 'dialer'
      call close_down 'in-joy'
   end

if connection_type = 3 then	/* PPP.EXE or SLIP.EXE dialup string only */
   do
      if service = 'SLIP' then
         call close_down 'ppp'
      if service = 'PPP' then
         call close_down 'slip'
      call close_down 'slippm'
      call close_down 'in-joy'
      call close_down 'ilink2'
      if alt_dialer \= 'PPP' & alt_dialer \= 'SLIP' then
         call close_down alt_dialer
   end


/*
===============
See what stuff related to dialers or dialup strings may
be running

and

Poll the routers: e.g., is an sl or a ppp interface up?
Note, however, that what is returned may not be
currently active, and what is returned could represent
the last occurrence not a present connection.
Calls wait_for_interface(), which uses
NETSTAT.EXE -r to poll.
===============
*/

/*
==================
Below are flags.  They are set to 1 if a process is running
or if an interface is up.  Initialize all to zero
==================
*/

slip_is_running = 0
ppp_is_running = 0
IAKdialer_is_running = 0
slippm_is_running = 0
ilink2_is_running = 0
alt_dialer_is_running = 0
slipexe_or_pppexe_running = 0

some_interf_up = 0
ifprefix_interf_up = 0

/* are any of these running? */
call is_slip_running	/* If so returns slip_is_running=1 */
call is_ppp_running	/* If so returns ppp_is_running=1 */
call is_slippm_running	/* If so returns slippm_is_running=1 */
call is_ilink2_running	/* If so returns slippm_is_running=1 */
call is_IAKdialer_running	/* If so returns IAKdialer_is_running=1 */
call is_alt_dialer_running /* etcetera */
if slip_is_running | ppp_is_running then slipexe_or_pppexe_running = 1

say '   Checking router interfaces...'
/* Check for pppx or slx or lanx router interfaces
we may not use this information, but this step is
done here in anticipation of future uses */

call are_there_interfaces_up


/*
==================
Get path to TCPOS2.INI file and RESOLV file,
Are files there?

Then get current_connection info from TCPOS2.INI
and stuff from RESOLV to help decide if connection
is right one for our YARN USER installation
==================
*/

tcpip_etc_path = value('etc', , 'OS2ENVIRONMENT')
tcpos2_ini = tcpip_etc_path || '\' || 'tcpos2.ini'
if stream(tcpos2_ini, 'c', 'query exists') = 0 then
  say 'Couldn''t find' tcpos2_ini

resolv_ = tcpip_etc_path || '\' || 'resolv'
if stream(resolv_, 'c', 'query exists') = 0 then
  say 'Couldn''t find' resolv_

/*
==========
TCPOS2.INI inquiries
==========
*/
current_connection_key = SysIni(tcpos2_ini, 'CONNECTION', 'CURRENT_CONNECTION')

/* strip final null char */
current_connection_key = strip(current_connection_key, 'T', X1)
userID_connected = SysIni(tcpos2_ini, 'CONNECTION', current_connection_key)
userID_connected = strip(userID_connected, 'T', X1)
parse var userID_connected user_ID ',' system_app

/*
====================
Next we will decide if we need to dial or whether we
can use what may already be established as a connection.

When dial = 1 we need to dial.  We will determine
below whether, if we are already on line, we are online
to the provider for this user installation or not.  If
we cannot ID the provider as ours we simply close down
SLIP, PPP, SLIPPM, and the IAK DIALER and redial.  First
we set the dial flag (set dial = 1), then we determine
if we should really dial.  If we are connected to our
provider we zero the dial flag.
====================
*/

dial = 1	/* initialize it */

/*
====================
Compare some parms we just got from the CONNECTION
app of TCPOS2.INI to corresponding information in our
YDPARMS_DAT.  Or are we ADVANTIS?  We can make a pretty
good (not perfect) assessment in this simple way whether
we are connected to the right provider.
====================
*/
if alt_dialer_is_running & some_interf_up & connection_type \= 7 then
select

   when connection_type = 1,
      & IAKdialer_is_running,
      & translate(user_id) = translate(login_id),
      & translate(system_app) = 'ADVANTIS' then
         do
            say 'Two beeps means' user_id 'is already connected to ADVANTIS.  Proceed.'
            call connected_signal
         end

   when connection_type = 4,
      & (slippm_is_running | ilink2_is_running),
      & translate(user_ID) = translate(login_id) then
         do
            say 'Two beeps means we are already logged in as'
            say user_id '(Pop_ID:' pop_id || ').  Proceed.'
            call connected_signal
         end
   
/* How can we identify whether we are the right connection with IN-JOY if
IN-JOY does not communicate with TCPOS2.INI?  We can set the interface name
in setting up injoy so that it is unique and only applies to that connection being
made with IN-JOY.  If we don't set up a unique name, we are no worse off than
not checking at al.l.  make_if_list() generates a string with all interfaces up
(including their metrics) and we look for interf_prefix in that string using the
ReXX pos() function
*/
   when (connection_type = 4 | connection = 5) & alt_dialer = 'IN-JOY',
      & pos(translate(interf_prefix), make_if_list()) \= 0 then
               do
                  say 'Two beeps means we are already connected.  Proceed.'
                  call connected_signal
               end
   
   when connection_type = 3,   /* slip.exe or ppp.exe dialer string */
      & translate(user_ID) = translate(login_id) then
         do
            say 'Two beeps means we are already logged in as'
            say user_id '(Pop_ID:' pop_id || ').  Proceed.'
            call connected_signal
         end
   
   when connection_type = 6 then
      dial = 0	/* Pot Luck */

   otherwise
         say 'Connected, but to a provider or for a connection different than'
         say 'the one for which this YARN user installation was configured.'
         say 'We are closing down SLIP, PPP, SLIPPM and IAK Dialer or IN-JOY'
         say '(if any are up) so we can dial up to our provider...'
         say ''
         dial = 1	/* we will dial when we hit dialup_server() */
         call kill_all   /* kill IAK dialer, slippm, slip, ppp, slattach, just in case */
end   /* of select */

if connection_type = 7 | \some_interf_up then dial = 1

RETURN


/*
===============
connected_signal()
Double-beep if connected
===============
*/
connected_signal:
say ''
call beep 1000, 200
call beep 32767, 25  /* Too high pitched, inaudible, an improvised pause. */ 
call beep 1000, 200
dial = 0	/* unset the flag: we do not need to dial up server */
RETURN


/*
=====================
directory_maintenance()

Some grunt work to get drives, directories we need.
=====================
*/

directory_maintenance:
home_drive = filespec('drive', home)
parse var reply_packet rpname '.' ext
yarn_outgoing_drive = filespec('drive', reply_packet)
yarn_outgoing_dir = yarn_outgoing_drive || strip(filespec('path', reply_packet), 'T', '\')

call SysMkDir home || '\incoming'
/* For temp storage of incoming mail and news */

RETURN

/*
================
 routines use GO.EXE to let us determine whether
	SLIP.EXE
	PPP.EXE
	SLIPPM.EXE
	IN-JOY.EXE
	ILINK2.EXE
	DIALER.EXE
	alt_dialer_exe (whatever it is)
are running processes
================
*/

is_slip_running:
signal off error
slip_is_running = 0
go_exe '-cp SLIP > NUL'	/* returns 1 if slip is running, 0 if not */
If RC=1 then
   do
      slip_is_running = 1
   end
if local_error_trapping then signal on error
RETURN

is_ppp_running:
signal off error
ppp_is_running = 0
go_exe '-cp PPP > NUL'	/* returns 1 if ppp is running, 0 if not */
If RC=1 then
   do
      ppp_is_running = 1
   end
if local_error_trapping then signal on error
RETURN

is_slippm_running:
signal off error
slippm_is_running = 0
go_exe '-cp SLIPPM > NUL'	/* returns 1 if slippm is running, 0 if not */
If RC=1 then
   do
      slippm_is_running = 1
   end
if local_error_trapping then signal on error
RETURN

is_ilink2_running:
signal off error
ilink2_is_running = 0
go_exe '-cp ILINK2 > NUL'	/* returns 1 if ilink2 is running, 0 if not */
If RC=1 then
   do
      ilink2_is_running = 1
   end
if local_error_trapping then signal on error
RETURN

is_IAKdialer_running:
signal off error
IAKdialer_is_running = 0
go_exe '-cp DIALER > NUL'	/* returns 1 if IAK Dialer is running, 0 if not */
If RC=1 then
   do
      IAKdialer_is_running = 1
   end
if local_error_trapping then signal on error
RETURN

is_alt_dialer_running:
signal off error
alt_dialer_is_running = 0
go_exe '-cp' alt_dialer '> NUL'	/* returns 1 if running, 0 if not */
If RC=1 then
   do
      alt_dialer_is_running = 1
   end
if local_error_trapping then signal on error
RETURN

/*
====================
This is the menu that comes up after we have made
one-time-only changes (i.e., for this session only) to the
souper command-line options
====================
*/
 
menu2:
   say ''
   say '   Any changed option settings are in force for this session only.'
   say ''
   say 'Press:'
   say '1  Only import Mail'
   say '2  Only import News Articles'
   say '3  Only import, but both Mail AND News'
   say '4  Only export (send Mail, Posts, Replies, and Follow-ups)'
   say '5  Everything: Get mail and news AND send Posts, Replies, and Follow-ups'
   say 'Pressing Esc key exits now.  Enter Selection:'
 
do until pos(choice, '12345') \= 0 
   choice = SysGetKey('NOECHO')
   select
      when choice = Escape then signal goodbye
      when pos(choice, '12345') = 0 then
         do
            say ''
            say 'Selection' choice || '.  Must be 1-5 or Escape key.  Try again...'
            say ''
        end
      otherwise NOP
   end
   say ''
   say 'Selection: ' choice
   say ''
end
RETURN choice

/*
=========================================================
dialup_server()

Starts dialers.  As dialer is starting up and logging in,
wait_for_interface() starts a timed wait.  When we connect,
the wait_for_interface() senses a new ppp, slip, etc.
interface by interpreting the output of netstat.exe run with the -r
option, and this subroutine ends. If we time out, the
wait_for_interface() senses that and we exit YARNDIAL.

We start by reassigning some variables depending upon the
connection_type, then we start the actual dialup.

The dial variable was assigned 0 or 1 in the get_current_connection()
subroutine.  If dial=1 we must dial, if dial=0, we were connected to
the right provider already and do not dial.

=========================================================
*/
dialup_server:
/*
=============
connection_type 1 is for IAK Dialer only
=============
*/
if connection_type = 1 then				/* IAK Dialer only */
   do
      say 'Connecting to Advantis via the IAK Dialer...'
/* Now set or reset the NNTPSERVER environment variable to default_news */
      x = value('NNTPSERVER', default_news, 'OS2ENVIRONMENT')
      if dial then
         do
            say login_id 'dialing' account '<password> via use of IAK Dialer' 
         end
   end  	/* if connection_type = 1 */

if pos(connection_type, '34') \= 0 then
   do
/* Set or reset the NNTPSERVER environment variable to default_news */
      x = value('NNTPSERVER', default_news, 'OS2ENVIRONMENT')
      if dial then
         do
            if connection_type = 3 then say 'Dialing with a PPP.EXE or SLIP.EXE dialup string'
            if connection_type = 4 then say 'Dialing' host_app 'with' alt_dialer_exe
         end
   end    /* if connection_type 3 or 4 */

/*
=============
For connection_type 6 (especially), but also for
5 and 7, we are a bit more flexible about where
some parms we need may be found in YD_PARMS.DAT
=============
*/
if pos(connection_type, '567') then
   do
/* Set or reset the NNTPSERVER environment variable to default_news */
      x = value('NNTPSERVER', default_news, 'OS2ENVIRONMENT')

      if connection_type = 5 then
         do
            say 'YD_PARMS.DAT was manually configured: Dialing with'
            say 'dialup_string in YD_PARMS.DAT...'
         end

      if connection_type = 6 then
         do
            say 'Will not attempt to validate vs. parameters in YD_PARMS.DAT'
            say 'Trying to use any currently established connection...'
         end

      if connection_type = 7 then
         do
            say 'Will not attempt to validate vs. parameters in YD_PARMS.DAT'
            say 'Dialing with dialup_string in YD_PARMS.DAT...'
         end
   end   	/* if connection_type 5, 6 or 7 */

/*
===================
Dial up.
Unless we are connection_type 6, we wait for
sl0 or ppp0 interface before going on to get/send
mail or news.  Or if we time out after 'wait'
seconds, we exit
===================
*/
if connection_type = 1 & dial then
   do
     call make_if_list
     interpret dialup_string

 /* 'wait' = seconds to wait for a connect */
      call wait_for_interface wait, 0
      if \found_interface then
         do
            timeout = 1
            say ''
            say 'Dialer timed out.  Exiting...'
            call time('R')  /* No connection.  We zero the elapsed-time clock */
            if local_error_trapping then signal on error
            signal goodbye
         end
    end

if pos(connection_type, '3457') \=0 & dial then
   do
      call make_if_list
      interpret dialup_string
      call wait_for_interface wait, 0
      if \found_interface then
         do
            timeout = 1
            say ''
            say 'Dialer timed out.  Exiting...'
            call time('R')
            if local_error_trapping then signal on error
            signal goodbye
         end
   end
RETURN

/*
============================
import_mail()
import_news()
exporter()

Believe it or not, executing these three subroutines
are the substance of YarnDial.  The other 90% of
this exercise is fluff.
============================
*/

import_mail:
home_drive
'cd' home || '\incoming'	
say 'You are now importing mail from' popsrvr
signal off error
signal off failure
souper_exe souper_getmail_std_options getmail_xtra_options popsrvr pop_id pop_pwd
zip_exe 'soup.zip areas *.msg'
import_exe 'soup.zip'
if local_error_trapping then signal on error
if local_error_trapping then signal on failure
say ''
RETURN

import_news:
home_drive
'cd' home || '\incoming'
say 'You are now importing news from' default_news
signal off error
signal off failure
souper_exe souper_getnews_std_options getnews_xtra_options default_news pop_id pop_pwd
zip_exe 'soup.zip areas *.msg'
import_exe 'soup.zip'
if local_error_trapping then signal on error
if local_error_trapping then signal on failure
say ''
RETURN

exporter:
say crlf || 'You are now exporting posts, replies, and follow-ups'
say 'to' mail_gw
/* if a reply-packet exists, send mail */
if stream(reply_packet, 'c', 'query exists') \= '' then
   do
      yarn_outgoing_drive	/* Change to outgoing drive and directory */
      'cd' yarn_outgoing_dir
      'copy' reply_packet rpname || '.BAK > nul'
      unzip_exe reply_packet
      signal off error
      signal off failure
      souper_exe souper_send_std_options send_xtra_options mail_gw pop_id pop_pwd
      'erase' reply_packet
   end
else	/* tell us nothing waiting to be sent */
   do
      say ''
      say reply_packet 'not found.'
      say 'Means no replies are waiting to be sent.'
      replies_zip = 0
   end
if local_error_trapping then signal on error
if local_error_trapping then signal on failure
RETURN

/*
=====================
catch()

For catching up on news.  Sets the Howmany variable.
Howmany is number of unread news articles (max) we
retrieve from each newsgroup (all the older ones
in each newsgroup are marked as read)
=====================
*/
Catch:
HowMany = ''
call SysCls
say 'News catchup was selected'
say ''
say ''
say 'Mark every article not yet downloaded in'
say 'each newsgroup as read except for the last n articles.'
do until DataType(HowMany,'W')
   say 'Enter n (Max number to be transferred to you).'
   prompt = 'It must be a whole number  (Esc exits now):'
   say prompt
   parse value SysCurPos() with row col
   row  = row - 1
   col = length(prompt) + 2
   call SysCurPos row, col
   pull HowMany .
   if HowMany = Escape then
      do
         say 'Esc pressed, Quitting...'
         signal goodbye
      end
   if DataType(HowMany) = 0 then
      say 'Whole number only. Try Again.' 
end
RETURN

fix_import:
/*
===================
if for some reason the imported mail or news files
were not zipped and/or they were not imported into
YARN repositories correctly (for example, if your
machine crashed or if you had yarn running while
SOUPER was fetching them), this option may be able
to zip into soup.zip any that were unzipped at the
time, and will process the soup.zip and import the
messages.  In case YARN's history file might have
become corrupted in the process or has independently
become corrupted, it will also (try to) rebuild it.

Before we do anything, though, we kill slip, ppp,
IAKdialer, etc., so we are doing whatever we do (which
takes a long time) while off-line. 
=================
*/
say 'If on-line, we will get off line.  This may take several seconds...'
call kill_dialers_slip_ppp_slattach		/* Kill these and slattach, too */
						/* and in-joy if we are connection_type 4 */

say crlf || 'IMPORTING WAS INTERRUPTED? NEED TO REBUILD YARN History File?'
say 'If either you did not complete the importing of news or mail and/or'
say 'if YARN''s History File has become corrupted, we can now try to complete'
say 'the importing of mail and news and also do a YARN History File rebuild.'
say 'The rebuild may take some time...'
say ''
say 'Don''t bother with this unless you think you have a problem or fetching'
say 'and importing of mail/news was interrupted.' 
say ''
say 'CTRL-Q quits now without doing anything.  Any other key continues: '

if SysGetKey('NOECHO') = ctrl_Q then signal Goodbye 

home_drive
'cd' home || '\incoming'	
signal off failure
signal off notready
signal off error
zip_exe 'soup.zip areas *.msg'
if stream('soup.zip', 'c', 'query exists') \= '' then	/* scrub import if no zipfile */
   do
      import_exe 'soup.zip'
   end
if local_error_trapping then signal on failure
if local_error_trapping then signal on notready
if local_error_trapping then signal on error
rebuild_exe '-s'		/*fixes spool file, rebuilds history file */
rebuild_exe '-o'		/* rebuilds history and overview files */
say ''
RETURN

kill_dialers_slip_ppp_slattach:	/* kill these, and tell us about it */

say ''
if \do_not_kill then
   do
      say 'Killing dialer(s), slip.exe, ppp.exe, etc., if up...'
      call kill_all	/* next routine does the contract */
      say 'We are off-line now.'
   end
else
   do
      say 'Beeping to remind you that YOU MAY STILL BE CONNECTED!'
      say 'When ready to disconnect, run LOGOFF.CMD or close down dialer.'
      call beep 1000, 200
      call beep 32767, 25  /* Too high pitched, inaudible, an improvised pause. */ 
      call beep 1000, 200
   end
say ''
t = time('E')			/* elapsed time, souper processes only */
RETURN

kill_all:		/* calls to this routine kill everything quietly */
call close_down 'DIALER'
call close_down 'SLIP'
call close_down 'PPP'
call close_down 'SLATTACH'
call close_down 'SLIPPM'
call close_down 'ILINK2'
if alt_dialer \= 'DIALER',
   & alt_dialer \= 'SLIP',
   & alt_dialer \= 'PPP',
   & alt_dialer \= 'SLIPPM',
   & alt_dialer \= 'ILINK2',
   & alt_dialer \= 'IN-JOY' then
      call close_down alt_dialer
if stream(killjoy_exe, 'c', 'query exists') \= '' then
   do
      killjoy_exe
      call SysSleep 2	/* settle time */
   end
call close_down 'IN-JOY' 
call SysSleep 2		/* just in case, wait a bit and re-kill */
call close_down 'DIALER'
call close_down 'SLIP'
call close_down 'PPP'
call close_down 'SLATTACH'
call close_down 'SLIPPM'
call close_down 'ILINK2'
if alt_dialer \= 'DIALER',
   & alt_dialer \= 'SLIP',
   & alt_dialer \= 'PPP',
   & alt_dialer \= 'SLIPPM',
   & alt_dialer \= 'ILINK2',
   & alt_dialer \= 'IN-JOY' then
      call close_down alt_dialer
if stream(killjoy_exe, 'c', 'query exists') \= '' then
   do
      killjoy_exe
      call SysSleep 2	/* settle time */
   end
call close_down 'IN-JOY' 
if interface_removal \= 0 then
   call routings_to_hosts(interf_prefix)	/* and clear out interfaces */
RETURN


/*
=========================================
close_down(process)

Close down a process (such as slip or ppp or slippm) with
GO.EXE using the -ka option kills all instances of 'process'.
No harm done if 'process' not running  and we try to close it down.
=========================================
*/
close_down:
parse upper arg process
signal off error
go_exe '-cp' process '> NUL'	/* returns RC=1 if process is running and 0 if not */
if RC=1 & process = 'DIALER' then
   do
      call is_IAKdialer_running
      if IAKdialer_is_running then 
         do
/* Only try to close this way if IAK duller is confirmed to be running */
            process '-c' /* hope IAK dialer is at least v 1.33 where -c option supported */
            call SysSleep 2 /* settle time, IAK Dialer is funny */
            say '   If you lost this window for a few seconds or just heard a beep'
            say '   that is normal for closing down certain versions of IAK Dialer.'
            say '   Completing shutdown may take a few moments...'
         end
   end
/* try to shut down in-joy with IN-JOY's own killjoy.exe */
if RC=1 & process = 'IN-JOY' then
   do
      if stream(killjoy_exe, 'c', 'query exists') \= '' then killjoy_exe
      call SysSleep 2	/* settle time */
   end
go_exe '-ka' process '> NUL'  /* do a kill whether running or not */
if local_error_trapping then signal on error

RETURN

/*
=================
routings_to_hosts(interf_prefix)

Only called if interface_removal is non-zero.

Examines routing table host routes reported out by running
	netstat -r
and then
if interface_removal = 1
	and if IN-JOY is the dialer and if the interf_prefix is IN-JOY's,
	deletes that routing entry.
if interface_removal = 2
	whatever the dialer and interf_prefix deletes all routing entries.
 

Why do this?  IN-JOY sometimes leaves a phantom routing in the tables
and it persists, once there, when other dialers are started after
that happens.
=================
*/
routings_to_hosts:
parse arg if_prefix
if_prefix = translate(if_prefix)
ifp_length = length(if_prefix)

'netstat -r | rxqueue'	/* send output to the queue */
do queued()
   dest = ''
   rtr = ''
   interf = ''
   parse pull netstat_line
   parse var netstat_line dest rtr .
   dest = strip(dest, 'B')
   rtr = strip(rtr, 'B')
   interf = word(netstat_line, words(netstat_line))
   interf = strip(interf, 'B')
   select
/* A headings line (first word is 'destination')? Discard the line */
      when translate(dest) = 'DESTINATION' then iterate

/* Blank dest or rtr? Discard the line, 'route delete' won't work */
      when dest = '' | rtr = '' then iterate

/* If interface_removal=1, IN-JOY, but not our interface,
also discard the line */
      when interface_removal = 1 & alt_dialer = 'IN-JOY',
         & translate(left(interf, ifp_length)) \= if_prefix then
            iterate

/* If interface_removal=1 and not IN-JOY,
discard the line */
      when interface_removal = 1 & alt_dialer \= 'IN-JOY' then iterate

/* Anything else, delete the routing */
      otherwise
         'route -h delete' dest rtr
   end	/* of Select */
end	/* of Do queued() */
RETURN



/*
=====================
restore_zip()

Chance to restore zipfile if sending didn't
seem to go right
=====================
*/

restore_zip:
rpname_bak = rpname || '.BAK'
/* if we were exporting posts and replies and if there was a reply_packet */
if pos(choice, 'xxx45xx') \= 0 & timeout = 0 & replies_zip then
   do
      say '     If you got an error sending posts and replies, press'
      say '     CONTROL-R now to restore' reply_packet
      say '     for re-transmission in a later session, but do this'
      say '     only if you got an error.'
      say '     Otherwise press any other key to continue exiting.'
      if SysGetKey('NOECHO') = ctrl_R then
         if stream(rpname_bak, 'c', 'query exists') \= 0 then  
            do
               say 'Restoring' reply_packet
               'copy' rpname_bak reply_packet '> nul'
           end
      else say 'No' rpname_bak 'to restore'
   end
RETURN

/*
================
toss_old_news()

Chance to remove old news using the expire program
===============
*/
toss_old_news:
   Prompt = 'Remove old (expired) yarn messages (Y/N)?'
   say prompt
   parse value SysCurPos() with row col
   row  = row - 1
   col = length(prompt) + 2
   call SysCurPos row, col
   if translate(SysGetKey('NOECHO')) = 'Y' then
      do
         say ''
         say 'Removing expired news' || crlf
         expire_exe '-o'	/* Remove old messages */
      end
RETURN

/*
===================
connect_stats()

How long were we on line retrieving or sending stuff?
==================
*/
connect_stats:
   say '   Retrieval and sending of news and/or mail took' trunc((t/60), 2) 'mins' 
RETURN

/*
==========
rslv_inq()
RESOLV file inquiries to get name of domain and
domain namserver address(es).

We don't use this because it interferes if we
probe the RESOLV file while communications
programs may be using it.  Maybe I'll find a way
so i left it here. 
==========
*/
rslv_inq:
domain_rslv = ''
dns_rslv = ''
dns2_rslv = ''

do until lines(resolv_) = 0
   x = linein(resolv_)
   push x
end

do queued()
  key = ''
  param = ''
  remainder = ''
  parse pull key param remainder 
  if translate(key) = 'DOMAIN' then domain_rslv = param
  if translate(key) = 'NAMESERVER' then dns_rslv = param
  if translate(key) = 'NAMESERVER' & dns_rslv \= '' then
     dns2_rslv = param
end
RETURN

/*
==========
nslookup_inq()
Inquiries made running nslookup

If run while connected, we can get name of domain
and its nameserver address.  If not connected, we get
the default domain name back but no nameserver address is
resolved.  Thus, if we get both a domain name back and a
nameserver address we are connected and if both agree with
what our YD_PARMS.DAT file has, we are connected to
the right one (to a good probability, i.e., you are not
connected several ways to the same domain and nameserver
address, but then, nothing's perfect, is it?).

So we don't screw up too badly, we plan only to use this for
IN-JOY dialer where there is no other means to verify right
connection obvious to us.  At this yime, it is not used even for
that while some problemsget worked out.
==========
*/
nslookup_inq:
'nslookup -all' domain_name '| rxqueue'
firstword = ''
rest = ''
domain_nslookup = ''
dns_nslookup = ''

do queued()
   parse pull line
   parse var line firstword '=' rest
   firstword = strip(firstword, 'B')
   rest = strip(rest, 'B')
   if translate(firstword) = 'DOMAIN' then
     do
        domain_nslookup = rest
     end 
   parse var line  firstword ':' rest length(rest)
   firstword = strip(firstword, 'B')
   rest = strip(rest, 'B')
   if translate(firstword) = 'ADDRESS' then
      do
         dns_nslookup = rest
      end
end
RETURN

/*
===================
parms_from_ydparms_dat()

Assign parameters based on what is in YDPARMS_DAT
==================
*/
parms_from_ydparms_dat:
/* Get parms from ydparms_dat */
n = find_equate_lines_in_datafile(ydparms_dat)
i = 1

/*
====================
Strip out all leading and trailing blanks and tabs
from parsed left and right sides of the equal sign.
Leave any internal ones alone
====================
*/

do until i = n
   parse var line.i parm.i '=' val.i
   parm.i = translate(parm.i)
   do until parm.i = stripped_parm.i & val.i = stripped_val.i
      stripped_parm.i = strip(parm.i, 'B')
      parm.i = strip(stripped_parm.i, 'B', tab)
      stripped_val.i = strip(val.i, 'B')
      val.i = strip(stripped_val.i, 'B', tab)
  end
   if abbrev(line.i, '#') then NOP
   else
          /* set up our variables */
      select
         when parm.i = 'HOME' then HOME = val.i 
         when parm.i = 'YARN' then YARN = val.i
         when parm.i = 'CONNECTION_TYPE' then connection_type = val.i
         when parm.i = 'INTERFACE_REMOVAL' then interface_removal = val.i
         when parm.i = 'HOST_APP' then host_app = val.i
         when parm.i = 'INTERF_PREFIX' then interf_prefix = val.i
         when parm.i = 'DIALUP_STRING' then dialup_string = val.i
         when parm.i = 'DO_NOT_KILL_CONNECTION' then do_not_kill_connection = val.i
         when parm.i = 'DNK_STRING' then dnk_string = val.i
         when parm.i = 'USER' then user = val.i
         when parm.i = 'HOST' then host = val.i
         when parm.i = 'ACCOUNT' then account = val.i
         when parm.i = 'ZIP_EXE' then zip_exe = val.i
         when parm.i = 'UNZIP_EXE' then unzip_exe = val.i
         when parm.i = 'REPLY_PACKET' then reply_packet = val.i
         when parm.i = 'SOUPER_EXE' then souper_exe = val.i 
         when parm.i = 'IMPORT_EXE' then import_exe = val.i 
         when parm.i = 'EXPORT_EXE' then export_exe = val.i 
         when parm.i = 'EXPIRE_EXE' then expire_exe = val.i 
         when parm.i = 'REBUILD_EXE' then rebuild_exe = val.i
         when parm.i = 'KILLJOY_EXE' then killjoy_exe = val.i
         when parm.i = 'ALT_DIALER_EXE' then alt_dialer_exe = val.i
         when parm.i = 'GO_EXE' then go_exe = val.i
         when parm.i = 'SOUPER_GETMAIL_STD_OPTIONS'
            then souper_getmail_std_options = val.i 
         when parm.i = 'GETMAIL_XTRA_OPTIONS'
            then getmail_xtra_options = val.i 
         when parm.i = 'SOUPER_GETNEWS_STD_OPTIONS'
            then souper_getnews_std_options = val.i 
         when parm.i = 'GETNEWS_XTRA_OPTIONS'
            then getnews_xtra_options = val.i 
         when parm.i = 'SOUPER_SEND_STD_OPTIONS'
            then souper_send_std_options = val.i 
         when parm.i = 'SEND_XTRA_OPTIONS'
            then send_xtra_options = val.i
         when parm.i = 'WAIT' then wait = val.i
         when parm.i = 'ASK' then ASK = val.i
         when parm.i = 'IS1' then IS1 = val.i
         when parm.i = 'IS2' then IS2 = val.i
         when parm.i = 'RS1' then RS1 = val.i
         when parm.i = 'RS2' then RS2 = val.i
         when parm.i = 'FS1' then FS1 = val.i
         when parm.i = 'FS2' then FS2 = val.i
         when parm.i = 'PIN' then PIN = val.i
         when parm.i = 'PROVIDER' then PROVIDER = val.i
         when parm.i = 'LOGIN_ID' then LOGIN_ID = val.i
         when parm.i = 'PWD' then PWD = val.i
         when parm.i = 'SAVE_PWD' then SAVE_PWD = val.i
         when parm.i = 'PHONE_NUMBER' then PHONE_NUMBER = val.i
         when parm.i = 'HANGUP' then HANGUP = val.i
         when parm.i = 'SCRIPT' then SCRIPT = val.i
         when parm.i = 'SERVICE' then SERVICE = val.i
         when parm.i = 'YOURIP' then YOURIP = val.i
         when parm.i = 'DESTIP' then DESTIP = val.i
         when parm.i = 'NETMASK' then NETMASK = val.i
         when parm.i = 'MTU_SIZE' then MTU_SIZE = val.i
         when parm.i = 'VJ_COMP' then VJ_COMP = val.i
         when parm.i = 'PRIMARY_INF' then PRIMARY_INF = val.i
         when parm.i = 'HOSTNAME' then HOSTNAME = val.i
         when parm.i = 'DOMAIN_NAME' then DOMAIN_NAME = val.i
         when parm.i = 'DNS' then DNS = val.i
         when parm.i = 'DNS2' then DNS2 = val.i
         when parm.i = 'DEFAULT_NEWS' then DEFAULT_NEWS = val.i
         when parm.i = 'DEFAULT_WWW' then DEFAULT_WWW = val.i
         when parm.i = 'DEFAULT_GOPHER' then DEFAULT_GOPHER = val.i
         when parm.i = 'MAIL_GW' then MAIL_GW = val.i
         when parm.i = 'POPSRVR' then POPSRVR = val.i
         when parm.i = 'REPLY_DOMAIN' then REPLY_DOMAIN = val.i
         when parm.i = 'REPLY_ID' then REPLY_ID = val.i
         when parm.i = 'POP_ID' then POP_ID = val.i
         when parm.i = 'POP_PWD' then POP_PWD = val.i
         when parm.i = 'MODEM_TYPE' then MODEM_TYPE = val.i
         when parm.i = 'COMPORT' then COMPORT = val.i
         when parm.i = 'BAUD' then BAUD = val.i
         when parm.i = 'DATABITS' then DATABITS = val.i
         when parm.i = 'PARITY' then PARITY = val.i
         when parm.i = 'DIAL_MODE' then DIAL_MODE = val.i
         when parm.i = 'PREFIX' then PREFIX = val.i
         when parm.i = 'PREFIX_ANS' then PREFIX_ANS = val.i
         when parm.i = 'INIT' then INIT = val.i
         when parm.i = 'INIT2' then INIT2 = val.i
         when parm.i = 'DISABLE' then DISABLE = val.i
         when parm.i = 'DISABLE_SEQ' then DISABLE_SEQ = val.i
         when parm.i = 'DIAL_PREFIX' then DIAL_PREFIX = val.i
         when parm.i = 'AUTOSTART' then AUTOSTART = val.i
         when parm.i = 'TOTAL_CONNECT' then TOTAL_CONNECT = val.i
         otherwise NOP
      end
   i = i + 1
end

o21 = '&\<=>|()! *+"''-/,#$%.0123456789:;?'
o22 = '@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^'
o23 = '_`abcdefghijklmnopqrstuvwxyz{}~'
e21 = '&\<=>|()u *+"''-/,MI$kUHgW[_A5%w~Fh'
e22 = 't?K^l0jJP{98xBadb1nZimRyY]4}`o'
e23 = 'E;67V@vS:C.sNGzcefQpqTr!2#XDLO3'

pop_pwd = translate(pop_pwd, e21||e22||e23, o21||o22||o23)
pwd = translate(pwd, e21||e22||e23, o21||o22||o23)
RETURN

/*
======================
find_equate_lines_in_datafile()

 backslash ('\') as the final character in the datafile
means the line is continued on the line following.  First
we reconstitute those lines that have continuations,
then we search through those lines for an '=' sign as
other than the first character.  We eliminate from
consideration any line with a '#' as the first character
as that signifies the line is a comment line.
======================
*/
find_equate_lines_in_datafile:
arg filename
n = 1
do while lines(filename) > 0
   data_line.n = linein(filename)
   select
      when right(data_line.n, 1) = '\' then	/* concatenating continuations */
         do until right(data_line.n, 1) \= '\'
            data_line_n_with_right_slash_stripped =,
                  strip(right(data_line.n,1), 'T', '\')
            next_data_line = linein(filename)
            data_line.n = data_line_n_with_right_slash_stripped || next_data_line
         end

/* only lines without a leading # and with an = qualify */
      when pos('=', data_line.n) > 0 & \abbrev(data_line.n, '#') then
         do
            line.n = data_line.n
            n = n + 1
         end
      otherwise NOP
   end
end
RETURN n

/*
====================
souper_options()

Chance to modify the souper options on a
one-time-only basis
====================
*/
souper_options:
call SysCls
getnews_xtra_options = '' /* the defaults */
getmail_xtra_options = ''
send_xtra_options = ''
option1 = ''
option2 = ''
option3 = ''
option4 = ''

say ''
say 'SOUPER OPTIONS SCREEN'
say 'You can select these as one-time-only options when souper runs.'
do until opts = 6
   say ''
   say 'Press:'
   say '  1 Set maximum news packetsize (default is 2048KB [2.048MB])'
   say '  2 Do not retrieve newsgroup articles containing more than set'
   say '    number of lines in the body (default is: no limit)'
   say '    You get to set the number of lines.'
   say '  3 Do catchup on news.  Mark all as read except last m unread'
   say '    news articles in each group.  You set m.'
   say '  4 For mail: read-only.  Do not empty POP3 mailbox or update NEWSRC file'
   say '  5 Default all four of the above.'
   say '  6 DONE.  (MUST press 6 to exit this screen)'
   do until pos(opts,'123456') \= 0
      say ''
      prompt = 'Select 1-6:'
      say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
      opts = SysGetKey('NOECHO')
      say ''
   end
   select
      when opts = 1 then call max_news_packet
      when opts = 2 then call max_news_lines
      when opts = 3 then 
         do
            say ''
            say ''
            say ''
            call catch
            do_catchup_on_news = 1
            say 'All but' Howmany 'articles (each group) max. will be marked read.'
         end
      when opts = 4 then call read_only_getmail_mode
      when opts = 5 then
         do
            option1 = ''
            option2 = ''
            option3 = ''
            option4 = ''
            choice = 7	/* go back with same value for choice as we came with */
            say ''
            say 'Accepting defaults for all three options'
            say ''
            say ''
            say 'Press any key to continue'
            call SysGetKey 'NOECHO'
         end
      otherwise NOP
   end
end

getnews_xtra_options = option1 option2
getnews_xtra_options = strip(getnews_xtra_options, 'B')
getnews_xtra_options = getnews_xtra_options option3
getnews_xtra_options = strip(getnews_xtra_options, 'B')

getmail_xtra_options = option4
getmail_xtra_options = strip(getmail_xtra_options, 'B')

if do_catchup_on_news then
  do
      say ''
      say 'Communicating with news server' default_news
      say 'to update our NEWSRC...'
      souper_exe '-c' Howmany	/* mark as read all but last Howmany you set */
      say 'Each group in NEWSRC file caught up for all but last' Howmany 'articles.'
      say 'Articles not marked as read can be retrieved next.'
   end 
say ''
say 'Final Souper command-line option settings now are:'
say 'GETNEWS souper.exe options:' souper_getnews_std_options getnews_xtra_options
say 'GETMAIL souper.exe options:' souper_getmail_std_options getmail_xtra_options
say 'SENDING souper.exe options:' souper_send_std_options send_xtra_options

RETURN

max_news_packet:
     do until datatype(option1, 'W')
         call SysCls
         say ''
         say 'Enter a number in kilobytes for maximum news packet size.'
         say '2048 is typical. 0 sets packet size to unlimited.'
         say ''
         prompt = 'Enter number of kilobytes now:'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
         pull option1
         if \DataType(option1, 'W') then say 'Must be whole number or zero.'
     end
     say ''
     say 'Maximum packet size for news is set to' option1 'kilobytes'
     option1 = '-k' option1
     say ''
     say ''
     say 'Press any key to continue'
     call SysGetKey 'NOECHO'
RETURN

max_news_lines:
      call SysCls
      do until datatype(option2, 'W')
         say ''
         say 'Do not retrieve articles with more than this many lines'
         say 'in the body of the article.  Enter 0 for unlimited (the'
         say 'usual default for souper).'
         say ''
         prompt = 'Enter maximum lines:'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
         pull option2
         if \DataType(option2, 'W') then say 'Must be whole number or zero.'
     end
     say ''
     say 'Reject newsgroup articles with more than' option2 'lines in body.'
     if option2 = 0 then option2 = ''
        else option2 = '-l' option2
     say ''
     say ''
     say 'Press any key to continue'
     call SysGetKey 'NOECHO'
RETURN

read_only_getmail_mode:
      call SysCls
      do until pos(option4, 'YN') \=0
         say ''
         say 'For mail: You can set to read-only.  Retrieves mail but',
         say 'does not empty POP3 mailbox.'
         say ''
         say 'Set to Read-Only Mode?'
         prompt = 'Y sets Read-Only mode, N (normal default) doesn''t:'
         say prompt
            parse value SysCurPos() with row col
            row  = row - 1
            col = length(prompt) + 2
            call SysCurPos row, col
         parse upper pull option4
     end
     if option4 ='Y' then
         do
            say 'Read-Only mode set'
            option4 = '-r'
         end
     else
         do
            say 'Regular (not Read-Only) mode set'
            option4 = ''
         end 
     say ''
     say ''
     say 'Press any key to continue'
     call SysGetKey 'NOECHO'
RETURN


/*
==============================================
are_there_interfaces_up()

Checks for active router interfaces.  We look specifically
for an interface with the same characters in interf_prefix
(or at least, for its forst n characters where n=length of
interface_prefix).  Returns ifprefix_interf_up=1 if found.

Then, whatever the prefix, checks whether any interface(s)
are up whether its prefix is interf_prefix, sl, ppp, slip,
lan, l, or whatever.  Returns some_interf_up=1 if found.
==============================================
*/

are_there_interfaces_up:
if_prefix = translate(interf_prefix)

some_interf_up = 0 
ifprefix_interf_up = 0
some_interf_up = 0

netstat_line = ''
'netstat -r | rxqueue /LIFO'	/* send output to the queue */
do queued()
   parse pull netstat_line /* interface may be last word */
   dest = word(netstat_line, 1)
   dest = translate(dest)
   dest = strip(dest, 'B')
   if dest = 'DESTINATION' then iterate /* line is the heading line, discard */
   interface = word(netstat_line, words(netstat_line))
   interface = translate(interface)
   if left(interface, length(interf_prefix)) = if_prefix then
      ifprefix_interf_up = 1
   if interface \= '' then some_interf_up = 1      /* anything */
end
RETURN

/*
=====================
make_if_list()

Creates a string of all router interfaces detected,
with spaces as separators.  The interfaces are
translated to upper case before being recorded in the string.


possible examples of what an if _list will look like:
if_list = 'PPP3 PPP1 SL0'
if_list = ''	(none detected)
if_list = 'SL0'

if_list  includes all interface types; they can be mixed

make_if_list() returns the list (the string if_list)
=====================
*/ 
make_if_list:

if_list = ''

'netstat -r | rxqueue /LIFO'	/* send output to the queue */
do queued()
   parse pull netstat_line /* interface may be last word */
   interface = word(netstat_line, words(netstat_line))
   interface = translate(interface)
   dest = word(netstat_line, 1)
   dest = translate(dest)
   dest = strip(dest, 'B')
   if dest = 'DESTINATION' then iterate /* line is the heading line, discard */
/* if interface is not in the list, add it */
   if pos(interface, if_list) = 0 then if_list = if_list interface
end
 
RETURN if_list

/*
==============================================
wait_for_interface()

Waits for a new interface to become active, which is
deduced from comparison of interface(s) returned by NETSTAT.EXE -r
to the string prepared before starting the dialer of all
(any) pre-existing interfaces (if_list).

Takes two arguments which are
   total_delay		the wait until timeout, seconds
   quiet		quiet mode if 1, verbose mode if 0

Returns the variable found_interface which =1 if 
a new interface is detected or =0 if we time out
before finding a new one.
==============================================
*/

wait_for_interface:
parse arg total_delay, quiet

recheck_delay = 1	/* recheck interval in seconds */
if_prefix = translate(interf_prefix)
ifp_length = length(interf_prefix)

say 'Waiting for' service '(' || interf_prefix || ') - maximum wait =' total_delay 'second(s)'

found_interface = 0		/* clear to not found */
do index = 1 to total_delay by recheck_delay	  /* Periodically check avail. routes */
   call SysSleep recheck_delay	/* Minor delay, then check for routes */
   'netstat -r | rxqueue /LIFO'	/* send output to the queue */

   do queued()
      parse pull netstat_line	/* May have interface as last word in line */
      dest = word(netstat_line, 1)
      dest = translate(dest)
      dest = strip(dest, 'B')
      if dest = 'DESTINATION' then iterate /* line is the heading line, discard */
      interface = word(netstat_line, words(netstat_line))
      interface = translate(interface)
      if left(interface, ifp_length) = if_prefix then 	/* Check for interface */
         do
            if pos(interface, if_list) = 0 then
               do
                  found_interface = 1 /* (new) , we did not time out */ 
                  if \quiet then say 'interface' interface 'detected'
                  leave index
               end
       end	/* of If Left(interface, ifp_length) = if_prefix */
    end			/* of Do Queued() */
end			/* of Do Index */ 
do queued(); pull; end	/* Clear out any lines left in rxqueue */ 
RETURN found_interface


/*
==============================================
HANDLING OF ERROR TRAPS

ReXX Errors (failure, halt, syntax, novalue, error,
novalue) that occur with SIGNAL ON XXXXX (XXXXX = failure,
halt, etc.) are diverted (we jump) to one of these
where the error and the offending line are identified.
==============================================
*/

   FAILURE:
   say 'Rexx FAILURE condition' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   do_not_kill = 0	/* don't let us stay on-line */
   signal goodbye
   RETURN


   HALT:
   say 'Rexx HALT condition' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   do_not_kill = 0	/* don't let us stay on-line */
   signal goodbye
   RETURN


   SYNTAX:
   say 'Rexx SYNTAX error' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   do_not_kill = 0	/* don't let us stay on-line */
   signal goodbye
   RETURN


   NOTREADY:
   say 'Rexx NOTREADY condition' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   do_not_kill = 0	/* don't let us stay on-line */
   signal goodbye
   RETURN


   ERROR:
   say 'Rexx ERROR condition' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   do_not_kill = 0	/* don't let us stay on-line */
   signal goodbye
   RETURN


   NOVALUE:
   say 'Rexx NOVALUE condition' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   do_not_kill = 0	/* don't let us stay on-line */
   signal goodbye
   RETURN

/*
=======================
goodbye()
quit()
depart()

Exit routines.  Most exits are jumps to
goodbye()
=======================
*/

goodbye:
call kill_dialers_slip_ppp_slattach	/* Now fall into DEPART() */

Depart:
if timeout then signal Quit
say ''
call connect_stats		/* tell us elapsed time */
x= EndLocal()

	/* Now fall into QUIT() */
Quit:				/* Fall into Quit */
say ''
say 'Done. Press any key to exit...'		
answer = SysGetKey('NOECHO')

EXIT

RETURN
