/******************************************************************/
/* WPSLOCK.CMD Workplace Security Lock/Unlock Utility             */
/*                                                                */
/*  Command format:  WPSLOCK yes|no  password                     */ 
/*                                                                */ 
/*  Where:    yes|no = the word YES or NO                         */
/*            password = the current master password              */    
/*                                                                */
/*  Example:  WPSLOCK YES MASTER                                  */
/*                                                                */ 
/*                                                                */
/*  Add any of the Object ID's listed below to the variable       */
/*  "Object_list" which is the list of Objects to lock/unlock.    */ 
/*                                                                */ 
Object_list = "<WP_DESKTOP> <WP_OS2SYS>"                       /* */
/*                                                                */ 
/*      ObjectID         Description                              */                    
/*      --------------------------------------------              */   
/*      <WP_DESKTOP>     Desktop folder                           */
/*      <WP_TEMPS>       Templates folder                         */ 
/*      <WP_VIEWER>      Minimized Window viewer                  */ 
/*      <WP_INFO>        Information folder                       */ 
/*      <WP_NETWORK>     Network folder                           */
/*      <WP_OS2SYS>      OS/2 System folder                       */ 
/*      <WP_DRIVES>      Drives folder                            */
/*      <WP_START>       Startup folder                           */
/*      <WP_CONFIG>      System Setup folder                      */
/*      <WP_PROMPTS>     Command prompts folder                   */
/*      <WP_GAMES>       Games folder                             */
/*      <WP_TOOLS>       Productivity folder                      */
/*      <WP_DOSGROUP>    DOS Programs folder                      */
/*      <WP_WINGROUP>    Windows programs folder                  */
/*      <WP_OS2GROUP>    OS/2 Programs folder                     */
/*      <WP_WINOS2GROUP> Win-OS/2 Groups folder                   */
/*      <WP_NOWHERE>     Invisible Nowhere folder                 */ 
/*      <OS_2_Window>    OS/2 Command Window                      */
/*                                                                */
/*                                                                */
/* Workplace Security Copyright (C) 1995 by Maple Valley Software */
/******************************************************************/
  
'@Echo Off'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initialize */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX


/* parse the command tokens  YES/NO and the master password */

parse upper arg yesno master . 

do words(Object_list)

  parse var Object_list ObjectID Object_list 

  Settings = "LOCK="yesno";MASTER="master";"
  Result = SysSetObjectData(ObjectID, Settings )
  if Result = 0 then signal Object_Settings_error
  end
 
Signal DONE 


Object_Settings_error:

Say "Error changing settings for ObjectID="ObjectID
Exit

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
