%{
/*  Title:   English to Texan translator
 *  Author:  Adam Hudd (adam@dadhb1.ti.com)
 *  Date:    5 March 1991
 *  Version: 1.0
 *
 *  Input:   stdin
 *  Output:  stdout
 *  compile: flex -iL drawl.l ; cc -O lex.yy.c -o drawl
 */

#include <stdio.h>
#include <ctype.h>

void changeCase();
%}
%%
(^|" ")"American"			changeCase(" Amerkin");
(^|" ")"California"			changeCase(" Caleyfornyuh");
(^|" ")"Dallas"				changeCase(" Big D.");
(^|" ")"Fort Worth"			changeCase(" Fowert Wurth");
(^|" ")"Houston"			changeCase(" Useton");
(^|" ")"I don't know"			changeCase(" I-O-no");
(^|" ")"I will"|" I'll"			changeCase(" Ahl");
(^|" ")"I would"			changeCase(" Ahd");
(^|" ")"I "				changeCase(" Ah ");
(^|" ")"I'm "|" I am "			changeCase(" Ahm ");
(^|" ")"I've "|" I have "		changeCase(" Ahv ");
(^|" ")"Mexico"				changeCase(" Messyco");
(^|" ")"San Antonio"			changeCase(" Santone");
(^|" ")"TV"|" television"|" telly"	changeCase(" tayvay");
(^|" ")"Texan"				changeCase(" Texun");
(^|" ")"Texas"				changeCase(" Teksus");
(^|" ")"a while "			changeCase(" uhwahl ");
(^|" ")"a "				changeCase(" uh ");
(^|" ")"about"				changeCase(" bout");
(^|" ")"adult"				changeCase(" a-dult");
(^|" ")"afraid"				changeCase(" frayed");
(^|" ")"and "				changeCase(" an ");
(^|" ")"anniversary"			changeCase(" anavarsry");
(^|" ")"any "				changeCase(" no ");
(^|" ")"anywhere"			changeCase(" anywhare");
(^|" ")"appreciate"			changeCase(" preshate");
(^|" ")"april"				changeCase(" abrul");
(^|" ")"are going to"			changeCase(" sargunna");
(^|" ")"are known"			changeCase(" iz node");
(^|" ")"are "				changeCase(" is ");
(^|" ")"aren't you"			changeCase(" arncha");
(^|" ")"at them"			changeCase(" attum");
(^|" ")"august"				changeCase(" awg-ghust");
(^|" ")"away"				changeCase(" awf");
(^|" ")"awkward"			changeCase(" aukerd");
(^|" ")"bad"				changeCase(" bayud");
(^|" ")"ball"				changeCase(" bawl");
(^|" ")"baptists"			changeCase(" babtusses");
(^|" ")"barbed"				changeCase(" bob");
(^|" ")"be "				changeCase(" bay ");
(^|" ")"bear"				changeCase(" bayur");
(^|" ")"beautiful"			changeCase(" butiful");
(^|" ")"because"			changeCase(" cuz");
(^|" ")"believe"			changeCase(" bleeve");
(^|" ")"bitty"				changeCase(" biddy");
(^|" ")"black"				changeCase(" blaak");
(^|" ")"blue"				changeCase(" bulloo");
(^|" ")"born"				changeCase(" bornd");
(^|" ")"brake"				changeCase(" brayke");
(^|" ")"break"				changeCase(" brayke");
(^|" ")"brick"				changeCase(" breck");
(^|" ")"brighter"			changeCase(" brotter");
(^|" ")"bringing"			changeCase(" brangin");
(^|" ")"brown"				changeCase(" braoyone");
(^|" ")"building"			changeCase(" bildun");
(^|" ")"bulb"				changeCase(" bub");
(^|" ")"call you "			changeCase(" cawya ");
(^|" ")"called you "			changeCase(" cawdja ");
(^|" ")"camera"				changeCase(" Instuhmatik");
(^|" ")"can't"				changeCase(" kaynt");
(^|" ")"can't"|" can not"|" cannot"	changeCase(" kaynt");
(^|" ")"capital"			changeCase(" captul");
(^|" ")"car "				changeCase(" cawer ");
(^|" ")"catch"				changeCase(" ketch");
(^|" ")"chair"				changeCase(" chayer");
(^|" ")"cheer"				changeCase(" chair");
(^|" ")"chicken"			changeCase(" chikun");
(^|" ")"child"				changeCase(" kid");
(^|" ")"children"			changeCase(" kids");
(^|" ")"clean"				changeCase(" klane");
(^|" ")"climate"			changeCase(" kliment");
(^|" ")"cold"				changeCase(" code");
(^|" ")"darker"				changeCase(" dawerker");
(^|" ")"deaf"				changeCase(" dayuf");
(^|" ")"death"				changeCase(" dayuth");
(^|" ")"december"			changeCase(" deceyumbur");
(^|" ")"definite"			changeCase(" defnut");
(^|" ")"did not"|" didn't"		changeCase(" didunt");
(^|" ")"did you"			changeCase(" dja");
(^|" ")"didn't it"			changeCase(" diduhnit");
(^|" ")"different"			changeCase(" difernt");
(^|" ")"difficult"			changeCase(" difahkult");
(^|" ")"divide"				changeCase(" duhvide");
(^|" ")"does"				changeCase(" duz");
(^|" ")"doesn't"			changeCase(" don't");
(^|" ")"dog "				changeCase(" dawg ");
(^|" ")"I don't care"                   changeCase(" don't make no nevur mind to may ");
(^|" ")"door"				changeCase(" dower");
(^|" ")"dreaming"			changeCase(" draimun");
(^|" ")"drink"				changeCase(" drank");
(^|" ")"drinking"			changeCase(" drankin");
(^|" ")"drive"				changeCase(" drahv");
(^|" ")"eight"				changeCase(" ate");
(^|" ")"eighteen"			changeCase(" a-tane");
(^|" ")"eighth"				changeCase(" athd");
(^|" ")"eighty"				changeCase(" ady");
(^|" ")"eleven"				changeCase(" lebum");
(^|" ")"entire"				changeCase(" entahr");
(^|" ")"especially"			changeCase(" speshuly");
(^|" ")"even"				changeCase(" evun");
(^|" ")"evening"			changeCase(" eevnun");
(^|" ")"eventually"			changeCase(" eventchly");
(^|" ")"ever"				changeCase(" evur");
(^|" ")"every once in a while"		changeCase(" evurwonsinawhahl");
(^|" ")"every"				changeCase(" evur");
(^|" ")"exactly" 			changeCase(" zakly");
(^|" ")"executive"			changeCase(" zekatuv");
(^|" ")"eye "				changeCase(" ah ");
(^|" ")"father"				changeCase(" papa");
(^|" ")"february"			changeCase(" febberyawary");
(^|" ")"fell "				changeCase(" fayul ");
(^|" ")"fifteen"			changeCase(" fiftane");
(^|" ")"fifth"				changeCase(" fifd");
(^|" ")"fifty"				changeCase(" fifdy");
(^|" ")"fight"				changeCase(" fite");
(^|" ")"figure"				changeCase(" figger");
(^|" ")"filling"			changeCase(" fillin");
(^|" ")"fine"				changeCase(" fahn");
(^|" ")"fire"				changeCase(" far");
(^|" ")"first"				changeCase(" fursd");
(^|" ")"five"				changeCase(" fav");
(^|" ")"fixing"				changeCase(" fixin");
(^|" ")"flower"				changeCase(" flare");
(^|" ")"follow"				changeCase(" faller");
(^|" ")"for "				changeCase(" fahwar ");
(^|" ")"forget"				changeCase(" fergit");
(^|" ")"fork"				changeCase(" fowerk");
(^|" ")"forty"				changeCase(" fardy");
(^|" ")"four"				changeCase(" fower");
(^|" ")"fourteen"			changeCase(" fortane");
(^|" ")"fourth"				changeCase(" fowerth");
(^|" ")"freeze"				changeCase(" fraze");
(^|" ")"friday"				changeCase(" frydy");
(^|" ")"from"				changeCase(" frum");
(^|" ")"front"				changeCase(" frunt");
(^|" ")"gas"				changeCase(" gayus");
(^|" ")"geography"			changeCase(" joggerfee");
(^|" ")"get a hold of you"		changeCase(" gittaholdayew");
(^|" ")"get"				changeCase(" git");
(^|" ")"going to"			changeCase(" gunna");
(^|" ")"going to"			changeCase(" mona");
(^|" ")"gold"				changeCase(" gode");
(^|" ")"got to "			changeCase(" gotta ");
(^|" ")"green"				changeCase(" grane");
(^|" ")"grey"|" gray"			changeCase(" graey");
(^|" ")"guests"				changeCase(" guesss");
(^|" ")"guitar"				changeCase(" gitahwer");
(^|" ")"gulf"				changeCase(" guf");
(^|" ")"hard"				changeCase(" hayud");
(^|" ")"have a "			changeCase(" havuh ");
(^|" ")"have not"|" haven't"		changeCase(" habumt");
(^|" ")"have "				changeCase(" hav ");
(^|" ")"he "				changeCase(" hay ");
(^|" ")"headed"				changeCase(" hardud");
(^|" ")"here"				changeCase(" hare");
(^|" ")"high"				changeCase(" ha");
(^|" ")"hour"				changeCase(" air");
(^|" ")"how are you"			changeCase(" hyeru");
(^|" ")"how do you do "			changeCase(" howdee ");
(^|" ")"huh!"				changeCase(" hawh!");
(^|" ")"huh?"				changeCase(" hawh?");
(^|" ")"hundred"			changeCase(" hunnerd");
(^|" ")"if I "				changeCase(" fah ");
(^|" ")"if it "				changeCase(" hifit ");
(^|" ")"if you"				changeCase(" few");
(^|" ")"if "				changeCase(" hif ");
"ing "					changeCase("in' ");
(^|" ")"ignorance"			changeCase(" ignernt");
(^|" ")"indian"				changeCase(" hinyun");
(^|" ")"inside"				changeCase(" n-sod");
(^|" ")"instead of"			changeCase(" instudda");
(^|" ")"institute"			changeCase(" instatoot");
(^|" ")"intersection"			changeCase(" innersekshun");
(^|" ")"is a "				changeCase(" izza ");
(^|" ")"is it "				changeCase(" izit ");
(^|" ")"is that "			changeCase(" izzat ");
(^|" ")"is that right "			changeCase(" zatrot ");
(^|" ")"is "				changeCase(" iz ");
(^|" ")"isn't it "			changeCase(" hiduhnit ");
(^|" ")"it appears"			changeCase(" pears");
(^|" ")"it would"			changeCase(" hid");
(^|" ")"it "				changeCase(" hit ");
(^|" ")"it'd "				changeCase(" hid ");
(^|" ")"it's"|" it is"			changeCase(" hit's");
(^|" ")"jail"				changeCase(" jayul");
(^|" ")"january"			changeCase(" janyawary");
(^|" ")"jeans"				changeCase(" janes");
(^|" ")"jet"				changeCase(" jeyut");
(^|" ")"jewelry"			changeCase(" julry");
(^|" ")"july"				changeCase(" djoolie");
(^|" ")"june"				changeCase(" djoon");
(^|" ")"just"				changeCase(" gist");
(^|" ")"kind of"			changeCase(" kinduh");
(^|" ")"king"				changeCase(" kang");
(^|" ")"library"			changeCase(" liberry");
(^|" ")"lie"				changeCase(" lah");
(^|" ")"life"				changeCase(" lahf");
(^|" ")"light"				changeCase(" lot");
(^|" ")"lighter"			changeCase(" lahter");
(^|" ")"like"				changeCase(" lahk");
(^|" ")"little"				changeCase(" liddel");
(^|" ")"log"				changeCase(" lawg");
(^|" ")"lot of"				changeCase(" lottuh");
(^|" ")"lots of"			changeCase(" lotsa");
(^|" ")"love"				changeCase(" luv");
(^|" ")"mall"				changeCase(" mawl");
(^|" ")"march"				changeCase(" martch");
(^|" ")"material"			changeCase(" mahtearyul");
(^|" ")"may"				changeCase(" maey");
(^|" ")"me "				changeCase(" may ");
(^|" ")"mile"				changeCase(" mahl");
(^|" ")"minute"				changeCase(" minent");
(^|" ")"monday"				changeCase(" mundy");
(^|" ")"mosquito"			changeCase(" skeeter");
(^|" ")"moss"				changeCase(" mawce");
(^|" ")"mother"				changeCase(" ma");
(^|" ")"mroone"				changeCase(" maroon");
(^|" ")"my "				changeCase(" mah ");
(^|" ")"myself"				changeCase(" mahsef");
(^|" ")"never"				changeCase(" nevur");
(^|" ")"nine"				changeCase(" nahn");
(^|" ")"nineteen"			changeCase(" nontane");
(^|" ")"nineth"				changeCase(" nonth");
(^|" ")"ninety"				changeCase(" nondy");
(^|" ")"no "				changeCase(" naw ");
(^|" ")"nothing"			changeCase(" nuthun");
(^|" ")"november"			changeCase(" noveyumbur");
(^|" ")"ocean"				changeCase(" oshun");
(^|" ")"october"			changeCase(" oktobur");
(^|" ")"of "				changeCase(" uh ");
(^|" ")"off"				changeCase(" awf");
(^|" ")"oil"				changeCase(" all");
(^|" ")"old "				changeCase(" ode ");
(^|" ")"one of "			changeCase(" wunna ");
(^|" ")"one "				changeCase(" wun ");
(^|" ")"only"				changeCase(" monly");
(^|" ")"opposite"			changeCase(" opsit");
(^|" ")"orange"				changeCase(" arnjuh");
(^|" ")"over there"			changeCase(" ovare");
(^|" ")"over"				changeCase(" ovur");
(^|" ")"parking"			changeCase(" parkin");
(^|" ")"people"				changeCase(" paypul");
(^|" ")"picture"			changeCase(" pitchur");
(^|" ")"pillow"				changeCase(" pillar");
(^|" ")"pine"				changeCase(" pahn");
(^|" ")"pink"				changeCase(" pank");
(^|" ")"please"				changeCase(" playze");
(^|" ")"pretty"				changeCase(" purdy");
(^|" ")"probably"			changeCase(" probly");
(^|" ")"purple"				changeCase(" burpel");
(^|" ")"queen"				changeCase(" kwane");
(^|" ")"quit"				changeCase(" kewyut");
(^|" ")"rather"				changeCase(" ruthur");
(^|" ")"ready"				changeCase(" reddy");
(^|" ")"real"				changeCase(" reeyul");
(^|" ")"really"				changeCase(" rilly");
(^|" ")"red"				changeCase(" rayud");
(^|" ")"right"				changeCase(" rot");
(^|" ")"ring"				changeCase(" rang");
(^|" ")"said"				changeCase(" sayud");
(^|" ")"sale"				changeCase(" sayul");
(^|" ")"sale"|" sail"|" sell"		changeCase(" sayul");
(^|" ")"saturday"			changeCase(" sadderdy");
(^|" ")"school"				changeCase(" skoo");
(^|" ")"screen"				changeCase(" skrane");
(^|" ")"second"				changeCase(" sekunt");
(^|" ")"see"				changeCase(" say");
(^|" ")"september"			changeCase(" ceptimbur");
(^|" ")"seven"				changeCase(" sebum");
(^|" ")"seventeen"			changeCase(" sebumtane");
(^|" ")"seventh"			changeCase(" sebumthd");
(^|" ")"seventy"			changeCase(" sebumdy");
(^|" ")"she"				changeCase(" shay");
(^|" ")"shirt"				changeCase(" churt");
(^|" ")"sign"				changeCase(" sahn");
(^|" ")"silver"				changeCase(" seeyulvur");
(^|" ")"sit"				changeCase(" set");
(^|" ")"sixteen"			changeCase(" sickstane");
(^|" ")"sixth"				changeCase(" sicksed");
(^|" ")"sixty"				changeCase(" sicksdy");
(^|" ")"siz"				changeCase(" sicks");
(^|" ")"smell"				changeCase(" smayul");
(^|" ")"smile"				changeCase(" smahl");
(^|" ")"softer"				changeCase(" sowftur");
(^|" ")"some of those"			changeCase(" sumoze");
(^|" ")"some"				changeCase(" sum");
(^|" ")"something"			changeCase(" sumpn");
(^|" ")"sometime"			changeCase(" sumtom");
(^|" ")"south"				changeCase(" saowth");
(^|" ")"speak"				changeCase(" spake");
(^|" ")"spring"				changeCase(" sprang");
(^|" ")"sprinkle"			changeCase(" sprankul");
(^|" ")"stadium"			changeCase(" stadyum");
(^|" ")"station"			changeCase(" stayshun");
(^|" ")"string"				changeCase(" strang");
(^|" ")"sunday"				changeCase(" sundy");
(^|" ")"sure"				changeCase(" shore");
(^|" ")"tale"|" tail"			changeCase(" tayul");
(^|" ")"talk"				changeCase(" tawk");
(^|" ")"talking"			changeCase(" tawkin");
(^|" ")"tall"				changeCase(" tahl");
(^|" ")"tan"				changeCase(" tayun");
(^|" ")"ten"				changeCase(" teyun");
(^|" ")"tenth"				changeCase(" teyunth");
(^|" ")"terible"			changeCase(" tarbul");
(^|" ")"terrible"			changeCase(" tarbul");
(^|" ")"that is"|" that's"		changeCase(" thets");
(^|" ")"that"				changeCase(" thet");
(^|" ")"the only"			changeCase(" thonly");
(^|" ")"the other"			changeCase(" thuther");
(^|" ")"the"				changeCase(" thuh");
(^|" ")"their"				changeCase(" thur");
(^|" ")"there"				changeCase(" thare");
(^|" ")"there"				changeCase(" thayure");
(^|" ")"they"				changeCase(" thay");
(^|" ")"thing"				changeCase(" thang");
(^|" ")"think"				changeCase(" thank");
(^|" ")"third"				changeCase(" thurd");
(^|" ")"thirteen"			changeCase(" thurtane");
(^|" ")"thirty"				changeCase(" thurdy");
(^|" ")"this"				changeCase(" thus");
(^|" ")"those"				changeCase(" them");
(^|" ")"thousand"			changeCase(" thousun");
(^|" ")"three"				changeCase(" thray");
(^|" ")"through"			changeCase(" thoo");
(^|" ")"throw"				changeCase(" thow");
(^|" ")"throw"				changeCase(" throw");
(^|" ")"thrown"				changeCase(" thowed");
(^|" ")"thursday"			changeCase(" thursdy");
(^|" ")"tie"				changeCase(" tah");
(^|" ")"tied"				changeCase(" tahd");
(^|" ")"tight"				changeCase(" tot");
(^|" ")"time"				changeCase(" tom");
(^|" ")"to "				changeCase(" tuh ");
(^|" ")"today"				changeCase(" tuhday");
(^|" ")"toilet"				changeCase(" outhouse");
(^|" ")"told"				changeCase(" tode");
(^|" ")"tommorrow"			changeCase(" tuhmorrow");
(^|" ")"tree"				changeCase(" tray");
(^|" ")"truck"				changeCase(" truk");
(^|" ")"tuesday"			changeCase(" chewsdy");
(^|" ")"twelve"				changeCase(" twayulv");
(^|" ")"twenty"				changeCase(" twindy");
(^|" ")"two "				changeCase(" tew ");
(^|" ")"understand"			changeCase(" understaynd");
(^|" ")"used to"			changeCase(" ustuh");
(^|" ")"vehicle"			changeCase(" vee-hicul");
(^|" ")"victory"			changeCase(" viktray");
(^|" ")"violation"			changeCase(" vahlayshun");
(^|" ")"virtual"			changeCase(" vurchul");
(^|" ")"want to "			changeCase(" wonna ");
(^|" ")"was that"			changeCase(" wuzzat");
(^|" ")"was"				changeCase(" wuz");
(^|" ")"wash"				changeCase(" wartch");
(^|" ")"water"				changeCase(" warder");
(^|" ")"we "				changeCase(" way ");
(^|" ")"wedding"			changeCase(" wedden");
(^|" ")"wednesday"			changeCase(" winsdy");
(^|" ")"well"				changeCase(" wayul");
(^|" ")"were "				changeCase(" wuz ");
(^|" ")"west "				changeCase(" wayust ");
(^|" ")"what did you"			changeCase(" whudja");
(^|" ")"what did"			changeCase(" whuddle");
(^|" ")"what do you"			changeCase(" wadja");
(^|" ")"what is the matter"		changeCase(" smatter");
(^|" ")"what is"|" what's"		changeCase(" whut");
(^|" ")"what"				changeCase(" whut");
(^|" ")"wheel"				changeCase(" whale");
(^|" ")"when"				changeCase(" wheyun");
(^|" ")"where did you"			changeCase(" whardja");
(^|" ")"where"				changeCase(" whar");
(^|" ")"where"				changeCase(" whayer");
(^|" ")"white"				changeCase(" wot");
(^|" ")"why don't you"			changeCase(" y-oncha");
(^|" ")"why"				changeCase(" wha");
(^|" ")"wife"				changeCase(" waf");
(^|" ")"window"				changeCase(" wender");
(^|" ")"winter"				changeCase(" winner");
(^|" ")"wire"				changeCase(" war");
(^|" ")"with you"			changeCase(" witchew");
(^|" ")"woman"				changeCase(" whoamun");
(^|" ")"women"				changeCase(" wimmen");
(^|" ")"world"				changeCase(" warld");
(^|" ")"worse than"			changeCase(" worsun");
(^|" ")"yard"				changeCase(" chard");
(^|" ")"yellow"				changeCase(" yuller");
(^|" ")"yes"				changeCase(" u-betcha");
(^|" ")"yes"				changeCase(" yayus");
(^|" ")"you "				changeCase(" yawl ");
(^|" ")"your are"|" you're"		changeCase(" yore");
(^|" ")"your"				changeCase(" chur");
..|'\n'					ECHO;
%%
main()
{
  yylex();
}

void changeCase(word)
char *word;
{
extern char *yytext;

/* change o/p to upper/lower based on original text */
  if (isupper(*(yytext+1)) && islower(*(word+1)))
    *(word+1) = toupper(*(word+1));

  printf(word);
}
