/*************************************************************** SNAPSHOT.CPP
 *                                                                          *
 *           Standalone Text-mode Snapshot of System Resources              *
 *                                                                          *
 ****************************************************************************/

#define INCL_BASE
#define INCL_PM
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Config.h"
#include "DQPS.h"
#include "MemSize.h"
#include "Module.h"
#include "ReString.h"
#include "Support.h"


/****************************************************************************
 *                                                                          *
 *                       Definitions & Declarations                         *
 *                                                                          *
 ****************************************************************************/

static void FormatValue ( long Value, char Text[], COUNTRYINFO &CountryInfo, int ShowK=SHOWK_ABOVE512, int Scale=1 ) ;
static PSZ ScanSystemConfig ( HAB Anchor, PSZ Keyword ) ;
static char *CopyString ( char *Buffer, char *Original ) ;
static int CheckDrive ( USHORT Drive, PBYTE FileSystem, PBYTE DiskLabel ) ;


/****************************************************************************
 *                                                                          *
 *                              Mainline                                    *
 *                                                                          *
 ****************************************************************************/

extern int main ( int argc, char *argv[] ) {

   // Initialization

   Module Library ( PSZ(PROGRAM_NAME) ) ;

   COUNTRYCODE CountryCode ;
   CountryCode.country = 0 ;
   CountryCode.codepage = 0 ;

   COUNTRYINFO CountryInfo ;
   ULONG Count ;
   ULONG Status = DosGetCtryInfo ( sizeof(CountryInfo), &CountryCode, &CountryInfo, &Count ) ;
   if ( Status ) {
      CountryInfo.fsDateFmt = DATEFMT_MM_DD_YY ;
      CountryInfo.fsTimeFmt = 0 ;
      CountryInfo.szDateSeparator[0] = '/' ;
      CountryInfo.szDateSeparator[1] = 0 ;
      CountryInfo.szTimeSeparator[0] = ':' ;
      CountryInfo.szTimeSeparator[1] = 0 ;
      CountryInfo.szThousandsSeparator[0] = ',' ;
      CountryInfo.szThousandsSeparator[1] = 0 ;
   } /* endif */

   char Text [80] ;
   ULONG Size = 2 ;
   if ( PrfQueryProfileData ( HINI_USERPROFILE, PSZ("PM_National"), PSZ("iDate"), Text, &Size ) ) {
      CountryInfo.fsDateFmt = atoi ( Text ) ;
   } /* endif */

   Size = 2 ;
   if ( PrfQueryProfileData ( HINI_USERPROFILE, PSZ("PM_National"), PSZ("iTime"), Text, &Size ) ) {
      CountryInfo.fsTimeFmt = UCHAR ( atoi ( Text ) ) ;
   } /* endif */

   Size = 2 ;
   PrfQueryProfileData ( HINI_USERPROFILE, PSZ("PM_National"), PSZ("sDate"), CountryInfo.szDateSeparator, &Size ) ;

   Size = 2 ;
   PrfQueryProfileData ( HINI_USERPROFILE, PSZ("PM_National"), PSZ("sTime"), CountryInfo.szTimeSeparator, &Size ) ;

   Size = 3 ;
   char szAm [3] ;
   strcpy ( szAm, "am" ) ;
   PrfQueryProfileData ( HINI_USERPROFILE, PSZ("PM_National"), PSZ("s1159"), szAm, &Size ) ;

   Size = 3 ;
   char szPm [3] ;
   strcpy ( szPm, "pm" ) ;
   PrfQueryProfileData ( HINI_USERPROFILE, PSZ("PM_National"), PSZ("s2359"), szPm, &Size ) ;

   Size = 2 ;
   PrfQueryProfileData ( HINI_USERPROFILE, PSZ("PM_National"), PSZ("sThousand"), CountryInfo.szThousandsSeparator, &Size ) ;

   PSZ Swappath = ScanSystemConfig ( 0, PSZ("SWAPPATH") ) ;
   if ( Swappath == NULL ) 
      Swappath = PSZ("C:\\OS2\\SYSTEM 0") ;
   char SwapPath [CCHMAXPATH] ;
   char *p = CopyString ( SwapPath, PCHAR(Swappath) ) ;
   ULONG MinFree ;
   sscanf ( p, " %li", &MinFree ) ;
   printf ( "SwapPath '%s', MinFree %iK.\n", SwapPath, MinFree ) ;

   PSZ SpoolPath = 0 ;
   if ( PrfQueryProfileSize ( HINI_PROFILE, PSZ("PM_SPOOLER"), PSZ("DIR"), &Size ) ) {
      SpoolPath = PSZ ( malloc ( (int)Size ) ) ;
      if ( SpoolPath ) {
         if ( PrfQueryProfileData ( HINI_PROFILE, PSZ("PM_SPOOLER"), PSZ("DIR"), SpoolPath, &Size ) ) {
            PBYTE p = PBYTE( strchr ( PCHAR(SpoolPath), ';' ) ) ;
            if ( p ) {
               *p = 0 ;
            } /* endif */
         } else {
            free ( SpoolPath ) ;
            SpoolPath = 0 ;
         } /* endif */
      } /* endif */
   } /* endif */
   if ( SpoolPath == 0 )
      SpoolPath = PSZ ( "C:\\SPOOL" ) ;


   // Date and Time

   DATETIME DateTime ;
   DosGetDateTime ( &DateTime ) ;

   ResourceString DaysOfWeek ( Library.QueryHandle(), IDS_DAYSOFWEEK ) ;

   switch ( CountryInfo.fsDateFmt ) {
      case DATEFMT_DD_MM_YY:
         sprintf ( Text, "%0.*s, %02lu%s%02lu ",
            strlen(PCHAR(DaysOfWeek))/7, PSZ(DaysOfWeek) + DateTime.weekday*(strlen(PCHAR(DaysOfWeek))/7),
            DateTime.day, CountryInfo.szDateSeparator, DateTime.month ) ;
         break ;
      case DATEFMT_YY_MM_DD:
         sprintf ( Text, "%02lu%s%02lu %0.*s ",
            DateTime.month, CountryInfo.szDateSeparator, DateTime.day,
            strlen(PCHAR(DaysOfWeek))/7, PSZ(DaysOfWeek) + DateTime.weekday*(strlen(PCHAR(DaysOfWeek))/7) ) ;
         break ;
      case DATEFMT_MM_DD_YY:
      default:
         sprintf ( Text, "%0.*s, %02lu%s%02lu ",
            strlen(PCHAR(DaysOfWeek))/7, PSZ(DaysOfWeek) + DateTime.weekday*(strlen(PCHAR(DaysOfWeek))/7),
            DateTime.month, CountryInfo.szDateSeparator, DateTime.day ) ;
         break ;
   } /* endswitch */

   if ( CountryInfo.fsTimeFmt ) {
      sprintf ( Text+strlen(Text), "%02lu%s%02lu", DateTime.hours, CountryInfo.szTimeSeparator, DateTime.minutes ) ;
   } else {
      PCHAR AmPm ;
      if ( DateTime.hours ) {
         if ( DateTime.hours < 12 ) {
            AmPm = szAm ;
         } else if ( DateTime.hours == 12 ) {
            if ( DateTime.minutes )
               AmPm = szPm ;
            else
               AmPm = szAm ;
         } else if ( DateTime.hours > 12 ) {
            DateTime.hours -= 12 ;
            AmPm = szPm ;
         } /* endif */
      } else {
         DateTime.hours = 12 ;
         if ( DateTime.minutes )
            AmPm = szAm ;
         else
            AmPm = szPm ;
      } /* endif */
      sprintf ( Text+strlen(Text), "%02lu%s%02lu%s", DateTime.hours, CountryInfo.szTimeSeparator, DateTime.minutes, AmPm ) ;
   } /* endif */
   printf ( "%*s%s", 40-strlen(Text)/2, "", Text ) ;
   printf ( "\n" ) ;


   // Elapsed Time

   ResourceString ElapsedLabel ( Library.QueryHandle(), IDS_ELAPSED ) ;
   int Column = printf ( "%s", PSZ(ElapsedLabel) ) ;
   strcpy ( Text, "" ) ;

   ULONG Milliseconds ;
   DosQuerySysInfo ( QSV_MS_COUNT, QSV_MS_COUNT, &Milliseconds, sizeof(Milliseconds) ) ;

   ULONG Time = Milliseconds / 60000L ;

   ULONG NumberOfDays = Time / ( 60L * 24L ) ;

   if ( NumberOfDays ) {
      ResourceString Day ( Library.QueryHandle(), IDS_DAY ) ;
      ResourceString Days ( Library.QueryHandle(), IDS_DAYS ) ;
      sprintf ( Text+strlen(Text), "%lu %s, ", NumberOfDays, NumberOfDays > 1 ? PSZ(Days) : PSZ(Day) ) ;
   } /* endif */

   ULONG Minutes = Time % ( 60L * 24L ) ;
   sprintf ( Text+strlen(Text), "%lu%s%02lu ", Minutes/60, CountryInfo.szTimeSeparator, Minutes%60 ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Physical Memory Free

   ResourceString PhysicalMemoryFree ( Library.QueryHandle(), IDS_MEMORY ) ;
   Column = printf ( "%s", PSZ(PhysicalMemoryFree) ) ;
   APIRET16 APIENTRY16 Dos16MemAvail ( PULONG pulAvailMem ) ;
   ULONG PhysMemFree ;
   Dos16MemAvail ( &PhysMemFree ) ;
   FormatValue ( PhysMemFree, Text, CountryInfo ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Virtual Memory Free

   ResourceString VirtualMemoryFree ( Library.QueryHandle(), IDS_VIRTUAL ) ;
   Column = printf ( "%s", PSZ(VirtualMemoryFree) ) ;
   ULONG VirtMemFree ;
   DosQuerySysInfo ( QSV_TOTAVAILMEM, QSV_TOTAVAILMEM, &VirtMemFree, sizeof(VirtMemFree) ) ;
   FormatValue ( VirtMemFree, Text, CountryInfo ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Swapfile Size

   ResourceString SwapfileSize ( Library.QueryHandle(), IDS_SWAPSIZE ) ;
   Column = printf ( "%s", PSZ(SwapfileSize) ) ;
   ULONG PathSize ;
   DosQuerySysInfo ( QSV_MAX_PATH_LENGTH, QSV_MAX_PATH_LENGTH, &PathSize, sizeof(PathSize) ) ;
   PBYTE Path = PBYTE ( malloc ( size_t(PathSize) ) ) ;
   strcpy ( PCHAR(Path), PCHAR(SwapPath) ) ;
   if ( Path[strlen(PCHAR(Path))-1] != '\\' ) {
      strcat ( PCHAR(Path), "\\" ) ;
   } /* endif */
   strcat ( PCHAR(Path), "SWAPPER.DAT" ) ;
   ULONG SwapSize = 0 ;
   FILESTATUS3 FileStatus ;
   if ( DosQueryPathInfo ( (PSZ)Path, FIL_STANDARD, &FileStatus, sizeof(FileStatus) ) == 0 ) {
      SwapSize = FileStatus.cbFileAlloc ;
   } /* endif */
   free ( Path ) ;
   FormatValue ( SwapSize, Text, CountryInfo ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Available Swap Space

   ResourceString SwapspaceFree ( Library.QueryHandle(), IDS_SWAPFREE ) ;
   Column = printf ( "%s", PSZ(SwapspaceFree) ) ;
   Path = PBYTE ( malloc ( size_t(PathSize) ) ) ;
   strcpy ( PCHAR(Path), (PCHAR)SwapPath ) ;
   strcat ( PCHAR(Path), "\\SWAPPER.DAT" ) ;
   ULONG SwapFree = 0 ;
   if ( Path[0] ) {
      DosError ( FERR_DISABLEHARDERR ) ;
      FSALLOCATE Allocation ;
      DosQueryFSInfo ( Path[0]-'A'+1, FSIL_ALLOC, (PBYTE)&Allocation, sizeof(Allocation) ) ;
      DosError ( FERR_ENABLEHARDERR ) ;
      SwapFree = Allocation.cUnitAvail*Allocation.cSectorUnit*Allocation.cbSector ;
   } /* endif */
   if ( SwapFree < ULONG(MinFree*1024L) )
      SwapFree = 0 ;
   else
      SwapFree = SwapFree - ULONG(MinFree*1024L) ;
   free ( Path ) ;
   FormatValue ( SwapFree, Text, CountryInfo ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Swapfile Slack Space

   ResourceString SwapslackFree ( Library.QueryHandle(), IDS_SWAPSLACK ) ;
   Column = printf ( "%s", PSZ(SwapslackFree) ) ;
   LONG SwapSlack = VirtMemFree - SwapFree - PhysMemFree ;
   SwapSlack = max ( 0, SwapSlack ) ;
   FormatValue ( SwapSlack, Text, CountryInfo ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Spoolfile Size

   ResourceString SpoolSize ( Library.QueryHandle(), IDS_SPOOLSIZE ) ;
   Column = printf ( "%s", PSZ(SpoolSize) ) ;
   Path = PBYTE ( malloc ( size_t(PathSize) ) ) ;
   PFILEFINDBUF3 Found = PFILEFINDBUF3 ( malloc ( size_t(PathSize+sizeof(FILEFINDBUF3)) ) ) ;
   strcpy ( (PCHAR)Path, (PCHAR)SpoolPath ) ;
   strcat ( (PCHAR)Path, "\\*.*" ) ;
   HDIR hDir = (HDIR) HDIR_CREATE ;
   Count = 1 ;
   ULONG TotalSize = 0 ;
   if ( !DosFindFirst2 ( Path, &hDir,
      FILE_NORMAL | FILE_READONLY | FILE_DIRECTORY | FILE_ARCHIVED,
      Found, PathSize+sizeof(FILEFINDBUF3), &Count, FIL_STANDARD ) ) {
      do {
         if ( !strcmp ( (PCHAR)Found->achName, "." ) OR !strcmp ( (PCHAR)Found->achName, ".." ) ) {
            continue ;
         } /* endif */
         if ( Found->attrFile & FILE_DIRECTORY ) {
            HDIR hDir2 = (HDIR) HDIR_CREATE ;
            strcpy ( (PCHAR)Path, (PCHAR)SpoolPath ) ;
            strcat ( (PCHAR)Path, "\\" ) ;
            strcat ( (PCHAR)Path, (PCHAR)Found->achName ) ;
            strcat ( (PCHAR)Path, "\\*.*" ) ;
            ULONG Count2 = 1 ;
            if ( !DosFindFirst2 ( Path, &hDir2,
               FILE_NORMAL | FILE_READONLY | FILE_ARCHIVED,
               Found, PathSize+sizeof(FILEFINDBUF3), &Count2, FIL_STANDARD ) ) {
               do {
                  TotalSize += Found->cbFileAlloc ;
               } while ( !DosFindNext ( hDir2, Found, PathSize+sizeof(FILEFINDBUF3), &Count2 ) ) ;
               DosFindClose ( hDir2 ) ;
            } /* endif */
         } else {
            TotalSize += Found->cbFileAlloc ;
         } /* endif */
      } while ( !DosFindNext ( hDir, Found, PathSize+sizeof(FILEFINDBUF3), &Count ) ) ;
      DosFindClose ( hDir ) ;
   } /* endif */
   free ( Path ) ;
   free ( Found ) ;
   FormatValue ( TotalSize, Text, CountryInfo ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Active Task Count

   ResourceString ActiveTaskCount ( Library.QueryHandle(), IDS_TASKCOUNT ) ;
   Column = printf ( "%s", PSZ(ActiveTaskCount) ) ;
   ULONG TaskCount = WinQuerySwitchList ( 0, 0, 0 ) ;
   sprintf ( Text, "%i ", TaskCount ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Process Count

   ResourceString ProcessCount ( Library.QueryHandle(), IDS_PROCESSCOUNT ) ;
   Column = printf ( "%s", PSZ(ProcessCount) ) ;
   int ProcCount = 0 ;
   PULONG DQPS_Buffer ;
   DosAllocMem ( (PPVOID)&DQPS_Buffer, 0x10000, PAG_READ | PAG_WRITE | PAG_COMMIT | OBJ_TILE ) ;
   if ( !DosQProcStatus ( DQPS_Buffer, 0xFFFF ) ) {
      qsPrec_s *pProcRecord = ((qsPtrRec_s*)DQPS_Buffer)->pProcRec ;
      while ( pProcRecord->RecType == 1 ) {
         int Size = sizeof(qsPrec_s) ;
         Size += pProcRecord->cTCB * sizeof(qsTrec_s) ;
         Size += pProcRecord->c16Sem * sizeof(short) ;
         Size += pProcRecord->cLib * sizeof(short) ;
         Size += pProcRecord->cShrMem * sizeof(short) ;
         pProcRecord = (qsPrec_s*) ( (char*)pProcRecord + Size ) ;
         ProcCount ++ ;
      } /* endwhile */
   } /* endif */
   DosFreeMem ( DQPS_Buffer ) ;
   sprintf ( Text, "%i ", ProcCount ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Thread Count

   ResourceString ThreadCount ( Library.QueryHandle(), IDS_THREADCOUNT ) ;
   Column = printf ( "%s", PSZ(ThreadCount) ) ;
   int ThrdCount = 0 ;
   DosAllocMem ( (PPVOID)&DQPS_Buffer, 0x10000, PAG_READ | PAG_WRITE | PAG_COMMIT | OBJ_TILE ) ;
   if ( !DosQProcStatus ( DQPS_Buffer, 0xFFFF ) ) {
      ThrdCount = int ( ((qsPtrRec_s*)DQPS_Buffer)->pGlobalRec->cThrds ) ;
   } /* endif */
   DosFreeMem ( DQPS_Buffer ) ;
   sprintf ( Text, "%i ", ThrdCount ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Total Free Space

   ResourceString TotalFree ( Library.QueryHandle(), IDS_TOTALFREE ) ;
   Column = printf ( "%s", PSZ(TotalFree) ) ;
   ULONG Drive, Drives ;
   DosQueryCurrentDisk ( &Drive, &Drives ) ;
   ULONG Free = 0 ;
   ULONG Mask = Drives >> 2 ;
   for ( Drive=3; Drive<=26; Drive++ ) {
      if ( Mask & 1 ) {
         BYTE FileSystem [80] = { 0 } ;
         BYTE DiskLabel [12] = { 0 } ;
         if ( CheckDrive ( USHORT(Drive), FileSystem, DiskLabel ) ) {
            DosError ( FERR_DISABLEHARDERR ) ;
            FSALLOCATE Allocation ;
            APIRET Status = DosQueryFSInfo ( Drive, FSIL_ALLOC, (PBYTE)&Allocation, sizeof(Allocation) ) ;
            DosError ( FERR_ENABLEHARDERR ) ;
            if ( Status ) {
               Drives &= ~ ( 1 << (Drive-1) ) ;
            } else {
               Free += Allocation.cUnitAvail*Allocation.cSectorUnit*(Allocation.cbSector/256) ;
            } /* endif */
         } else {
            Drives &= ~ ( 1 << (Drive-1) ) ;
         } /* endif */
      } /* endif */
      Mask >>= 1 ;
   } /* endfor */
   FormatValue ( Free, Text, CountryInfo, SHOWK_ABOVE512, 256 ) ;
   printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
   printf ( "\n" ) ;


   // Drive Space Free
   ResourceString DriveFree ( Library.QueryHandle(), IDS_DRIVE_FREE ) ;
   Mask = Drives >> 2 ;
   for ( Drive=3; Drive<=26; Drive++ ) {
      if ( Mask & 1 ) {
         BYTE FileSystem [80] = { 0 } ;
         BYTE DiskLabel [12] = { 0 } ;
         if ( CheckDrive ( USHORT(Drive), FileSystem, DiskLabel ) ) {
            DosError ( FERR_DISABLEHARDERR ) ;
            FSALLOCATE Allocation ;
            APIRET Status = DosQueryFSInfo ( Drive, FSIL_ALLOC, (PBYTE)&Allocation, sizeof(Allocation) ) ;
            DosError ( FERR_ENABLEHARDERR ) ;
            if ( Status ) {
               Drives &= ~ ( 1 << (Drive-1) ) ;
            } else {
               char Label [80] ;
               sprintf ( Label, PCHAR(DriveFree), Drive+'A'-1 ) ;
               Column = printf ( "%s (%s,%s)", Label, DiskLabel, FileSystem ) ;
               Free = Allocation.cUnitAvail*Allocation.cSectorUnit*Allocation.cbSector ;
               FormatValue ( Free, Text, CountryInfo ) ;
               printf ( "%*s%s", 79-Column-strlen(Text), "", Text ) ;
               printf ( "\n" ) ;
            } /* endif */
         } else {
            Drives &= ~ ( 1 << (Drive-1) ) ;
         } /* endif */
      } /* endif */
      Mask >>= 1 ;
   } /* endfor */

   return ( 0 ) ;
}

static void FormatValue ( long Value, char Text[], COUNTRYINFO &CountryInfo, int ShowK, int Scale ) {

   switch ( ShowK ) {
      case SHOWK_NEVER:
         sprintf ( Text, "%lu", Value*Scale ) ;
         break;
      case SHOWK_ALWAYS:
         sprintf ( Text, "%lu", (Value+(512/Scale))/(1024/Scale) ) ;
         break;
      case SHOWK_ABOVE512:
      default:
         if ( Value < 0x80000/Scale )
            sprintf ( Text, "%lu", Value*Scale ) ;
         else
            sprintf ( Text, "%lu", (Value+(512/Scale))/(1024/Scale) ) ;
         break;
   } /* endswitch */

   char Work[100] ;
   char *p1 = Text ;
   char *p2 = Work ;
   while ( *p1 ) {
      *p2 = *p1 ;
      p1 ++ ;
      p2 ++ ;
      if ( *p1 ) {
         if ( strlen(p1) % 3 == 0 ) {
            *p2 = CountryInfo.szThousandsSeparator [0] ;
            p2 ++ ;
         } /* endif */
      } /* endif */
   } /* endwhile */
   *p2 = 0 ;
   strcpy ( Text, Work ) ;

   p2 = Text + strlen(Text) ;
   *(p2+1) = 0 ;
   switch ( ShowK ) {
      case SHOWK_NEVER:
         *p2 = ' ' ;
         break;
      case SHOWK_ALWAYS:
         *p2 = 'K' ;
         break;
      case SHOWK_ABOVE512:
      default:
         if ( Value < 0x80000/Scale )
            *p2 = ' ' ;
         else
            *p2 = 'K' ;
         break;
   } /* endswitch */
}

static PSZ ScanSystemConfig ( HAB Anchor, PSZ Keyword ) {

   ULONG BootDrive ;
   DosQuerySysInfo ( QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, &BootDrive, sizeof(BootDrive) ) ;

   WinUpper ( Anchor, 0, 0, Keyword ) ;

   char Path [_MAX_PATH] ;
   Path[0] = (char) ( BootDrive + 'A' - 1 ) ;
   Path[1] = 0 ;
   strcat ( Path, ":\\CONFIG.SYS" ) ;

   FILE *File = fopen ( Path, "r" ) ;
   if ( NOT File ) {
      return ( 0 ) ;
   } /* endif */

   static char Buffer [500] ;
   while ( fgets ( Buffer, sizeof(Buffer), File ) ) {

      if ( Buffer[strlen(Buffer)-1] == '\n' ) 
         Buffer[strlen(Buffer)-1] = 0 ;

      WinUpper ( Anchor, 0, 0, PSZ(Buffer) ) ;

      char *p = Buffer ;
      while ( *p AND ( ( *p == ' ' ) OR ( *p == '\t' ) ) ) p++ ;

      if ( strncmp ( p, PCHAR(Keyword), strlen(PCHAR(Keyword)) ) )
         continue ;

      p += strlen(PCHAR(Keyword)) ;
      while ( *p AND ( ( *p == ' ' ) OR ( *p == '\t' ) ) ) p++ ;

      if ( *p++ != '=' )
         continue ;

      while ( *p AND ( ( *p == ' ' ) OR ( *p == '\t' ) ) ) p++ ;

      fclose ( File ) ;
      return ( PSZ(p) ) ;

   } /* endwhile */

   fclose ( File ) ;

   return ( 0 ) ;
}

static char *CopyString ( char *Buffer, char *Original ) {
   char *p1 = PCHAR(Original), *p2 = Buffer ;
   BOOL Quoted = FALSE ;
   *p2 = 0 ;
   while ( *p1 ) {
      if ( Quoted ) {
         if ( *p1 == '"' ) {
            Quoted = FALSE ;
         } else {
            *p2++ = *p1 ;
            *p2 = 0 ;
         } /* endif */
      } else {
         if ( *p1 == '"' ) {
            Quoted = TRUE ;
         } else if ( ( *p1 == ' ' ) OR ( *p1 == '\t' ) ) {
            break ;
         } else {
            *p2++ = *p1 ;
            *p2 = 0 ;
         } /* endif */
      } /* endif */
      p1 ++ ;
   } /* endwhile */ 
   return ( p1 ) ;
}

static int CheckDrive ( USHORT Drive, PBYTE FileSystem, PBYTE DiskLabel ) {

   BYTE Path [3] ;
   Path[0] = (BYTE) ( Drive + 'A' - 1 ) ;
   Path[1] = ':' ;
   Path[2] = 0 ;

   DosError ( FERR_DISABLEHARDERR ) ;

   BYTE Buffer [1024] ;
   ULONG Size = sizeof(Buffer) ;
   ULONG Status = DosQueryFSAttach ( Path, 0, FSAIL_QUERYNAME, (PFSQBUFFER2)Buffer, &Size ) ;
   DosError ( FERR_ENABLEHARDERR ) ;

   if ( Status ) {
      return ( 0 ) ;   // Don't monitor.
   } /* endif */

   USHORT cbName = PFSQBUFFER2(Buffer)->cbName ;
   strcpy ( PCHAR(FileSystem), PCHAR(PFSQBUFFER2(Buffer+cbName)->szFSDName) ) ;

   if ( PFSQBUFFER2(Buffer)->iType == FSAT_REMOTEDRV ) {
      return ( -1 ) ;  // Monitor but don't include in the total over all drives.
   } /* endif */

   ULONG Action ;
   HFILE Handle ;
   Status = DosOpen ( Path, &Handle, &Action, 0, 0, FILE_OPEN,
      OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE |
      OPEN_FLAGS_DASD | OPEN_FLAGS_FAIL_ON_ERROR, 0 ) ;

   if ( Status ) {
      return ( 0 ) ;   // Don't monitor.
   } /* endif */

   BOOL Addit = FALSE ;
   BYTE Command = 0 ;
   BYTE NonRemovable ;

   ULONG LengthIn = sizeof(Command) ;
   ULONG LengthOut = sizeof(NonRemovable);

   if ( NOT DosDevIOCtl ( Handle, 8, 0x20,
      &Command, sizeof(Command), &LengthIn,
      &NonRemovable, sizeof(NonRemovable), &LengthOut ) ) {

      Addit = NonRemovable ;

   } /* endif */

   DosClose ( Handle ) ;

   FSINFO Info ;
   if ( DosQueryFSInfo ( Drive, FSIL_VOLSER, PBYTE(&Info), sizeof(Info) ) == 0 )
      strcpy ( PCHAR(DiskLabel), PCHAR(Info.vol.szVolLabel) ) ;

   return ( int(Addit) ) ;    // Monitor and include in overall total if not removable.
}

