/*
** WORKLab, Krebber
** create LogoArt Folder and Data-Objects on Desktop
*/

hyellow  ='[1;33m[1A'
hwhite   ='[1;37m[1A'
nline    = "0D0A"x                                        /* new line */

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

parse arg version

if version = "" then
   version = "B20X";
folder_id="<FLDR_LOGOART_"||version||">";
clipart_id="<FLDR_CLIPART_"||version||">";
program_id="<LOGOART_"||version||">";

say nline hyellow
say "Starting with LogoArt folder generation V."||version
say "All previous objects of this same version will be replaced"
say "Press Enter to continue.."
say nline hwhite
pull

say "creating folders"
clipart_path = directory()||"\CLIPART"
call create_folders clipart_path
if result>0 then do
   say "creating program object"
   call create_program
end

say nline hyellow
say "Done with LogoArt folder generation."
say nline hwhite
exit;

/*
** create folders
*/
create_folders:

   parse arg path

   /* create data type in os2.ini */
   call SysIni 'USER', 'PMWP_ASSOC_TYPE', 'LogoArt', ''

   /* create main folder (replace if exists) */
   rc = SysCreateObject(WPFolder, "LogoArt", "<WP_DESKTOP>", "TREEVIEW=LINES,MINI;OBJECTID="||folder_id, "R");

   /* and shadow to clipart directory (folder and subfolders will be automatically created) */
   rc = SysCreateObject("WPShadow", "Clipart", folder_id, "SHADOWID="||path||";"||dataicon||"ASSOCTYPE=LogoArt;OBJECTID="||clipart_id, "R");

return rc;

/*
** create program object
*/

create_program:
/* assuming all executables are on current directory .. */
title = "LogoArt "||version
name= "EXENAME="||directory()||"\kicker.exe;"
icon= "ICONFILE="||directory()||"\LogoArt.ico;"
defdir="STARTUPDIR="||directory()||";"
assoc="ASSOCTYPE=LogoArt;ASSOCFILTER=*.art;"

vals = "PROGTYPE=PM;"||name||icon||defdir||assoc||"OBJECTID="||program_id;
rc = SysCreateObject(WPProgram, title, folder_id, vals, "R");

return rc;


