/*        rlist.cmd   OS/2-Rexx                rlist <file>
   As a CMD Commandfile rList could be used:
          rList TextFile
          type TextFile |rList
   As a function rlist returns a string with selected numbers:
   a) Give a file and get a selected line ('S'=single select Option):
          selected=rList('c:\autoexec.bat','S')
          h=word(selected,1); if h=1 then LineNumber=word(selected,2)
   b) Take a RexxQueue:
          do i=1 to allines ; queue line.i; end
          selects = rList(); parse var selects sel.0 selects
          do i=1 to sel.0; sel.i=word( selects, i); end
   c) Use "Rxu.dll" and give rlist a stem called "key.":
          if rxfuncquery( 'rxpassbyname')  then
           call rxfuncadd 'rxpassbyname','rxu','rxpassbyname'
          do i=1 to 5; key.i=linein('c:\autoexec.bat'); key.0=i; end
          selects = RxPassByName('rList.cmd', '&key.')
          parse var selects sel.0 selects
          do i=1 to sel.0; sel.i=word( selects, i); end
  Change: Use of UnzipApi.dll with these Args:
          ret=rlist('file.zip file2rlist', 'U')
    Fido: Ralph Ulrich@2:2468/5103.23    or Ralph Ulrich@2:2468/9911.31
   Try F1 to see this Help:
*******************************************************************/
hlp.1 =' rList - Help ͻ'
hlp.2 ='      F1  - Help              Shift-F3  - last Screen    '
hlp.3 ='      F2  - save marks        Shift-F7  - find next      '
hlp.4 ='      F3  - View Line-File     Ctrl-t   - Tabs Convert   '
hlp.5 ='  Alt-F3  - Alternate View     Ctrl-F4  - Edit list File '
hlp.6 ='      F4  - Edit Line-File     Ctrl-F7  - mark findings  '
hlp.7 ='  Alt-F4  - Alternate Edit     Ctrl-F12 - reverse mark   '
hlp.8 ='  Alt-F7  - find               + -  F12 - (un)mark all   '
hlp.9 ='      F11 - clear marks       INS SPACE - unmark mark    '
hlp.10=' Esc  F10 - NoSelect Quit      UP DOWN  - up     down    '
hlp.11='   RETURN - Select & Quit    LEFT RIGHT - left   right   '
hlp.12=' Esc to exit ͼ'
hlp.0 =12
F3listFile    ='call rlist.cmd'
F4editFile    ='tedit.exe'
A_F3listFile  ='start /C /F Less.exe'
A_F4editFile  ='start /PM Epm.exe /h /o /r'
binEditFile   ='start /PM sedit.exe'
pageScroll    =20
parse arg infile, SingleMulti, sbs
      RxuBOOL = 0; UZ_dll_BOOL=0; multiSelectBOOL=1; binFileBOOL=0
      SingleMulti = strip( SingleMulti,'L','-')
      SingleMulti = strip( SingleMulti,'L','/')
      SingleMulti = translate( SingleMulti)
           if SingleMulti = ''  then multiSelectBOOL=1
      else if SingleMulti = 'S' then multiSelectBOOL=0
      else if SingleMulti = 'M' then multiSelectBOOL=1
      else if SingleMulti = 'U' then UZ_dll_BOOL=1
      else  call ERRORSUBR 'rList  2.Arg must be "S" or "M" !'
      if datatype(sbs,'W')=0 then sbs=1
      infile = strip(infile)
      call _qListInits
      if infile  ='/H'|infile  ='/h'|infile  ='/?'|infile  ='-?' then Signal HelpLines
      else if datatype( key.0 , 'W') & rxfuncquery('rxpassbyname')=0 then NOP
      else if UZ_dll_BOOL & infile <> '' then do  /* 'U' Option unzipApi.dll */
         parse var infile zippy infile            /*     seems to be slowly  */
         ret = UZUnZipToVar( zippy, infile, 'key.')
         do i=1 to key.0
            key.i = translate( key.i, '20'x,'09'x)
            if i= zeile then call preview
         end
      end
      else if infile <> '' then do
            thisfile = stream( infile, 'C', 'query exists')
            if thisfile = '' then do
               call SysFileTree infile||'*', 'datfund.', 'FO'
               if datfund.0 > 0 then infile = datfund.1
            end
            else infile = thisfile
            ret = stream( infile, 'C', 'OPEN READ')
            if abbrev( ret, 'NOTREADY', 8)  then call ERRORSUBR ret' ERROR File open: 'infile' in Dir: 'directory()
            i = 0
            do while lines( infile)
               i= i+1
               key.i = linein( infile)
               if \binFileBOOL then do
                  if left(key.i,1)<'09'x then binFileBOOL=1
                  else if i = zeile then call preView
               end
            end
            key.0 = i
            call stream infile, 'C', 'Close'
      end
      else do
         i = 0
         do while lines()
            i = i + 1
            parse value linein() with key.i
            if length( key.i)=0 then i = i -1
            else if \binFileBOOL then do
               if left(key.i,1)<'09'x then binFileBOOL=1
               else if i = zeile then call preView
            end
         end
         infile = 'Pipe'
         if i = 0 then do
            do while queued()>0
               i = i + 1
               parse pull key.i
               if \binFileBOOL then do
                  if left(key.i,1)<'09'x then binFileBOOL=1
                  else if i = zeile then call preView
               end
            end
            infile = 'rxQueue'
         end
         key.0 = i
      end
      if key.0 > 0 then do
         if binFileBOOL then call binConvertSUBR
         call oldCurSUBR
         selected = qListSUBR( infile, multiSelectBOOL, sbs )
      end
CleanUpMARKE:
return selected

oldCurSUBR:
   oldCurPos = 99999999
   oldCurQueue = 'OLD_CURPOS_Q'
   new_Q = rxqueue('create', oldCurQueue)
   if new_Q <> oldCurQueue then rc = rxqueue('delete', new_Q)
   oldq = rxqueue("set", oldCurQueue )
   file = filespec('N',infile)
   do i=1 to queued()
      parse pull oldCur
      if i<20 then queue oldCur
      if oldCurPos>key.0 then if pos( file, oldCur)>2 then oldCurPos = word(oldCur,1)
   end
   call rxqueue "set", oldq
return 0

binConvertSUBR:
   do i=1 to key.0
      hkey.i = key.i
   end
   hkey.0 = key.0
   z=0
   do i=1 to hkey.0
      z=z+2 ; y = z-1
      key.y = translate( hkey.i, '00000000000000001', xrange('00'x,'1F'x),'1')
      key.z = translate( hkey.i, '0123456789ABCDEF0123456789ABCDEF', xrange('00'x,'FF'x),'_')
      key.z =  key.z||'##2'
      if z = zeile then call preView
   end
   key.0 = z
   drop hkey.
return 0

preView:
      call SysCurPos 0, 0
      call charout stderr, Ansi.list
      do s= 1 to zeile; call charout, substr(key.s, sbs, spalte) ; end
return
ERRORSUBR:
      parse arg message
      call lineout stderr, '     'message
      '@pause'
Signal CleanUpMARKE

HelpLines:
      do i = 1 to hlp.0;  say hlp.i; end
Signal CleanUpMARKE

                  /******************************************************/
                  /* Returns:  MehrfachWahl= totalNr Nr.1 Nr.2          */
qListSUBR:        /******************************************************/
      parse Arg infile, multiSelectBOOL, sbs
      suchT = '';  eingabe='FIRST' ; screenTextBOOL =0;
      do i = (key.0+1) to (key.0 +zeile) ; key.i ='' ; end
      infoLine = Ansi.message ' rList   F1 Help  ' right( infile, spalte-35) right( key.0, 8) Ansi.norm
      curs=0
      if oldCurPos < key.0 then last = oldCurPos
      else last=1
      Do until eingabe=Return_KEY|eingabe=Esc_KEY|eingabe='q'|eingabe=F10_KEY
         neuScreenBOOL=1
         select
/*         Down */
            when eingabe = Down_KEY then do
               if curs < (zeile -1) then do
                   curs = curs + 1 ; neuScreenBOOL=0
               end
               else if last > key.0 - zeile then do
                  neuScreenBOOL=0
               end
               else last = last +1
               if curs+last > key.0 then curs = key.0-last
            end
   /*       Up  */
            when eingabe = Up_KEY then do
               if curs > 0 then do
                  curs = curs - 1; neuScreenBOOL=0
               end
               else if last < 2 then do
                  neuScreenBOOL=0
               end
               else last = last - 1
            end
            when eingabe = c_Down_KEY then do
               curs = zeile -1 ;  neuScreenBOOL=0
               if curs+last > key.0 then curs = key.0-last
            end
            when eingabe = c_Up_KEY then do
               curs = 0;  neuScreenBOOL=0
            end
            when eingabe = Left_KEY|eingabe = c_Left_KEY then do
                sbs = sbs - 20
                if eingabe = c_Left_KEY then sbs = 1
                else if sbs < 1 then sbs = 1
            end
            when eingabe = Right_KEY|eingabe = c_Right_KEY then do
                if eingabe = c_Right_KEY then sbs = sbs + 60
                else sbs = sbs + 20
            end
            when eingabe = PgUp_KEY then do
               neuScreenBOOL=0
               curs = curs -pageScroll
               if curs < 0 then do
                  if last =1 then curs =0
                  else do
                     neuScreenBOOL=1
                     curs = curs +pageScroll
                     last = last -pageScroll
                     if last <1 then do
                        curs = last + curs -1
                        if curs < 0 then curs =0
                        last = 1
                     end
                  end
               end
            end
            when eingabe = PgDown_KEY then do
               now = last + curs
               curs  = curs +pageScroll
               if (curs + last) > key.0 then curs = key.0 -last
               if curs > (zeile-1) then do
                  neuScreenBOOL=1
                  last  = now
                  curs  = pageScroll
                  if last +curs > key.0 then curs = key.0 -last
               end
               else neuScreenBOOL=0
            end
            when eingabe=c_Home_KEY |eingabe=c_PgUp_KEY |eingabe=Home_KEY then do
               curs = 0;  last = 1
               if eingabe=c_Home_KEY then sbs=1
            end
            when eingabe=c_Ende_KEY |eingabe=c_PgDown_KEY |eingabe=Ende_KEY then do
               curs = zeile -1;last = key.0 +1 - zeile
            end
            when eingabe =Space_KEY|eingabe = Insert_KEY then do     /* LeerTaste -- markieren */
               mw = last + curs
               if mw <= Key.0 then do
                  if multiSelectBOOL then do
                     if vorAnsi.mw <> Ansi.mark then do
                        vorAnsi.mw = Ansi.mark
                     end
                     else do
                        vorAnsi.mw = Ansi.list
                     end
                     call charout stderr, vorAnsi.mw
                     call charout, left( substr(key.mw, sbs), spalte)
                     if curs < (zeile-1) then do
                        curs = curs + 1; neuScreenBOOL=0
                     end
                     else if last > key.0 - zeile then
                        neuScreenBOOL=0
                     else
                        last = last +1
                  end
                  else do
                     do i = 1 to key.0
                       if i<>mw & vorAnsi.i = Ansi.mark then VorAnsi.i = Ansi.list
                     end
                     if vorAnsi.mw <> Ansi.mark then do
                        vorAnsi.mw = Ansi.mark
                     end
                     else do
                        vorAnsi.mw = Ansi.list
                     end
                     if curs < (zeile-1) then curs = curs + 1
                     else last = last +1
                  end
               end
            end
            when eingabe = F1_KEY then do
               call SysCurState 'OFF'
               call charout stderr, Ansi.F1_Help
               do i =1 to hlp.0
                  call SysCurPos i, 6
                  call charout, hlp.i
               end
               call SysGetKey 'NoEcho'
               call SysCurState 'ON'
            end
            when eingabe = F2_KEY then do
               saveFile = SysTempFileName( directory()'\???.tmp')
               do until pos( 'dir', saveFile) <> 1
                  saveAufforderung = ' ? Esc/Return/DIR/-A (CLIPB.exe)     red lines to file: '
                  call SysCurPos zeile, 0
                  call charout stderr, Ansi.mark
                  saveFile = rxanswer( saveAufforderung, saveFile, 1)
                  saveFile = strip(saveFile)
                  if pos('dir', saveFile )=1 | pos('DIR', saveFile )=1 then do
                     call SysCurPos zeile, 0
                     address 'CMD' saveFile
                  end
               end
               clipBOOL=0
               if pos('-', saveFile)>0 then do
                  clipBOOL=1
                  clipopt = saveFile
                  saveFile = SysTempFileName('c:\???rlist.tmp')
               end
               sav = 0
               if length(saveFile)>0 then do
                  if stream( saveFile, 'C', 'OPEN Write') = 'READY:' then do
                     do i= 1 to key.0
                        if vorAnsi.i = Ansi.mark then do
                           sav = sav +1
                           call lineout saveFile, key.i
                        end
                     end
                     call stream saveFile, 'C', 'Close'
                     if clipBOOL then do
                        '@type 'saveFile' | clipb.exe 'clipopt
                        call SysFileDelete saveFile
                     end
                     if sav = 0 then call putMessageAsk sav' lines - mark with spacebar some lines!'
                  end
                  else call putMessageAsk ' ERROR   writing to  "'saveFile'"'
               end
            end
   /*       F3  a_F3  */
            when eingabe=F3_KEY|eingabe=a_F3_KEY then do
               now = last + curs
               liny = key.now
               file = getLineFilePROC( liny)
               if file <> '' then do
                  call setLastLineSUBR
                  if eingabe=a_F3_KEY then address 'CMD' a_F3listFile file
                  else do
                     address 'CMD' F3listFile file
                     ScreenText = SysTextScreenRead(0,0, zeile*spalte)
                  end
               end
            end
   /*        F4 a_F4  */
            when eingabe=F4_KEY|eingabe=a_F4_KEY then do
               now = last + curs
               liny = key.now
               file = getLineFilePROC( liny)
               if file <> '' then do
                  call setLastLineSUBR
                  if eingabe=a_F4_KEY then address 'CMD' a_F4editFile file
                  else                     address 'CMD' F4editFile file
               end
            end
            when eingabe = c_F4_KEY then do
               if infile<>'Pipe' & infile<>'rxQueue' then do
                  if infile <> '' then do
                     call setLastLineSUBR
                     if binFileBOOL then address 'CMD' binEditFile infile '-b'
                     else                address 'CMD' a_F4editFile infile
                  end
               end
            end
            when eingabe=a_F7_KEY|eingabe=F7_KEY then do
               curs = 0
               call SysCurPos zeile, 0
               call charout stderr, Ansi.BlueRed
               suchT = rxanswer( Aufforderung,suchT)
               suchT = translate( suchT)
               strfirstBOOL=1
               if suchT <> '' then
                  do i= 1 to key.0
                     sTpos = pos( suchT, translate(key.i))
                     if sTpos>0 then do
                        vorAnsi.i = Ansi.BlueRed
                        if strfirstBOOL & (i > (last + curs )) then do
                           last = i; curs = 0; sbs= sTpos ; strfirstBOOL=0
                        end
                     end
                  end
            end
            when eingabe=s_F7_KEY then do
               now = last + curs +1
               do i= now to key.0
                     sTpos = pos( suchT, translate(key.i))
                     if sTpos>0 then do
                         last = i; curs = 0;  sbs= sTpos ; leave i
                     end
               end
            end
            when eingabe = c_F7_KEY then
               if multiSelectBOOL then
                  do i=1 to key.0
                     if vorAnsi.i = Ansi.BlueRed then
                        vorAnsi.i = Ansi.mark
                  end
            when multiSelectBOOL & eingabe = '+' then
               do i=1 to key.0
                  vorAnsi.i = Ansi.mark
               end
            when eingabe = F11_KEY then
               do i=1 to key.0
                  if vorAnsi.i = Ansi.mark then do
                     VorAnsi.i = Ansi.list
                  end
               end
            when eingabe = F12_KEY | eingabe='-' then do
               do i=1 to key.0
                  VorAnsi.i = Ansi.list
               end
            end
            when eingabe = c_F12_KEY then do
               if multiSelectBOOL then do i=1 to key.0
                  if VorAnsi.i = Ansi.mark then VorAnsi.i=Ansi.list
                  else VorAnsi.i=Ansi.mark
               end
            end
            when eingabe = c_T_KEY then do
               if \binFileBOOL then do i=1 to key.0
                  tabpos = pos('09'x, key.i)
                  do while tabpos > 0
                     key.i = overlay(' ', key.i, tabpos)
                     key.i = insert(' ', key.i, tabpos, 7, ' ')
                     tabpos = pos('09'x, key.i)
                  end
               end
            end
/*           s_F3 c_O                 */
            when eingabe =s_F3_KEY |eingabe =c_O_KEY then do
               if screenTextBOOL then do
                  screenTextBOOL=0
                  neuScreenBOOL=1
               end
               else do
                  call SysCurState 'OFF'
                  call SysCurPos 0,0
                  call charout stderr, Ansi.norm||screenText
                  screenTextBOOL =1
                  neuScreenBOOL=0
               end
            end
            when eingabe ='FIRST' then NOP
            otherwise neuScreenBOOL=0
         end  /* select */
         call SysCurState 'OFF'
         if neuScreenBOOL then do
            screenTextBOOL=0
            if last < 1 then last = 1
            call SysCurPos 0,0
            call charout stderr, Ansi.list
            AnsiCurrent = Ansi.list
            do now = last to (last + zeile -1)
               if vorAnsi.now <> AnsiCurrent then do
                  call charout stderr, vorAnsi.now
                  AnsiCurrent = vorAnsi.now
               end
               call charout, substr(key.now, sbs, spalte)
            end
         end
         if \screenTextBOOL then do
            call SysCurPos zeile, 0
            call charout stderr, infoLine||right(curs+last, 4)
         end
         call SysCurPos curs , 0
         call SysCurState 'ON'
         eingabe = SysGetKey('NoEcho')
         if eingabe ='E0'x|eingabe ='00'x then eingabe =eingabe||SysGetKey('NoEcho')
      End
      call SysCurPos zeile , 0
      call charout , Ansi.norm||copies(' ', spalte-1)
      call SysCurPos zeile-1 , 0
      oldq = rxqueue("set", oldCurQueue )
      push last filespec('N',infile)
      call rxqueue "set", oldq
      if eingabe=Return_KEY then wahl=returnStringPROC()
      else wahl=0
return wahl


putMessageAsk:
      parse arg thisMessage
      call SysCurPos zeile, 0
      call charout stderr, Ansi.ask
      call charout , copies(' ', spalte -1)
      call SysCurPos zeile , spalte % 8
      thisMessage = strip(left(thisMessage,(spalte - (spalte % 4))))
      call charout , thisMessage
      antw = SysGetKey()
return antw


returnStringPROC: procedure expose last curs key. vorAnsi. Ansi.
          wahl = ''; anz=0
          do w = 1 to key.0
                if vorAnsi.w = Ansi.mark then do
                   wahl = wahl w
                   anz = anz+1
                end
          end
          if wahl = '' then do; anz=1; wahl=' '||last+curs; end
          wahl = anz||wahl
return wahl

_qListInits:
      if rxfuncquery('SysLoadFuncs')=1 then do; call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"; call SysLoadFuncs; end
      parse value SysTextScreenSize() with zeile spalte
      zeile = zeile -1
      if pageScroll> zeile-1 then pageScroll = zeile-1
      screenText=SysTextScreenRead(0,0, zeile*spalte)
      Aufforderung = ' Search-String: '; eingFeld = "               "
      Space_KEY    ='20'x;      Insert_KEY = 'E052'x;
      Esc_KEY      ='1B'x;      Return_KEY   ='0D'x;
      Up_KEY       ='E048'x;    Down_KEY     ='E050'x;
      c_Up_KEY     ='E08D'x;    c_Down_KEY   ='E091'x;
      Left_KEY     ='E04B'x;    Right_KEY    ='E04D'x;
      c_Left_KEY   ='E073'x;    c_Right_KEY  ='E074'x;
      PgUp_KEY     ='E049'x;    PgDown_KEY   ='E051'x;
      c_PgUp_KEY   ='E084'x;    c_PgDown_KEY ='E076'x;
      Home_KEY     ='E047'x;    Ende_KEY     ='E04F'x;
      c_Home_KEY   ='E077'x;    c_Ende_KEY   ='E075'x;
      F1_KEY       ='003B'x;    F2_KEY       ='003C'x;
      F3_KEY       ='003D'x;    a_F3_KEY     ='006A'x;
      s_F3_KEY     ='0056'x
      c_O_KEY      ='0F'x;
      F4_KEY       ='003E'x;    a_F4_KEY     ='006B'x;
      c_F4_KEY     ='0061'x;
      F7_KEY       ='0041'x;    c_F7_KEY     ='0064'x;
      s_F7_KEY     ='005A'x;    a_F7_KEY     ='006E'x;
      F8_KEY       ='0042'x;    F9_KEY       ='0043'x;
      F10_KEY      ='0044'x;    F11_KEY      ='0085'x;
      F12_KEY      ='0086'x;    c_F12_KEY    ='008A'x
      c_T_KEY      ='14'x;
      Ansi.list    ='1B'x||'[30;46m'
      Ansi.norm    ='1B'x||'[37;40m' /*  Ansi.norm   ='1B'x||'[0m'; */
      Ansi.F1_Help ='1B'x||'[31;47m'
      Ansi.message ='1B'x||'[36;44m'
      Ansi.mark    ='1B'x||'[37;41m'
      Ansi.BlueRed ='1B'x||'[34;41m' /* Ansi.GreyBlue='1B'x||'[37;44m' */
      Ansi.F1_Help ='1B'x||'[31;47m'
      Ansi.ask     ='1B'x||'[37;40m'
      vorAnsi. = Ansi.list
return 0

setLastLineSUBR:
   call SysCurState 'off'
   call SysCurPos zeile, 0
   call charout , copies(' ',79)||Ansi.norm
   call SysCurPos zeile, 0
   call SysCurState 'on'
return 0

getLineFilePROC:
   arg liny
   file = ''
   wordN = words( liny)
   do i= 1 to wordN
      if i>20 then leave i
      pathpos = pos(':\', word(liny, i))-1
      if pathpos>0 & right( word(liny, i),1)<>'\' & pos('*', word(liny, i))=0 then do
         wordy = substr( liny, pathpos)
         wordy = word( wordy,1)
         file = stream( wordy, 'C', 'query exists')
         if file <> '' then leave i
      end
   end
   if file ='' then do i= 1 to wordN
      if i>20 then leave i
      file = stream( word( liny,i), 'C', 'query exists')
      if pos('*', file)>0 then file =''
      if file <>'' then leave i
   end
return file




