/*   LDirs   OS/2-Rexx    List&size of subDirectories: LDirs [directory]
   ͻ
      OS/2-Rexx Pipe-List   Rexx-Menu              
         rList <file.txt>                          
                            Select & Quit  Return  
      Quit        F3,Esc    Mark lines      Space  
      save2File       F2    Mark all       '+',F9  
      find          c+F7    clear findings    F10  
      find next     s+F7    clear marks       F11  
      mark findings a+F7    clear all         F12  
      Cursor     up,down    old screen        c+o  
      Cursor  left,right   Copyright  Ralph Ulrich 
   ͼ
   .

 Fido:  Ralph Ulrich@2:2468/5103.23    or Ralph Ulrich@2:2468/9911.31
*/
arg verz
   rlistBOOL  =1                   /* show with internal rlist-Lister        */
   stdoutBOOL =0                   /*        or ScreenOutput                 */
   OutLogBOOL =0                   /*        or append to OutLogFILE         */
   OutLogFILE ='C:\LDirs.log'
   HeaderBOOL =1                   /* 0=No HeaderLine                        */
   ByteOpt    =2                   /* 1=Byte 2=KB.xx  3=KB  4=MB.xx          */
   Option     =3                   /* like:  Header.<n>                      */
   Header.1   ='Byte FullName'
   Header.2   ='Byte Sub Name'
   Header.3   ='Byte Sub Name'copies(' ',50)'FullName'
   Header.4   ='Byte Sub Cur upDir\Name'copies(' ',40)'FullName'
   if rlistBOOL then do
      call charout stderr,'   LDirs [directory]    '
   end
   if rxfuncquery('SysLoadFuncs') then do
      call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      call SysLoadFuncs
   end
   currdir = directory()
   nowDir = currDir
   if verz <> '' then do
      verz = strip( verz, 'B')        /* Leerzeihen vorne hinte weg */
      verz = strip( verz, 'B', '*')
      verz = strip( verz, 'T','\')
      if pos('*',  verz)>0 then do
          if rlistBOOL=1 then say verz'  -->> No "*" !'
          exit 11
      end
      if right(verz,1)=':' then do
         if length(verz)=2 then do
            nowDir = directory( verz||'\')
         end
      end
      else nowDir = directory( verz)
      if nowDir = '' then do
          if rlistBOOL=1 then say ' ERROR changing Directory'
          Exit 11
      end  /* Do */
   end  /* Do */
   if rlistBOOL then do; call lineout stderr,' ';call lineout stderr,'    ...wait...   list: 'nowDir;end
   liny.0 = 0
   lenVorDir = lastpos('\', nowDir)
   vorDir = substr(nowDir, 1, lenVorDir-1)
   lenVorVorDir = lastpos('\', vorDir)
   call rekursivVerzBig 1, lenVorVorDir, lenVorVorDir +1
   call directory currdir
   h=liny.0;  gesByte = word(liny.h,1)
   if HeaderBOOL=1 then do
      hB.1 = '       '
      hB.2 = '      K'
      hB.3 = '      K'
      hB.4 = '      M'
      liny.0 = liny.0 + 1; h = liny.0
      liny.h = hB.ByteOpt||Header.Option
      liny.0 = liny.0 + 1; h = liny.0
      liny.h = date('E')'  'time()'  'nowDir
   end
   j=0 ;  key.0 =liny.0
   do i=liny.0 to 1 by -1
      if rlistBOOL=1 then do; j= j+1; key.j = liny.i ;end
      else if stdoutBOOL=1 then call lineout , liny.i
      if OutLogBOOL=1 then call lineout OutLogFILE, liny.i
   end
   drop liny.
   if OutLogBOOL=1 then call lineout OutLogFILE
   verz = currdir
   if rlistBOOL=1 then do
      ret =LDrlist()
      if word(ret,1)=1 then do
         r = word(ret,2)
         w = words( key.r); verz = word(key.r,w)
         call directory verz
      end
   end
return gesByte

rekursivVerzBig: procedure expose Option ByteOpt liny.
   arg level,lenVorDir, vorDel
   currDir = directory()
   lencurrDir = lastpos('\', currDir)
   gesByte = 0
   beforeDirs = liny.0
   call SysFileTree '*' , 'vfund.', 'DO', '*****'
   do j=1 to vfund.0
      call directory vfund.j
      thisByte = rekursivVerzBig( (level+1), lencurrDir, vorDel)
      gesByte = gesByte + thisByte
   end
   if vfund.0 > 0 then call directory currDir
   call SysFileTree '*', 'fund.', 'FT',  '*****'
   currByte = 0
   do i=1 to fund.0
      currByte = word( fund.i,2) + currByte
   end
   sub = liny.0 - beforeDirs
   if sub =0 then sub=' '
   sub= right(sub,4)
   liny.0 = liny.0 + 1  ; h = liny.0
   allByte  = gesByte+currByte
  /* 1 Byte  2 KByte.xxx  3 KByte  4 MByte.xxx  5 MByte */
   select
      when ByteOpt=1  then  ByteFormat =right(allByte,11)
      when ByteOpt=2  then  ByteFormat =format((allByte/1024),7,3)
      when ByteOpt=3  then  ByteFormat =format((allByte/1024),11,0)
      when ByteOpt=4  then  ByteFormat =format(((allByte/1024)/1024),7,3)
      otherwise ByteFormat = allByte
   end
/* Header.1   ='      Byte FullDirName' */
/* Header.2   ='      Byte Sub DirName' */
/* Header.3   ='      Byte Sub DirName'copies(' ',48)'FullDirName' */
/* Header.4   ='      Byte Sub Cur upDir\DirName'copies(' ',38)'FullDirName' */
   select
      when Option=1 then do
         liny.h  = ByteFormat currDir
      end
      when Option=2 then do
         currV   = substr( currV, vorDel)
         lenVDir = lastpos('\', currDir)
         currV   = substr(currDir,lenVDir+1)
         liny.h  = ByteFormat||sub||copies(' ',((level-1)*3)) currV
      end
      when Option=3 then do
         currV   = substr( currV, vorDel)
         lenVDir = lastpos('\', currDir)
         currV   = substr(currDir,lenVDir+1)
         liny.h  = ByteFormat||sub||copies(' ',((level-1)*3)) currV
         if length(liny.h)<73 then liny.h = left( liny.h,73) currDir
         else liny.h = liny.h currDir
      end
      when Option=4 then do
         cur = vfund.0
         if cur = 0 then cur=' '
         cur = right(cur' ',4)
         currV  = overlay(' ', currDir,1,lenVorDir,' ')
         currV  = substr( currV, vorDel)
         liny.h = ByteFormat||sub||cur currV
         if length(liny.h)<73 then liny.h = left( liny.h,73) currDir
         else liny.h = liny.h currDir
      end
      otherwise do
         liny.h = right(allByte,10) currDir
      end
   end /* select */
return allByte

LDrlist: procedure expose key.
      parse arg infile, SingleMulti .
      hlp.0=14; RxuBOOL = 0; UZ_dll_BOOL=0; multiSelectBOOL=1
      SingleMulti = strip( SingleMulti,'L','-')
      SingleMulti = strip( SingleMulti,'L','/')
      SingleMulti = translate( SingleMulti)
           if SingleMulti = ''  then multiSelectBOOL=1
      else if SingleMulti = 'S' then multiSelectBOOL=0
      else if SingleMulti = 'M' then multiSelectBOOL=1
      infile = strip(infile)
      call _qListInits
      if key.0 > 0 then selected = qListSUBR( infile, multiSelectBOOL )
return selected

preView:
      call SysCurPos 0, 0
      call charout stderr, Ansi.norm
      do s= 1 to zeile;  call charout ,left(key.s, spalte); end
return
ERRORSUBR:
      parse arg message
      call lineout stderr, ' ERROR: 'message
EXIT -99
HelpLines:
      do i = 2 to hlp.0;  say sourceline( i); end
EXIT -1

                  /******************************************************/
                  /* Returns:  MehrfachWahl= totalNr Nr.1 Nr.2          */
qListSUBR:        /******************************************************/
      parse Arg infile, multiSelectBOOL
      last=1; curs=0; sbs=1; updowncount=0;
      suchT = '';      eingabe=HomeCONST; screenTextBOOL =0;
      do i = -zeile to zeile
          if i < 0 | i > key.0 then key.i =''
      end i
      Do until eingabe=ReturnCONST|eingabe=EscCONST|eingabe=F3CONST|eingabe='q'
         neuScreenBOOL=1
         select
/*       Down */
            when eingabe = DownCONST then do
               if curs < (zeile -1) then do
                   curs = curs + 1 ; neuScreenBOOL=0
               end
               else if last >= key.0 - zeile then do
                  neuScreenBOOL=0
               end
               else last = last +1
            end
   /*       Up  */
            when eingabe = UpCONST then do
               if curs > 0 then do
                  curs = curs - 1; neuScreenBOOL=0
               end
               else if last < 2 then do
                  neuScreenBOOL=0
               end
               else last = last - 1
            end
            when eingabe = C_DownCONST then do
               updowncount = 0
               curs = zeile -1 ;  neuScreenBOOL=0
            end
            when eingabe = C_UpCONST then do
               updowncount = 0
               curs = 0;  neuScreenBOOL=0
            end
            when eingabe = LeftCONST|eingabe = C_LeftCONST then do
                updowncount = 0
                sbs = sbs - 10
                if eingabe = C_LeftCONST then sbs = 1
                else if sbs < 1 then sbs = 1
            end
            when eingabe = RightCONST|eingabe = C_RightCONST then do
                updowncount = 0
                if eingabe = C_RightCONST then sbs = sbs + 20
                else sbs = sbs + 10
            end
            when eingabe = PgUpCONST then do
               curs = 0
               if last < 2 then neuScreenBOOL=0
               else last = last - zeile
               updowncount = 0
            end
            when eingabe = PgDownCONST then do
               curs = zeile-1
               if last > key.0 - zeile then neuScreenBOOL=0
               else last = last + zeile
               updowncount = 0
            end
            when eingabe = C_HomeCONST|eingabe = C_PgUpCONST then do
               curs = 0;  last = 1; updowncount = 0
            end
            when eingabe = C_EndeCONST|eingabe = C_PgDownCONST then do
               curs = zeile -1;last = key.0 +1 - zeile
               updowncount = 0
            end
            when eingabe=HomeCONST then do
               sbs = 1
            end
            when eingabe=EndeCONST then do
               now = last + curs
               sbs = length(key.now) +2 - spalte
               if sbs < 1 then sbs = 1
               updowncount = 0
            end
            when eingabe =LeerCONST|eingabe = InsertCONST then do     /* LeerTaste -- markieren */
               updowncount = 0
               mw = last + curs
               if mw <= Key.0 then do
                  if multiSelectBOOL then do
                     if vorAnsi.mw <> Ansi.WhiteRed then do
                        vorAnsi.mw = Ansi.WhiteRed
                     end
                     else do
                        vorAnsi.mw = Ansi.norm
                     end
                     call charout stderr, vorAnsi.mw
                     call charout, left( substr(key.mw, sbs), spalte)
                     if curs < (zeile-1) then do
                        curs = curs + 1; neuScreenBOOL=0
                     end
                     else if last > key.0 - zeile then
                        neuScreenBOOL=0
                     else
                        last = last +1
                  end
                  else do
                     do i = 1 to key.0
                       if i<>mw & vorAnsi.i = Ansi.WhiteRed then VorAnsi.i = Ansi.Norm
                     end
                     if vorAnsi.mw <> Ansi.WhiteRed then do
                        vorAnsi.mw = Ansi.WhiteRed
                     end
                     else do
                        vorAnsi.mw = Ansi.norm
                     end
                     if curs < (zeile-1) then curs = curs + 1
                     else last = last +1
                  end
               end
            end
            when eingabe = F1CONST then do
               call SysCurState 'OFF'
               call charout stderr, Ansi.F1_Help
               do i =2 to hlp.0
                  call SysCurPos i, (spalte % 6)
                  call charout, strip(sourceline(i))
               end
               call putMessageAsk '    ...press a key !'
               call SysCurState 'ON'
            end
            when eingabe = F2CONST then do
               saveFile = SysTempFileName( directory()'\???.tmp')
               do until pos( 'dir', saveFile) <> 1
                  saveAufforderung = ' ? Esc/Return/DIR/-A (CLIPB.exe)     red lines to file: '
                  call SysCurPos zeile, 0
                  call charout stderr, Ansi.WhiteRed
                  saveFile = rxanswer( saveAufforderung, saveFile, 1)
                  saveFile = strip(saveFile)
                  if pos('dir', saveFile )=1 | pos('DIR', saveFile )=1 then do
                     call SysCurPos zeile, 0
                     address 'CMD' saveFile
                  end
               end
               clipBOOL=0
               if pos('-', saveFile)>0 then do
                  clipBOOL=1
                  clipopt = saveFile
                  saveFile = SysTempFileName('c:\???rlist.tmp')
               end
               sav = 0
               if length(saveFile)>0 then do
                  if stream( saveFile, 'C', 'OPEN Write') = 'READY:' then do
                     do i= 1 to key.0
                        if vorAnsi.i = Ansi.WhiteRed then do
                           sav = sav +1
                           call lineout saveFile, key.i
                        end
                     end
                     call stream saveFile, 'C', 'Close'
                     if clipBOOL then do
                        '@type 'saveFile' | clipb.exe 'clipopt
                        call SysFileDelete saveFile
                     end
                     if sav = 0 then call putMessageAsk sav' lines - mark with spacebar some lines!'
                  end
                  else call putMessageAsk ' ERROR   writing to  "'saveFile'"'
               end
            end
            when eingabe=C_F7CONST|eingabe=F7CONST then do
               curs = 0
               call SysCurPos zeile, 0
               call charout stderr, Ansi.BlueRed
               suchT = rxanswer( Aufforderung,suchT)
               suchT = translate( suchT)
               strfirstBOOL=1
               if suchT <> '' then
                  do i= 1 to key.0
                     if pos( suchT, translate(key.i))>0 then do
                        vorAnsi.i = Ansi.BlueRed
                        if strfirstBOOL & (i > (last + curs )) then do
                           last = i; curs = 0; strfirstBOOL=0
                        end
                     end
                  end
            end
            when eingabe=S_F7CONST then do
               now = last + curs +1
               do i= now to key.0
                     if pos( suchT, translate(key.i))>0 then do
                         last = i; curs = 0; leave i
                     end
               end
            end
            when eingabe = A_F7CONST then
               if multiSelectBOOL then
                  do i=1 to key.0
                     if vorAnsi.i = Ansi.BlueRed then
                        vorAnsi.i = Ansi.WhiteRed
                  end
            when multiSelectBOOL & eingabe = F9CONST then
               do i=1 to key.0
                  if vorAnsi.i = Ansi.WhiteRed |vorAnsi.i = Ansi.BlueRed then
                   do
                     VorAnsi.i = Ansi.Norm
                   end
                   else do
                     vorAnsi.i = Ansi.WhiteRed
                   end
               end
            when multiSelectBOOL & eingabe = '+' then
               do i=1 to key.0
                  vorAnsi.i = Ansi.WhiteRed
               end
            when eingabe = F10CONST then
               do i=1 to key.0
                  if vorAnsi.i = Ansi.BlueRed then do
                     VorAnsi.i = Ansi.Norm
                  end
               end
            when eingabe = F11CONST then
               do i=1 to key.0
                  if vorAnsi.i = Ansi.WhiteRed then do
                     VorAnsi.i = Ansi.Norm
                  end
               end
            when eingabe = F12CONST then do
               do i=1 to key.0
                  VorAnsi.i = Ansi.Norm
               end
            end
/* C_O                 */
            when pos( eingabe, '0123456789'||'0F'x )>0 then do
               if screenTextBOOL then do
                  screenTextBOOL=0
                  neuScreenBOOL=1
               end
               else do
                  call SysCurState 'OFF'
                  call SysCurPos 0,0
                  call charout stderr, Ansi.Normal||screenText
                  screenTextBOOL =1
                  neuScreenBOOL=0
               end
            end
            otherwise neuScreenBOOL=0
         end  /* select */
         call SysCurState 'OFF'
         if neuScreenBOOL then do
            screenTextBOOL=0
            if last > key.0 - ( zeile - 1) then last = key.0 - (  zeile -1 )
            if last < 1 then last = 1
            call SysCurPos 0,0
            call charout stderr, Ansi.Norm
            AnsiCurrent = Ansi.Norm
            do now = last to (last + zeile -1)
               if vorAnsi.now <> AnsiCurrent then do
                  call charout stderr, vorAnsi.now
                  AnsiCurrent = vorAnsi.now
               end
               call charout, left( substr(key.now, sbs), spalte)
            end
         end
         if \screenTextBOOL then call MessageInfo last+curs
         call SysCurPos curs , 0
         call SysCurState 'ON'
         eingabe = SysGetKey('NoEcho')
         if eingabe ='E0'x|eingabe ='00'x then eingabe =eingabe||SysGetKey('NoEcho')
      End
      if eingabe=ReturnCONST then wahl=returnStringPROC()
      else wahl=0
      call SysCurPos zeile , 0
      call charout , Ansi.Normal||copies(' ', spalte-1)
      call SysCurPos zeile-1 , 0
return wahl

_qListInits:
      if rxfuncquery('SysLoadFuncs')=1 then do; call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"; call SysLoadFuncs; end
      parse value SysTextScreenSize() with zeile spalte
      zeile = zeile -1
      screenText=SysTextScreenRead(0,0, zeile*spalte)
      lastString = '     Use <>F1SpaceReturn      rList by Ralph Ulrich     '
      Aufforderung = ' Search-String: '; eingFeld = "               "
      LeerCONST     ='20'x;      InsertCONST = 'E052'x;
      EscCONST      ='1B'x;      ReturnCONST   ='0D'x;
      UpCONST       ='E048'x;    DownCONST     ='E050'x;
      C_UpCONST     ='E08D'x;    C_DownCONST   ='E091'x;
      LeftCONST     ='E04B'x;    RightCONST    ='E04D'x;
      C_LeftCONST   ='E073'x;    C_RightCONST  ='E074'x;
      PgUpCONST     ='E049'x;    PgDownCONST   ='E051'x;
      C_PgUpCONST   ='E084'x;    C_PgDownCONST ='E076'x;
      HomeCONST     ='E047'x;    EndeCONST     ='E04F'x;
      C_HomeCONST   ='E077'x;    C_EndeCONST   ='E075'x;
      F1CONST       ='003B'x;    F2CONST       ='003C'x;
      F3CONST       ='003D'x;
      F7CONST       ='0041'x;    C_F7CONST     ='0064'x;
      S_F7CONST     ='005A'x;    A_F7CONST     ='006E'x;
      F8CONST       ='0042'x;    F9CONST       ='0043'x;
      F10CONST      ='0044'x;    F11CONST      ='0085'x;
      F12CONST      ='0086'x;
      Ansi.Normal   ='1B'x||'[0m';
      Ansi.norm     ='1B'x||'[30;46m'
      Ansi.WhiteRed ='1B'x||'[37;41m'
      Ansi.BlueRed  ='1B'x||'[34;41m'
      Ansi.GreyBlue ='1B'x||'[37;44m'
      Ansi.F1_Help   ='1B'x||'[31;47m'
      Ansi.ask       ='1B'x||'[37;40m'
      Ansi.Cyan     ='1B'x||'[36;44m';
   /* Ansi.Bold     ='1B'x||'[0;37;44;1m';    Ansi.Normal   ='1B'x||'[0m';        */
      vorAnsi. = Ansi.norm
return 0

putMessageAsk:
      parse arg thisMessage
      call SysCurPos zeile, 0
      call charout stderr, Ansi.ask
      call charout , copies(' ', spalte -1)
      call SysCurPos zeile , spalte % 8
      thisMessage = strip(left(thisMessage,(spalte - (spalte % 4))))
      call charout , thisMessage
      antw = SysGetKey()
return antw

MessageInfo:
      arg curr
      call SysCurPos zeile, 0
      call charout stderr, Ansi.Cyan ||left( infile lastString curr key.0, spalte-1)
return 0

returnStringPROC: procedure expose last curs key. vorAnsi. Ansi.
          wahl = ''; anz=0
          do w = 1 to key.0
                if vorAnsi.w = Ansi.WhiteRed then do
                   wahl = wahl w
                   anz = anz+1
                end
          end
          if wahl = '' then do; anz=1; wahl=' '||last+curs; end
          wahl = anz||wahl
return wahl


