
TELNET(1)		     UNIX Reference Manual		     TELNET(1)

NAME
     telnet - user interface to the TELNET protocol

SYNOPSIS
     telnet [-8EFKLacdfrx] [-S tos] [-X authtype] [-e escapechar] [-k realm]
	    [-l user] [-n tracefile] [host [port]]

DESCRIPTION
     The telnet command is used to communicate with another host using the
     TELNET protocol.  If telnet is invoked without the host argument, it en-
     ters command mode, indicated by its prompt (telnet>). In this mode, it
     accepts and executes the commands listed below.  If it is invoked with
     arguments, it performs an open command with those arguments.

     Options:

     -8      Specifies an 8-bit data path.  This causes an attempt to negoti-
	     ate the TELNET BINARY option on both input and output.

     -E      Stops any character from being recognized as an escape character.

     -F      If Kerberos V5 authentication is being used, the -F option allows
	     the local credentials to be forwarded to the remote system, in-
	     cluding any credentials that have already been forwarded into the
	     local environment.

     -K      Specifies no automatic login to the remote system.

     -L      Specifies an 8-bit data path on output.  This causes the BINARY
	     option to be negotiated on output.

     -S tos  Sets the IP type-of-service (TOS) option for the telnet connec-
	     tion to the value tos, which can be a numeric TOS value or, on
	     systems that support it, a symbolic TOS name found in the
	     /etc/iptos file.

     -X atype
	     Disables the atype type of authentication.

     -a      Attempt automatic login.  Currently, this sends the user name via
	     the USER variable of the ENVIRON option if supported by the re-
	     mote system.  The name used is that of the current user as re-
	     turned by getlogin(2) if it agrees with the current user ID, oth-
	     erwise it is the name associated with the user ID.

     -c      Disables the reading of the user's .telnetrc file.  (See the
	     toggle skiprc command on this man page.)

     -d      Sets the initial value of the debug toggle to TRUE

     -e escape char
	     Sets the initial telnet telnet escape character to escape char.
	     If escape char is omitted, then there will be no escape charac-
	     ter.

     -f      If Kerberos V5 authentication is being used, the -f option allows
	     the local credentials to be forwarded to the remote system.

     -k realm
	     If Kerberos authentication is being used, the -k option requests
	     that telnet obtain tickets for the remote host in realm realm in-
	     stead of the remote host's realm, as determined by

	     krb_realmofhost(3).

     -l user
	     When connecting to the remote system, if the remote system under-
	     stands the ENVIRON option, then user will be sent to the remote
	     system as the value for the variable USER.  This option implies
	     the -a option.  This option may also be used with the open com-
	     mand.

     -n tracefile
	     Opens tracefile for recording trace information.  See the set
	     tracefile command below.

     -r      Specifies a user interface similar to rlogin(1).  In this mode,
	     the escape character is set to the tilde (~) character, unless
	     modified by the -e option.

     -x      Turns on encryption of the data stream if possible.  This option
	     is not available outside of the United States and Canada.

     host    Indicates the official name, an alias, or the Internet address of
	     a remote host.

     port    Indicates a port number (address of an application).  If a number
	     is not specified, the default telnet port is used.

     When in rlogin mode, a line of the form ~.  disconnects from the remote
     host; ~ is the telnet escape character.  Similarly, the line ~^Z suspends
     the telnet session.  The line ~^] escapes to the normal telnet escape
     prompt.

     Once a connection has been opened, telnet will attempt to enable the
     TELNET LINEMODE option.  If this fails, then telnet will revert to one of
     two input modes: either ``character at a time'' or ``old line by line''
     depending on what the remote system supports.

     When LINEMODE is enabled, character processing is done on the local sys-
     tem, under the control of the remote system.  When input editing or char-
     acter echoing is to be disabled, the remote system will relay that infor-
     mation.  The remote system will also relay changes to any special charac-
     ters that happen on the remote system, so that they can take effect on
     the local system.

     In ``character at a time'' mode, most text typed is immediately sent to
     the remote host for processing.

     In ``old line by line'' mode, all text is echoed locally, and (normally)
     only completed lines are sent to the remote host.	The ``local echo char-
     acter'' (initially ``^E'') may be used to turn off and on the local echo
     (this would mostly be used to enter passwords without the password being
     echoed).

     If the LINEMODE option is enabled, or if the localchars toggle is TRUE
     (the default for ``old line by line``; see below), the user's quit, intr,
     and flush characters are trapped locally, and sent as TELNET protocol se-
     quences to the remote side.  If LINEMODE has ever been enabled, then the
     user's susp and eof are also sent as TELNET protocol sequences, and quit
     is sent as a TELNET ABORT instead of BREAK There are options (see toggle
     autoflush and toggle autosynch below) which cause this action to flush
     subsequent output to the terminal (until the remote host acknowledges the
     TELNET sequence) and flush previous terminal input (in the case of quit
     and intr).

     While connected to a remote host, telnet command mode may be entered by
     typing the telnet ``escape character'' (initially ``^]'').  When in com-
     mand mode, the normal terminal editing conventions are available.

     The following telnet commands are available.  Only enough of each command
     to uniquely identify it need be typed (this is also true for arguments to
     the mode, set, toggle, unset, slc, environ, and display commands).

     auth argument ...
		The auth command manipulates the information sent through the
		TELNET AUTHENTICATE option.  Valid arguments for the auth com-
		mand are as follows:

		disable type  Disables the specified type of authentication.
			      To obtain a list of available types, use the
			      auth disable ? command.

		enable type   Enables the specified type of authentication.
			      To obtain a list of available types, use the
			      auth enable ? command.

		status	      Lists the current status of the various types of
			      authentication.

     close	Close a TELNET session and return to command mode.

     display argument ...
		Displays all, or some, of the set and toggle values (see be-
		low).

     encrypt argument ...
		The encrypt command manipulates the information sent through
		the TELNET ENCRYPT option.

		Note:  Because of export controls, the TELNET ENCRYPT option
		is not supported outside of the United States and Canada.

		Valid arguments for the encrypt command are as follows:

		disable type [input|output]
			      Disables the specified type of encryption.  If
			      you omit the input and output, both input and
			      output are disabled.  To obtain a list of avail-
			      able types, use the encrypt disable ? command.

		enable type [input|output]
			      Enables the specified type of encryption.  If
			      you omit input and output, both input and output
			      are enabled.  To obtain a list of available
			      types, use the encrypt enable ? command.

		input	      This is the same as the encrypt start input com-
			      mand.

		-input	      This is the same as the encrypt stop input com-
			      mand.

		output	      This is the same as the encrypt start output
			      command.

		-output       This is the same as the encrypt stop output com-
			      mand.

		start [input|output]
			      Attempts to start encryption.  If you omit input
			      and output, both input and output are enabled.
			      To obtain a list of available types, use the

			      encrypt enable ? command.

		status	      Lists the current status of encryption.

		stop [input|output]
			      Stops encryption.  If you omit input and output,
			      encryption is on both input and output.

		type type     Sets the default type of encryption to be used
			      with later encrypt start or encrypt stop com-
			      mands.

     environ arguments...
		The environ command is used to manipulate the the variables
		that my be sent through the TELNET ENVIRON option.  The ini-
		tial set of variables is taken from the users environment,
		with only the DISPLAY and PRINTER variables being exported by
		default.  The USER variable is also exported if the -a or -l
		options are used.
		Valid arguments for the environ command are:

		define variable value
			    Define the variable variable to have a value of
			    value. Any variables defined by this command are
			    automatically exported.  The value may be enclosed
			    in single or double quotes so that tabs and spaces
			    may be included.

		undefine variable
			    Remove variable from the list of environment vari-
			    ables.

		export variable
			    Mark the variable variable to be exported to the
			    remote side.

		unexport variable
			    Mark the variable variable to not be exported un-
			    less explicitly asked for by the remote side.

		list	    List the current set of environment variables.
			    Those marked with a * will be sent automatically,
			    other variables will only be sent if explicitly
			    requested.

		?	    Prints out help information for the environ com-
			    mand.

     logout	Sends the TELNET LOGOUT option to the remote side.  This com-
		mand is similar to a close command; however, if the remote
		side does not support the LOGOUT option, nothing happens.  If,
		however, the remote side does support the LOGOUT option, this
		command should cause the remote side to close the TELNET con-
		nection.  If the remote side also supports the concept of sus-
		pending a user's session for later reattachment, the logout
		argument indicates that you should terminate the session imme-
		diately.

     mode type	Type is one of several options, depending on the state of the
		TELNET session.  The remote host is asked for permission to go
		into the requested mode.  If the remote host is capable of en-
		tering that mode, the requested mode will be entered.

		character     Disable the TELNET LINEMODE option, or, if the
			      remote side does not understand the LINEMODE op-

			      tion, then enter ``character at a time`` mode.

		line	      Enable the TELNET LINEMODE option, or, if the
			      remote side does not understand the LINEMODE op-
			      tion, then attempt to enter ``old-line-by-line``
			      mode.

		isig (-isig)  Attempt to enable (disable) the TRAPSIG mode of
			      the LINEMODE option.  This requires that the
			      LINEMODE option be enabled.

		edit (-edit)  Attempt to enable (disable) the EDIT mode of the
			      LINEMODE option.	This requires that the
			      LINEMODE option be enabled.

		softtabs (-softtabs)
			      Attempt to enable (disable) the SOFT_TAB mode of
			      the LINEMODE option.  This requires that the
			      LINEMODE option be enabled.

		litecho (-litecho)
			      Attempt to enable (disable) the LIT_ECHO mode of
			      the LINEMODE option.  This requires that the
			      LINEMODE option be enabled.

		?	      Prints out help information for the mode com-
			      mand.

     open host [[-l] user][-port]
		Open a connection to the named host.  If no port number is
		specified, telnet will attempt to contact a TELNET server at
		the default port.  The host specification may be either a host
		name (see hosts(5))  or an Internet address specified in the
		``dot notation'' (see inet(3)).  The [-l] option may be used
		to specify the user name to be passed to the remote system via
		the ENVIRON option.  When connecting to a non-standard port,
		telnet omits any automatic initiation of TELNET options.  When
		the port number is preceded by a minus sign, the initial op-
		tion negotiation is done.  After establishing a connection,
		the file .telnetrc in the users home directory is opened.
		Lines beginning with a # are comment lines.  Blank lines are
		ignored.  Lines that begin without white space are the start
		of a machine entry.  The first thing on the line is the name
		of the machine that is being connected to.  The rest of the
		line, and successive lines that begin with white space are as-
		sumed to be telnet commands and are processed as if they had
		been typed in manually to the telnet command prompt.

     quit	Close any open TELNET session and exit telnet. An end of file
		(in command mode) will also close a session and exit.

     send arguments
		Sends one or more special character sequences to the remote
		host.  The following are the arguments which may be specified
		(more than one argument may be specified at a time):

		abort	Sends the TELNET ABORT (Abort processes) sequence.

		ao	Sends the TELNET AO (Abort Output) sequence, which
			should cause the remote system to flush all output
			from the remote system to the user's terminal.

		ayt	Sends the TELNET AYT (Are You There) sequence, to
			which the remote system may or may not choose to re-

			spond.

		brk	Sends the TELNET BRK (Break) sequence, which may have
			significance to the remote system.

		ec	Sends the TELNET EC (Erase Character) sequence, which
			should cause the remote system to erase the last char-
			acter entered.

		el	Sends the TELNET EL (Erase Line) sequence, which
			should cause the remote system to erase the line cur-
			rently being entered.

		eof	Sends the TELNET EOF (End Of File) sequence.

		eor	Sends the TELNET EOR (End of Record) sequence.

		escape	Sends the current telnet escape character (initially
			``^'').

		ga	Sends the TELNET GA (Go Ahead) sequence, which likely
			has no significance to the remote system.

		getstatus
			If the remote side supports the TELNET STATUS command,
			getstatus will send the subnegotiation to request that
			the server send its current option status.

		ip	Sends the TELNET IP (Interrupt Process) sequence,
			which should cause the remote system to abort the cur-
			rently running process.

		nop	Sends the TELNET NOP (No OPeration) sequence.

		susp	Sends the TELNET SUSP (SUSPend process) sequence.

		synch	Sends the TELNET SYNCH sequence.  This sequence causes
			the remote system to discard all previously typed (but
			not yet read) input.  This sequence is sent as TCP ur-
			gent data (and may not work if the remote system is a
			4.2BSD system -- if it doesn't work, a lower case
			``r'' may be echoed on the terminal).

		do cmd

		dont cmd

		will cmd

		wont cmd
			Sends the TELNET DO cmd sequence.  Cmd can be either a
			decimal number between 0 and 255, or a symbolic name
			for a specific TELNET command.	Cmd can also be either
			help or ? to print out help information, including a
			list of known symbolic names.

		?	Prints out help information for the send command.

     set argument value

     unset argument value
		The set command will set any one of a number of telnet vari-
		ables to a specific value or to TRUE. The special value off
		turns off the function associated with the variable, this is
		equivalent to using the unset command.	The unset command will
		disable or set to FALSE any of the specified functions.  The
		values of variables may be interrogated with the display com-
		mand.  The variables which may be set or unset, but not tog-
		gled, are listed here.	In addition, any of the variables for
		the toggle command may be explicitly set or unset using the
		set and unset commands.

		ayt	If TELNET is in localchars mode, or LINEMODE is en-
			abled, and the status character is typed, a TELNET AYT
			sequence (see send ayt preceding) is sent to the re-
			mote host.  The initial value for the "Are You There"
			character is the terminal's status character.

		echo	This is the value (initially ``^E'') which, when in
			``line by line'' mode, toggles between doing local
			echoing of entered characters (for normal processing),
			and suppressing echoing of entered characters (for en-
			tering, say, a password).

		eof	If telnet is operating in LINEMODE or ``old line by
			line'' mode, entering this character as the first
			character on a line will cause this character to be
			sent to the remote system.  The initial value of the
			eof character is taken to be the terminal's eof char-
			acter.

		erase	If telnet is in localchars mode (see toggle localchars
			below), and if telnet is operating in ``character at a
			time'' mode, then when this character is typed, a
			TELNET EC sequence (see send ec above) is sent to the
			remote system.	The initial value for the erase char-
			acter is taken to be the terminal's erase character.

		escape	This is the telnet escape character (initially ``^['')
			which causes entry into telnet command mode (when con-
			nected to a remote system).

		flushoutput
			If telnet is in localchars mode (see toggle localchars
			below) and the flushoutput character is typed, a
			TELNET AO sequence (see send ao above) is sent to the
			remote host.  The initial value for the flush charac-
			ter is taken to be the terminal's flush character.

		forw1

		forw2	If TELNET is operating in LINEMODE, these are the
			characters that, when typed, cause partial lines to be
			forwarded to the remote system.  The initial value for
			the forwarding characters are taken from the termi-
			nal's eol and eol2 characters.

		interrupt
			If telnet is in localchars mode (see toggle localchars
			below) and the interrupt character is typed, a TELNET
			IP sequence (see send ip above) is sent to the remote
			host.  The initial value for the interrupt character
			is taken to be the terminal's intr character.

		kill	If telnet is in localchars mode (see toggle localchars
			below), and if telnet is operating in ``character at a
			time'' mode, then when this character is typed, a
			TELNET EL sequence (see send el above) is sent to the
			remote system.	The initial value for the kill charac-
			ter is taken to be the terminal's kill character.

		lnext	If telnet is operating in LINEMODE or ``old line by
			line`` mode, then this character is taken to be the
			terminal's lnext character.  The initial value for the
			lnext character is taken to be the terminal's lnext
			character.

		quit	If telnet is in localchars mode (see toggle localchars
			below) and the quit character is typed, a TELNET BRK
			sequence (see send brk above) is sent to the remote
			host.  The initial value for the quit character is
			taken to be the terminal's quit character.

		reprint
			If telnet is operating in LINEMODE or ``old line by
			line`` mode, then this character is taken to be the
			terminal's reprint character.  The initial value for
			the reprint character is taken to be the terminal's
			reprint character.

		rlogin	This is the rlogin escape character.  If set, the nor-
			mal TELNET escape character is ignored unless it is
			preceded by this character at the beginning of a line.
			This character, at the beginning of a line followed by
			a "."  closes the connection; when followed by a ^Z it
			suspends the telnet command.  The initial state is to
			disable the rlogin escape character.

		start	If the TELNET TOGGLE-FLOW-CONTROL option has been en-
			abled, then this character is taken to be the termi-
			nal's start character.	The initial value for the kill
			character is taken to be the terminal's start charac-
			ter.

		stop	If the TELNET TOGGLE-FLOW-CONTROL option has been en-
			abled, then this character is taken to be the termi-
			nal's stop character.  The initial value for the kill
			character is taken to be the terminal's stop charac-
			ter.

		susp	If telnet is in localchars mode, or LINEMODE is en-
			abled, and the suspend character is typed, a TELNET
			SUSP sequence (see send susp above) is sent to the re-
			mote host.  The initial value for the suspend charac-
			ter is taken to be the terminal's suspend character.

		tracefile
			This is the file to which the output, caused by
			netdata or option tracing being TRUE, will be written.
			If it is set to ``-'', then tracing information will
			be written to standard output (the default).

		worderase
			If telnet is operating in LINEMODE or ``old line by
			line`` mode, then this character is taken to be the
			terminal's worderase character.  The initial value for
			the worderase character is taken to be the terminal's
			worderase character.

		?	Displays the legal set (unset) commands.

     slc state	The slc command (Set Local Characters) is used to set or
		change the state of the the special characters when the TELNET
		LINEMODE option has been enabled.  Special characters are
		characters that get mapped to TELNET commands sequences (like
		ip or quit) or line editing characters (like erase and kill).

		By default, the local special characters are exported.

		check	    Verify the current settings for the current spe-
			    cial characters.  The remote side is requested to
			    send all the current special character settings,
			    and if there are any discrepancies with the local
			    side, the local side will switch to the remote
			    value.

		export	    Switch to the local defaults for the special char-
			    acters.  The local default characters are those of
			    the local terminal at the time when telnet was
			    started.

		import	    Switch to the remote defaults for the special
			    characters.  The remote default characters are
			    those of the remote system at the time when the
			    TELNET connection was established.

		?	    Prints out help information for the slc command.

     status	Show the current status of telnet. This includes the peer one
		is connected to, as well as the current mode.

     toggle arguments ...
		Toggle (between TRUE and FALSE) various flags that control how
		telnet responds to events.  These flags may be set explicitly
		to TRUE or FALSE using the set and unset commands listed
		above.	More than one argument may be specified.  The state of
		these flags may be interrogated with the display command.
		Valid arguments are:

		authdebug     Turns on debugging information for the authenti-
			      cation code.

		autoflush     If autoflush and localchars are both TRUE, then
			      when the ao, or quit characters are recognized
			      (and transformed into TELNET sequences; see set
			      above for details), telnet refuses to display
			      any data on the user's terminal until the remote
			      system acknowledges (via a TELNET TIMING MARK
			      option) that it has processed those TELNET se-
			      quences.	The initial value for this toggle is
			      TRUE if the terminal user had not done an "stty
			      noflsh", otherwise FALSE (see stty(1)).

		autodecrypt   When the TELNET ENCRYPT option is negotiated, by
			      default the actual encryption (decryption) of
			      the data stream does not start automatically.
			      The autoencrypt (autodecrypt) command states
			      that encryption of the output (input) stream
			      should be enabled as soon as possible.

			      Note:  Because of export controls, the TELNET
			      ENCRYPT option is not supported outside the
			      United States and Canada.

		autologin     If the remote side supports the TELNET
			      AUTHENTICATION option TELNET attempts to use it
			      to perform automatic authentication.  If the
			      AUTHENTICATION option is not supported, the us-
			      er's login name are propagated through the
			      TELNET ENVIRON option.  This command is the same

			      as specifying a option on the open command.

		autosynch     If autosynch and localchars are both TRUE, then
			      when either the intr or quit characters is typed
			      (see set above for descriptions of the intr and
			      quit characters), the resulting TELNET sequence
			      sent is followed by the TELNET SYNCH sequence.
			      This procedure should cause the remote system to
			      begin throwing away all previously typed input
			      until both of the TELNET sequences have been
			      read and acted upon.  The initial value of this
			      toggle is FALSE.

		binary	      Enable or disable the TELNET BINARY option on
			      both input and output.

		inbinary      Enable or disable the TELNET BINARY option on
			      input.

		outbinary     Enable or disable the TELNET BINARY option on
			      output.

		crlf	      If this is TRUE, then carriage returns will be
			      sent as <CR><LF>. If this is FALSE, then car-
			      riage returns will be send as <CR><NUL>. The
			      initial value for this toggle is FALSE.

		crmod	      Toggle carriage return mode.  When this mode is
			      enabled, most carriage return characters re-
			      ceived from the remote host will be mapped into
			      a carriage return followed by a line feed.  This
			      mode does not affect those characters typed by
			      the user, only those received from the remote
			      host.  This mode is not very useful unless the
			      remote host only sends carriage return, but nev-
			      er line feed.  The initial value for this toggle
			      is FALSE.

		debug	      Toggles socket level debugging (useful only to
			      the super user). The initial value for this tog-
			      gle is FALSE.

		encdebug      Turns on debugging information for the encryp-
			      tion code.

		localchars    If this is TRUE, then the flush, interrupt,
			      quit, erase, and kill characters (see set above)
			      are recognized locally, and transformed into
			      (hopefully) appropriate TELNET control sequences
			      (respectively ao, ip, brk, ec, and el; see send
			      above).  The initial value for this toggle is
			      TRUE in ``old line by line'' mode, and FALSE in
			      ``character at a time'' mode.  When the LINEMODE
			      option is enabled, the value of localchars is
			      ignored, and assumed to always be TRUE. If
			      LINEMODE has ever been enabled, then quit is
			      sent as abort, and eof and are sent as eof and
			      susp, see send above).

		netdata       Toggles the display of all network data (in hex-
			      adecimal format).  The initial value for this
			      toggle is FALSE.

		options       Toggles the display of some internal telnet pro-
			      tocol processing (having to do with TELNET op-
			      tions).  The initial value for this toggle is

			      FALSE.

		prettydump    When the netdata toggle is enabled, if
			      prettydump is enabled the output from the
			      netdata command will be formatted in a more user
			      readable format.	Spaces are put between each
			      character in the output, and the beginning of
			      any TELNET escape sequence is preceded by a '*'
			      to aid in locating them.

		skiprc	      When the skiprc toggle is TRUE, TELNET skips the
			      reading of the .telnetrc file in the users home
			      directory when connections are opened.  The ini-
			      tial value for this toggle is FALSE.

		termdata      Toggles the display of all terminal data (in
			      hexadecimal format).  The initial value for this
			      toggle is FALSE.

		verbose_encrypt
			      When the verbose_encrypt toggle is TRUE, TELNET
			      prints out a message each time encryption is en-
			      abled or disabled.  The initial value for this
			      toggle is FALSE. Note:  Because of export con-
			      trols, data encryption is not supported outside
			      of the United States and Canada.

		?	      Displays the legal toggle commands.

     z		Suspend telnet. This command only works when the user is using
		the csh(1).

     ! [command]
		Execute a single command in a subshell on the local system.
		If command is omitted, then an interactive subshell is in-
		voked.

     ? [command]
		Get help.  With no arguments, telnet prints a help summary.
		If a command is specified, telnet will print the help informa-
		tion for just that command.

ENVIRONMENT
     Telnet uses at least the HOME, SHELL, DISPLAY, and TERM environment vari-
     ables.  Other environment variables may be propagated to the other side
     via the TELNET ENVIRON option.

FILES
     ~/.telnetrc  user customized telnet startup values

HISTORY
     The Telnet command appeared in 4.2BSD.

NOTES
     On some remote systems, echo has to be turned off manually when in ``old
     line by line'' mode.

     In ``old line by line'' mode or LINEMODE the terminal's eof character is
     only recognized (and sent to the remote system) when it is the first
     character on a line.

4.2 Berkeley Distribution	 June 1, 1994				    11
