#  $Id: 2um-dvi.pl 0.04 1996/06/26 00:00:04 tom Exp $
#
#  2um-dvi.pl:  Very simple and silly `Perl' script for converting
#                 "a "o "u "s "A "O "U  character sequences found
#                 in the German `gcal.texi' file to sequences, the
#                 TeX formatter should be able to typeset as German
#                 "Umlaute" characters.
#
#
#  Public domain.
#

$[ = 1;			# set array base to 1
$, = ' ';		# set output field separator
$\ = "\n";		# set output record separator

line: while (<>) {
    chop;	# strip record separator
    if (/\@chapter|\@section|\@subsection|\@subsubsection/) {
	$len = length($_);
	$tmptxt = '';
	if ($_ =~ /"/) {
	    $found = 0;
	    for ($i = 1; $i <= $len; $i++) {
		$tmpchr = substr($_, $i, 1);
		if ($tmpchr eq '"') {
		    if ($found == 1) {
			$found = 0;
			$tmptxt = $tmptxt . $tmpchr . $tmpchr;
		    }
		    else {
			$found = 1;
		    }
		}
		else {
		    if ($found == 1) {
			$found = 0;
			if ($tmpchr eq 'a') {
			    $tmptxt = $tmptxt . 'ae';
			}
			else {
			    if ($tmpchr eq 'o') {
				$tmptxt = $tmptxt . 'oe';
			    }
			    else {
				if ($tmpchr eq 'u') {
				    $tmptxt = $tmptxt . 'ue';
				}
				else {
				    if ($tmpchr eq 's') {
					$tmptxt = $tmptxt . 'ss';
				    }
				    else {
					if ($tmpchr eq 'A') {
					    $tmptxt = $tmptxt . 'Ae';
					}
					else {
					    if ($tmpchr eq 'O') {
						$tmptxt = $tmptxt . 'Oe';
					    }
					    else {
						if ($tmpchr eq 'U') {
						    $tmptxt = $tmptxt . 'Ue';
						}
						else {
						    $tmptxt = $tmptxt . "\"" .
						      $tmpchr;
						}
					    }
					}
				    }
				}
			    }
			}
		    }
		    else {
			$tmptxt = $tmptxt . $tmpchr;
		    }
		}
	    }
	    if ($found == 1) {
		print $tmptxt . $tmpchr;
	    }
	    else {
		print $tmptxt;
	    }
	}
	else {
	    print $_;
	}
	next line;
    }

#
# Main block.
#

    $len = length($_);
    $tmptxt = '';
    if ($_ =~ /"/) {
	$found = 0;
	for ($i = 1; $i <= $len; $i++) {
	    $tmpchr = substr($_, $i, 1);
	    if ($tmpchr eq '"') {
		if ($found == 1) {
		    $found = 0;
		    $tmptxt = $tmptxt . $tmpchr . $tmpchr;
		}
		else {
		    $found = 1;
		}
	    }
	    else {
		if ($found == 1) {
		    $found = 0;
		    if ($tmpchr eq 'a') {
			$tmptxt = $tmptxt . "@\"a";
		    }
		    else {
			if ($tmpchr eq 'o') {
			    $tmptxt = $tmptxt . "@\"o";
			}
			else {
			    if ($tmpchr eq 'u') {
				$tmptxt = $tmptxt . "@\"u";
			    }
			    else {
				if ($tmpchr eq 's') {
				    if ($i == $len) {
					$tmptxt = $tmptxt . '@ss ';
				    }
				    else {
					if (substr($_, $i+1, 1) eq ' ') {
					    $tmptxt = $tmptxt . '@ss@ ';
					}
					else {
					    $tmptxt = $tmptxt . '@ss ';
					}
				    }
				}
				else {
				    if ($tmpchr eq 'A') {
					$tmptxt = $tmptxt . "@\"A";
				    }
				    else {
					if ($tmpchr eq 'O') {
					    $tmptxt = $tmptxt . "@\"O";
					}
					else {
					    if ($tmpchr eq 'U') {
						$tmptxt = $tmptxt . "@\"U";
					    }
					    else {
						$tmptxt = $tmptxt . "\"" .
						  $tmpchr;
					    }
					}
				    }
				}
			    }
			}
		    }
		}
		else {
		    $tmptxt = $tmptxt . $tmpchr;
		}
	    }
	}
	if ($found == 1) {
	    print $tmptxt . $tmpchr;
	}
	else {
	    print $tmptxt;
	}
    }
    else {
	print $_;
    }
}
