(* A Simple File abstraction layer *)
(*                                 *)
(* Next implementations should     *)
(* support buffered IO or memory-  *)
(* mapped files                    *)

Unit TTFile;

interface

uses TTTypes, TTError;


function Open_Font_File( AName : String ) : boolean;

function Read_Font_File( var ABuff; ACount : Int ) : boolean;

function Read_8( var C : Byte ): boolean;

function Read_16( var S : Short ): boolean;

function Read_32( var L : Long ): boolean;

function Seek_Font_File( APos : LongInt ) : boolean;

function Skip_Font_File( ADist : LongInt ) : boolean;

function Read_At_Font_File( APos : Long; var ABuff; ACount : Int ) : boolean;

procedure Close_Font_File;

implementation

uses TTCalc;

{$IFDEF OS2}

var
  Font_File : FILE;
  Font_Buff : PByteArray;
  Font_Size : Long;
  Font_Pos  : Long;

function Open_Font_File( AName : String ) : boolean;
begin
  Open_Font_File := False;

  Assign( Font_File, AName );
  {$I-}
  Reset( Font_File, 1 );
  {$I+}
  if IOResult <> 0 then
    begin
      Error := TT_ErrMsg_File_Error;
      exit;
    end;

  Font_Size := FileSize( Font_File );
  Font_Buff := nil;
  Font_Pos  := 0;

  GetMem( Font_Buff, Font_Size );

  if Font_Buff <> nil then
    begin
      {$I-}
      BlockRead( Font_File, Font_Buff^, Font_Size );
      {$I+}
      Open_Font_File := ( IOResult = 0 );
      exit;
    end;

  Open_Font_File := False;

end;


function Seek_Font_File( APos : LongInt ) : boolean;
begin
  if (APos < 0) or (APos>=Font_Size) then

    Seek_Font_File := False

  else
   begin
    Font_Pos	   := APos;
    Seek_Font_File := True;
   end;

end;


function Skip_Font_File( ADist : LongInt ) : boolean;
begin
  Skip_Font_File := Seek_Font_File( Font_Pos + ADist );
end;

function Read_Font_File( var ABuff; ACount : Int ) : boolean;
begin
  if Font_Pos + ACount <= Font_Size then

    begin
      move( Font_Buff^[Font_Pos], ABuff, ACount );
      inc( Font_Pos, ACount );
      Read_Font_File := True;
    end

  else
    Read_Font_File := False;

end;


function Read_At_Font_File( APos : Long; var ABuff; ACount : Int ) : boolean;
begin
  Read_At_Font_File := False;

  if not Seek_Font_File( APos ) or
     not Read_Font_File( ABuff, ACount ) then exit;

  Read_At_Font_File := True;
end;


function Read_8( var C : byte ): boolean;
begin
  if Font_Pos < Font_Size then
    begin
      Read_8 := True;
      C      := Font_Buff^[Font_Pos];
      inc( Font_Pos );
    end
  else
    Read_8 := False;
end;


function Read_16( var S : Short ) : boolean;
begin
  if Font_Pos + 1 < Font_Size then

    begin
      Read_16 := True;
      S       := PShort( @Font_Buff^[Font_Pos] )^;
      Do16( S );
      inc( Font_Pos, 2 );
    end

  else
    Read_16 := False;
end;


function Read_32( var L : Long ) : boolean;
begin
  if Font_Pos + 3 < Font_Size then

    begin
      Read_32 := True;
      L       := PLong( @Font_Buff^[Font_Pos] )^;
      Do32( L );
      inc( Font_Pos, 4 );
    end

  else
    Read_32 := False;
end;


procedure Close_Font_File;
begin
  FreeMem( Font_Buff, Font_Size );
  Font_Buff := nil;
  Font_Size := 0;
  Font_Pos  := 0;
  Close( Font_File );
end;

{$ELSE}

var
  Font_File : FILE;


function Open_Font_File( AName : String ) : boolean;
begin
  Open_Font_File := False;

  Assign( Font_File, AName );
  {$I-}
  Reset( Font_File, 1 );
  {$I+}
  if IOResult <> 0 then
    begin
      Error := TT_ErrMsg_File_Error;
      exit;
    end;

  Open_Font_File := True;
end;


function Seek_Font_File( APos : LongInt ) : boolean;
begin
  {$I-}
  Seek( Font_File, APos );
  {$I+}
  if IOResult <> 0 then
    begin
      Error          := TT_ErrMsg_File_Error;
      Seek_FOnt_File := False;
      exit;
    end;

  Seek_Font_File := True;
end;

function Skip_Font_File( ADist : LongInt ) : boolean;
begin
  Skip_Font_File := Seek_Font_File( FilePos(Font_File)+ADist );
end;

function Read_Font_File( var ABuff; ACount : Int ) : boolean;
begin
  Read_Font_File := False;
  {$I-}
  BlockRead( Font_File, ABuff, ACount );
  {$I+}

  if IOResult <> 0 then
    begin
      Error := TT_ErrMsg_File_Error;
      exit;
    end;

  Read_Font_File := True;
end;

function Read_At_Font_File( APos : Long; var ABuff; ACount : Int ) : boolean;
begin
  Read_At_Font_File := False;

  if not Seek_Font_File( APos ) or
     not Read_Font_File( ABuff, ACount ) then exit;

  Read_At_Font_File := True;
end;

function Read_8( var C : byte ): boolean;
begin
  Read_8 := Read_Font_File( C, 1 );
end;

function Read_16( var S : Short ) : boolean;
begin
  Read_16 := Read_Font_File( S, 2 );
  Do16(S);
end;

procedure Close_Font_File;
begin
  Close( Font_File );
end;

function Read_32( var L : Long ) : boolean;
begin
  Read_32 := Read_Font_File( L, 4 );
  Do32(L);
end;

{$ENDIF}

end.