(* This unit is only used to display fonts in 640x480x16 graphics mode *)
(* under both DOS and OS/2. It is only used by the programs            *)
(* 'TESTTIME' and 'TTZOOM'                                             *)
(* It is not part of the engine itself                                 *)

Unit TTDisp;

interface

uses TTTypes;

procedure SetGraphScreen;

procedure RestoreScreen;

procedure Display( var Buff; Line, Col : Int );

procedure Clear( Line, Col : Int );

var
  Vio : PByteArray;

implementation

{$IFDEF OS2}

  uses Os2Base, Use32;

  {$IFDEF DYNAMIC_VERSION}
    {$Dynamic System}
    {$L VPRTL.LIB}
  {$ENDIF}

  type
    Ptr16Rec = record
      Ofs,Sel: SmallWord;
    end;

  var
    OrgMode   : VioModeInfo;
    VioBufOfs : Longint;
    Status    : SmallWord;

  { BIOS Video Mode #13 }

  const
    VioMode: VioModeInfo =
     ( cb:     SizeOf(VioModeInfo);
       fbType: vgmt_Other + vgmt_Graphics;
       Color:  colors_16;
       Col:    80;
       Row:    35;
       HRes:   640;
       VRes:   480
     );

    VioBuf: VioPhysBuf =
     ( pBuf: Ptr($A0000);
       cb:   64*1024
     );

  { Restores screen to the original state }

  procedure RestoreScreen;
  begin
    VioSetMode(OrgMode, 0);
  end;

  procedure SetGraphScreen;
  begin
    { Save original video mode }
    OrgMode.cb := SizeOf(VioModeInfo);
    VioGetMode(OrgMode, 0);

    { Set VGA 640x400x16 video mode }
    if VioSetMode(VioMode, 0) <> 0 then Halt(5);

    { Get selector for physical video buffer }
    if VioGetPhysBuf(VioBuf, 0) <> 0 then Halt(7);

    { Make flat pointer that points to the physical video buffer}
    Ptr16Rec(VioBufOfs).Ofs := 0;
    Ptr16Rec(VioBufOfs).Sel := VioBuf.Sel;
    SelToFlat(Pointer(VioBufOfs));

    { Clear the screen. Unlike function 0 of the BIOS INT 10h }
    { VioSetMode doesn't clear the screen.                    }
    FillChar(Pointer(VioBufOfs)^,64*1024,0);
    Vio := PByteArray(VioBufOfs);
  end;

  procedure Display; assembler;
  asm
    push esi
    push edi
    push ebx
    push ecx

    mov esi,[Buff]

    mov ecx,80
    mov ebx,[Col]
    mov eax,[Line]
    dec eax
    mul ecx

    mov edi,[VioBufOfs]
    add edi,eax

    mov edx,[line]
    add ebx,80
   @1:
    mov ecx,[col]
    rep movsb
    sub edi,ebx
    dec edx
    jnz @1

    pop ecx
    pop ebx
    pop edi
    pop esi
  end;

  procedure Clear; assembler;
  asm
    push edi
    push ebx
    push ecx
    push ebp

    mov ecx,80
    mov ebx,[Col]
    mov eax,[Line]
    dec eax
    mul ecx

    mov edi,[VioBufOfs]
    add edi,eax

    mov edx,[line]
    mov ebp,ebx
    add ebx,80
    xor eax,eax
   @1:
    mov ecx,ebp
   @2:
    mov [edi],al
    inc edi
    dec cx
    jnz @2
    sub edi,ebx
    dec dx
    jnz @1

    pop ebp
    pop ecx
    pop ebx
    pop edi
    pop esi
  end;

{$ELSE}

  procedure SetGraphScreen;
  begin
    asm
      mov ax,$0012
      int $10
    end;
    Vio := PByteArray( @Mem[$A000:0] );
  end;

  procedure RestoreScreen; assembler;
  asm
    mov ax,$0003
    int $10
  end;

  procedure Display; assembler;
  asm
    push ds
    push bp

    mov ax,$A000
    mov es,ax

    lds si,[Buff]

    cld

    mov cx,80
    mov bx,[col]
    mov ax,[line]
    dec ax
    mul cx
    mov di,ax
    mov dx,[line]
    mov bp,bx
    add bx,80
   @1:
    mov cx,bp
    rep movsb
    sub di,bx
    dec dx
    jnz @1

    pop bp
    pop ds
  end;

  procedure Clear; assembler;
  asm
    push ds
    push bp

    mov ax,$A000
    mov es,ax

    cld

    mov cx,80
    mov bx,[col]
    mov ax,[line]
    dec ax
    mul cx
    mov di,ax
    mov dx,[line]
    mov bp,bx
    add bx,80
    xor al,al
   @1:
    mov cx,bp
    rep stosb
    sub di,bx
    dec dx
    jnz @1

    pop bp
    pop ds
  end;

{$ENDIF}

begin
end.

