/* sigsegv.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>

static jmp_buf jchk;
static int dummy1;


void cb_handler (int sig)
{
#if defined (__EMX__)
  signal (sig, SIG_ACK);
#endif
  longjmp (jchk, 1);
}


size_t check_buffer (void *ptr, size_t size)
{
  void (*oldsig)(int sig);
  size_t volatile result;
  char *p;
  volatile char c;

  oldsig = signal (SIGSEGV, cb_handler);
  p = ptr;
  result = 0;
  if (setjmp (jchk) == 0)
    while (size != 0)
      {
        c = *p++;
        ++result; --size;
      }
  signal (SIGSEGV, oldsig);
  return result;
}


static void check (void *p)
{
  size_t size;

  printf ("0x%.8x: ", (unsigned)p);
  size = check_buffer (p, 0x10000);
  if (size == 0x10000)
    printf ("at least 0x10000 bytes\n");
  else
    printf ("0x%lx bytes\n", size);
}


int main (void)
{
  int dummy2;

  check ((void *)0);
  check ((void *)0x10000);
  check ((void *)main);
  check (&dummy1);
  check (&dummy2);
  return 0;
}
