/* procbuf.cc */

#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <procbuf.h>


static void usage ()
{
  cout << "Usage: procbuf -i <command>\n";
  cout << "       procbuf -o <command>\n";
  exit (1);
}


static void input (const char *command)
{
  procbuf pb;
  pb.open (command, ios::in);
  istream in (&pb);
  char ch;
  bool sol = true;
  int line = 1;
  while (in.get (ch))
    {
      if (sol)
        cout << setw (4) << line++ << ": ";
      cout.put (ch);
      sol = ch == '\n';
    }
  pb.close ();
}


static void output (const char *command)
{
  procbuf pb;
  pb.open (command, ios::out);
  ostream out (&pb);
  out << "one\n";
  out << "two\n";
  out << "three\n";
  out << "four\n";
  out << "five\n";
  out << "six\n";
  out << "seven\n";
  pb.close ();
}

int main (int argc, char *argv[])
{
  if (argc != 3)
    usage ();
  if (strcmp (argv[1], "-i") == 0)
    input (argv[2]);
  else if (strcmp (argv[1], "-o") == 0)
    output (argv[2]);
  else
    usage ();
  cout << "(Done.)\n";
  return 0;
}
