/* mtsock.c (emx+gcc) */

/* Test mutex semaphore of __open and __socket in emx.dll.  Up to
   revision index 33 of emx.dll, one of the socket() calls blocks. */

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <unistd.h>
#include <fcntl.h>
#include <io.h>
#include <sys/types.h>
#include <sys/socket.h>

static void thread (void *arg)
{
  int tid, fd, i;
#ifdef VERBOSE
  char buf[100];
#endif

  tid = *_threadid;
  for (i = 1; i < 20; ++i)
    {
#ifdef VERBOSE
      sprintf (buf, "%d: calling open()\n", tid);
      write (1, buf, strlen (buf));
#endif
      fd = open ("nul", O_RDONLY);
#ifdef VERBOSE
      sprintf (buf, "%d: open() returned %d\n", tid, fd);
      write (1, buf, strlen (buf));
#endif
      if (fd > 0)
        close (fd);
      _sleep2 (100);
    }
}


int main (void)
{
  int s, i;

  _beginthread (thread, NULL, 0x8000, NULL);
  sleep (1);
  for (i = 1; i < 50; ++i)
    {
      printf ("%d: calling socket()\n", 1);
      s = socket (AF_INET, SOCK_STREAM, 0);
      printf ("%d: socket() returned %d\n", 1, s);
      _sleep2 (100);
    }
  return 0;
}
