/* fnmtest.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fnmatch.h>


static void regression (void)
{
  unsigned char mask[256];
  unsigned char name[256];
  unsigned flags;
  int match, line, err;

  line = 0; err = 0;
  for (;;)
    {
      ++line;
      if (scanf ("%i %s %s %d\n", &flags, mask, name, &match) != 4)
        {
          if (feof (stdin))
            break;
          fprintf (stderr, "Input error in line %d\n", line);
          exit (1);
        }
      if (fnmatch (mask, name, flags) != match)
        {
          printf ("Incorrect result for line %d\n", line);
          ++err;
        }
    }
  printf ("Lines:  %d\n", line - 1);
  printf ("Errors: %d\n", err);
  exit (err == 0 ? 0 : 1);
}


int main (int argc, char *argv[])
{
  if (argc == 5 && strcmp (argv[1], "-t") == 0)
    printf ("%d\n", fnmatch (argv[3], argv[4], strtol (argv[2], NULL, 0)));
  else if (argc == 2 && strcmp (argv[1], "-r") == 0)
    regression ();
  else
    {
      puts ("Usage: fnmatch -r <datafile");
      puts ("       fnmatch -t <flags> <mask> <name>");
      return 1;
    }
  return 0;
}
