/* vgetline.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

void v_getline (char *dst, int x, int y, int count)
{
  if (count > 0)
    {
#if defined (IF_OS2)
      IF_OS2
        {
          USHORT len;

          len = (USHORT)(count * 2);
          VioReadCellStr (dst, &len, (USHORT)y, (USHORT)x, 0);
        }
#endif
#if defined (IF_DOS)
      IF_DOS
        {
          union REGS r;
          int i;

          if (_v_mem != NULL)
            memcpy (dst, _v_mem + (y * _v_width + x) * 2, (size_t)(count * 2));
          else
            {
              for (i = 0; i < count; ++i)
                {
                  r.h.ah = 0x02;
                  r.h.bh = 0;
                  r.h.dl = x + i;
                  r.h.dh = y;
                  _int86 (0x10, &r, &r);
                  r.h.ah = 0x08;
                  _int86 (0x10, &r, &r);
                  dst[0] = r.h.al;
                  dst[1] = r.h.ah;
                  dst += 2;
                }
              r.h.ah = 0x02;
              r.h.bh = 0x00;
              r.h.dl = (unsigned char)_v_x;
              r.h.dh = (unsigned char)_v_y;
              _int86 (0x10, &r, &r);
            }
        }
#endif
    }
}
