/* sys/nls_ctyp.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#define INCL_DOSNLS
#include <os2emx.h>
#include <sys/nls.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __nls_ctype (unsigned char *buf)
{
  ULONG rc;
  COUNTRYCODE cc;
  BYTE lead[12];
  unsigned i, j;

  /* Get DBCS lead bytes. */

  cc.country = 0;
  cc.codepage = 0;
  rc = DosQueryDBCSEnv (sizeof (lead), &cc, (PCHAR)lead);
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return -1;
    }

  /* Clear _NLS_DBCS_LEAD for all bytes. */

  for (j = 0; j < 256; ++j)
    buf[j] &= ~_NLS_DBCS_LEAD;

  /* Set _NLS_DBCS_LEAD for DBCS lead bytes. */

  for (i = 0; i <= sizeof (lead) - 2; i += 2)
    {
      if (lead[i+0] == 0 && lead[i+1] == 0)
        break;
      for (j = lead[i+0]; j <= lead[i+1]; ++j)
        buf[j] |= _NLS_DBCS_LEAD;
    }
  return 0;
}
