/* dbcsctype.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/nls.h>
#include <emx/locale.h>
#include <emx/nls.h>
#include <emx/syscalls.h>
#include <emx/startup.h>

unsigned char _nls_ctype_tab[256] = {0};

/* Initialize table identifying DBCS lead bytes. */

void _nls_ctype_init (void)
{
  int i;

  __nls_ctype (_nls_ctype_tab);

  /* Switch multibyte character processing to DBCS If there's at least
     one DBCS lead byte. */

  for (i = 0; i < 256; ++i)
    if (_nls_is_dbcs_lead (i))
      break;
  if (i < 256)
    _cur_mbyte.mode = _MB_DBCS;
}

_CRT_INIT1 (_nls_ctype_init)
