/* defexpan.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <stdlib.h>
#include <stddef.h>
#include <umalloc.h>
#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <emx/umalloc.h>

int _um_default_expand (Heap_t h, void *base, size_t old_size,
                        size_t *new_size, int *clean)
{
  void *p;
  size_t n;

  if (_UM_ADD (base, old_size) != _sbrk (0))
    return 0;
  n = (*new_size - old_size + 0xffff) & ~0xffff;
  p = _sbrk (n);
  if (p == (void *)-1)
    {
      n = *new_size - old_size;
      p = _sbrk (n);
      if (p == (void *)-1)
        return 0;
    }
  if (p != _UM_ADD (base, old_size))
    {
      _sbrk (-n);
      return 0;
    }
  *new_size = old_size + n; *clean = !_BLOCK_CLEAN;
  return 1;
}
