//
// $Header: D:/32bits/ext2-os2/include/os2/RCS/DevHlp32.h,v 1.2 1996/09/17 22:16:52 Willm Exp Willm $
//

// 32 bits OS/2 device driver and IFS support driver. Provides 32 bits kernel 
// services (DevHelp) and utility functions to 32 bits OS/2 ring 0 code 
// (device drivers and installable file system drivers).
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __DevHlp32_h
#define __DevHlp32_h


#ifndef __infoseg_h
#define __infoseg_h
#include <infoseg.h>
#endif

#ifdef __IBMC__
#include <stdarg.h>
#else
typedef char *va_list;
#endif


struct PageList {
    unsigned long physaddr;
    unsigned long size;
};


extern struct DevHelp32 DevHelp32;

#define DEVHELP32_MAGIC 0xDF3C4E07
#define DEVHELP32_VERSION 4

struct DevHelp32 {
    unsigned long magic;
    unsigned long version;
    union {
        struct {
            int  (*DH32ENTRY DevHlp32_SaveMessage)(char *, int);
            void (*DH32ENTRY DevHlp32_InternalError)(char *, int);
            int  (*DH32ENTRY DevHlp32_VMAlloc)(unsigned long, unsigned long, unsigned long, void **);
            int  (*_Optlink  DevHlp32_VMFree)(void *);
            int  (*DH32ENTRY DevHlp32_VMLock)(unsigned long, void *, unsigned long, void *, void *, unsigned long *);
            int  (*DH32ENTRY DevHlp32_VMUnlock)(void *);
            int  (*DH32ENTRY DevHlp32_VirtToLin)(PTR16, void **);
            int  (*DH32ENTRY DevHlp32_ProcBlock)(unsigned long, long, short);
            int  (*DH32ENTRY DevHlp32_ProcRun)(unsigned long);
            int  (*DH32ENTRY DevHlp32_LinToPageList)(void *, unsigned long, struct PageList *, unsigned long *);
            int  (*DH32ENTRY DevHlp32_Security)(unsigned long, void *);
            void (*DH32ENTRY DevHlp32_Yield)(void);
            int  (*DH32ENTRY DevHlp32_GetInfoSegs)(struct InfoSegGDT **, struct InfoSegLDT **);
            int           (*DH32ENTRY vsprintf)(char *, const char *, va_list);
            unsigned long (*DH32ENTRY strtoul) (const char *, char **, int);
            long          (*DH32ENTRY atol) (const char *);
            char *        (*DH32ENTRY strupr) (char *s);
            char *        (*DH32ENTRY strpbrk) (const char *, const char *);
            int           (*DH32ENTRY fnmatch) (const char *, const char *, int);
            long          (*DH32ENTRY strtol) (const char *, char **, int);
	    int (*DH32ENTRY sec32_attach_ses)(void *);
        } version_4;
        struct {
            int  (*DH32ENTRY DevHlp32_SaveMessage)(char *, int);
            void (*DH32ENTRY DevHlp32_InternalError)(char *, int);
            int  (*DH32ENTRY DevHlp32_VMAlloc)(unsigned long, unsigned long, unsigned long, void **);
            int  (*_Optlink  DevHlp32_VMFree)(void *);
            int  (*DH32ENTRY DevHlp32_VMLock)(unsigned long, void *, unsigned long, void *, void *, unsigned long *);
            int  (*DH32ENTRY DevHlp32_VMUnlock)(void *);
            int  (*DH32ENTRY DevHlp32_VirtToLin)(PTR16, void **);
            int  (*DH32ENTRY DevHlp32_ProcBlock)(unsigned long, long, short);
            int  (*DH32ENTRY DevHlp32_ProcRun)(unsigned long);
            int  (*DH32ENTRY DevHlp32_LinToPageList)(void *, unsigned long, struct PageList *, unsigned long *);
            int  (*DH32ENTRY DevHlp32_Security)(unsigned long, void *);
            void (*DH32ENTRY DevHlp32_Yield)(void);
            int  (*DH32ENTRY DevHlp32_GetInfoSegs)(struct InfoSegGDT **, struct InfoSegLDT **);
            int           (*DH32ENTRY vsprintf)(char *, const char *, va_list);
            unsigned long (*DH32ENTRY strtoul) (const char *, char **, int);
            long          (*DH32ENTRY atol) (const char *);
            char *        (*DH32ENTRY strupr) (char *s);
            char *        (*DH32ENTRY strpbrk) (const char *, const char *);
            int           (*DH32ENTRY fnmatch) (const char *, const char *, int);
            long          (*DH32ENTRY strtol) (const char *, char **, int);
        } version_3;
        struct {
            int  (*DH32ENTRY DevHlp32_SaveMessage)(char *, int);
            void (*DH32ENTRY DevHlp32_InternalError)(char *, int);
            int  (*DH32ENTRY DevHlp32_VMAlloc)(unsigned long, unsigned long, unsigned long, void **);
            int  (*_Optlink  DevHlp32_VMFree)(void *);
            int  (*DH32ENTRY DevHlp32_VMLock)(unsigned long, void *, unsigned long, void *, void *, unsigned long *);
            int  (*DH32ENTRY DevHlp32_VMUnlock)(void *);
            int  (*DH32ENTRY DevHlp32_VirtToLin)(PTR16, void **);
            int  (*DH32ENTRY DevHlp32_ProcBlock)(unsigned long, long, short);
            int  (*DH32ENTRY DevHlp32_ProcRun)(unsigned long);
            int  (*DH32ENTRY DevHlp32_LinToPageList)(void *, unsigned long, struct PageList *, unsigned long *);
            int  (*DH32ENTRY DevHlp32_Security)(unsigned long, void *);
            void (*DH32ENTRY DevHlp32_Yield)(void);
            int  (*DH32ENTRY DevHlp32_GetInfoSegs)(struct InfoSegGDT **, struct InfoSegLDT **);
            int           (*DH32ENTRY vsprintf)(char *, const char *, va_list);
            unsigned long (*DH32ENTRY strtoul) (const char *, char **, int);
            long          (*DH32ENTRY atol) (const char *);
            char *        (*DH32ENTRY strupr) (char *s);
            char *        (*DH32ENTRY strpbrk) (const char *, const char *);
            int           (*DH32ENTRY fnmatch) (const char *, const char *, int);
        } version_2;
        struct {
            int  (*DH32ENTRY DevHlp32_SaveMessage)(char *, int);
            void (*DH32ENTRY DevHlp32_InternalError)(char *, int);
            int  (*DH32ENTRY DevHlp32_VMAlloc)(unsigned long, unsigned long, unsigned long, void **);
            int  (*_Optlink  DevHlp32_VMFree)(void *);
            int  (*DH32ENTRY DevHlp32_VMLock)(unsigned long, void *, unsigned long, void *, void *, unsigned long *);
            int  (*DH32ENTRY DevHlp32_VMUnlock)(void *);
            int  (*DH32ENTRY DevHlp32_VirtToLin)(PTR16, void **);
            int  (*DH32ENTRY DevHlp32_ProcBlock)(unsigned long, long, short);
            int  (*DH32ENTRY DevHlp32_ProcRun)(unsigned long);
            int  (*DH32ENTRY DevHlp32_LinToPageList)(void *, unsigned long, struct PageList *, unsigned long *);
            int  (*DH32ENTRY DevHlp32_Security)(unsigned long, void *);
            void (*DH32ENTRY DevHlp32_Yield)(void);
        } version_1;
    };
};

/*
 * os2/types.h must be included before this file
 */

#define VMDHL_WRITE             0x0008
#define VMDHL_LONG              0x0010
#define VMDHL_VERIFY            0x0020

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY DevHlp32_VMLock(                                                             
                                     unsigned long   flags,
                                     void           *addr,
                                     unsigned long   length,
                                     void           *pPageList,
                                     void           *pLockHandle,
                                     unsigned long *pPageListCount
                                    ) {
    return DevHelp32.version_1.DevHlp32_VMLock(flags, addr, length, pPageList, pLockHandle, pPageListCount);
}
#else                                                   
extern int DH32ENTRY DevHlp32_VMLock(                                                             
            unsigned long   flags,
            void           *addr,
            unsigned long   length,
            void           *pPageList,
            void           *pLockHandle,
            unsigned long *pPageListCount
           );                                                            
#endif

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY DevHlp32_VMUnlock(
                                       void *pLockHandle   /* ebp + 8 */
                                      ) {
    return DevHelp32.version_1.DevHlp32_VMUnlock(pLockHandle);
}
#else
extern int DH32ENTRY DevHlp32_VMUnlock(
                                       void *pLockHandle   /* ebp + 8 */
                                      );
#endif

#define VMDHA_16M               0x0001 
#define VMDHA_FIXED             0x0002
#define VMDHA_SWAP              0x0004
#define VMDHA_CONTIG            0x0008
#define VMDHA_PHYS              0x0010
#define VMDHA_PROCESS           0x0020
#define VMDHA_SGSCONT           0x0040
#define VMDHA_RESERVE           0x0100
#define VMDHA_USEHIGHMEM        0x0800

#define VMDHA_NOPHYSADDR        0xFFFFFFFF

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY DevHlp32_VMAlloc(
                                      unsigned long  Length,      /* ebp + 8  */
                                      unsigned long  PhysAddr,    /* ebp + 12 */
                                      unsigned long  Flags,       /* ebp + 16 */
                                      void         **LinAddr      /* ebp + 20 */
                                     ) {
    return DevHelp32.version_1.DevHlp32_VMAlloc(Length, PhysAddr, Flags, LinAddr);
}
#else
extern int DH32ENTRY DevHlp32_VMAlloc(
                                      unsigned long  Length,      /* ebp + 8  */
                                      unsigned long  PhysAddr,    /* ebp + 12 */
                                      unsigned long  Flags,       /* ebp + 16 */
                                      void         **LinAddr      /* ebp + 20 */
                                     );
#endif

#ifdef DYNAMIC_DEVHELP
INLINE int _Optlink DevHlp32_VMFree(
                                    void *addr        /* eax */
                                   ) {
    return DevHelp32.version_1.DevHlp32_VMFree(addr);
}
#else
extern int _Optlink DevHlp32_VMFree(
                                    void *addr        /* eax */
                                   );
#endif

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY DevHlp32_VirtToLin(
                                        PTR16  virt, // [ebp + 8]
                                        void **plin  // [ebp + 12]
                                       ) {
    return DevHelp32.version_1.DevHlp32_VirtToLin(virt, plin);
}
#else
extern int DH32ENTRY DevHlp32_VirtToLin(
                                        PTR16  virt, // [ebp + 8]
                                        void **plin  // [ebp + 12]
                                       );
#endif

extern int DH32ENTRY DevHlp32_GetDosVar(
                    int             index,             //   [ebp + 8]
                    unsigned long **value              //   [ebp + 12]
                   );


#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY DevHlp32_Security(
				       unsigned long   func,     /* ebp + 8  */
                                       void           *ptr       /* ebp + 12 */
                                      ) {
    return DevHelp32.version_1.DevHlp32_Security(func, ptr);
}
#else
extern int DH32ENTRY DevHlp32_Security(
				       unsigned long   func,     /* ebp + 8  */
                                       void           *ptr       /* ebp + 12 */
                                      );
#endif

// #define DHSEC_GETEXPORT  0x48a78df8
// #define DHSEC_SETIMPORT  0x73ae3627
// #define DHSEC_GETINFO    0x33528882

#pragma pack(1)
struct ddtable {
    USHORT reserved[3];
    PTR16  idc_entry;
    USHORT idc_ds;
};
#pragma pack()

extern int DH32ENTRY DevHlp32_AttachDD(char *ddname, struct ddtable *table);

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY DevHlp32_ProcBlock(
                          		unsigned long  eventid,       /* bp + 8  */
                          		long           timeout,       /* bp + 12 */
                          		short          interruptible  /* bp + 16 */
                         	       ) {
    return DevHelp32.version_1.DevHlp32_ProcBlock(eventid, timeout, interruptible);
}
#else
extern int DH32ENTRY DevHlp32_ProcBlock(
                          unsigned long  eventid,       /* bp + 8  */
                          long           timeout,       /* bp + 12 */
                          short          interruptible  /* bp + 16 */
                         );
#endif

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY DevHlp32_ProcRun(
                        	      unsigned long eventid        /* ebp + 8  */
                                     ) {
    return DevHelp32.version_1.DevHlp32_ProcRun(eventid);
}
#else
extern int DH32ENTRY DevHlp32_ProcRun(
                        	      unsigned long eventid        /* ebp + 8  */
                                     );
#endif

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY DevHlp32_LinToPageList(
                                void            *lin,         /* ebp + 8  */
                                unsigned long    size,        /* ebp + 12 */
                                struct PageList *pages,        /* ebp + 16 */
                                unsigned long   *nr_pages    /* ebp + 20 */
                               ) {
    return DevHelp32.version_1.DevHlp32_LinToPageList(lin, size, pages, nr_pages);
}
#else
extern int DH32ENTRY DevHlp32_LinToPageList(
                                void            *lin,         /* ebp + 8  */
                                unsigned long    size,        /* ebp + 12 */
                                struct PageList *pages,        /* ebp + 16 */
                                unsigned long   *nr_pages    /* ebp + 20 */
                               );
#endif

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY DevHlp32_GetInfoSegs(
                    struct InfoSegGDT **ppSysInfoSeg,  /* ebp + 8  */
                    struct InfoSegLDT **ppLocInfoSeg   /* ebp + 12 */
                   ) {
    return DevHelp32.version_2.DevHlp32_GetInfoSegs(ppSysInfoSeg, ppLocInfoSeg);
}
#else
extern int DH32ENTRY DevHlp32_GetInfoSegs(
                    struct InfoSegGDT **ppSysInfoSeg,  /* ebp + 8  */
                    struct InfoSegLDT **ppLocInfoSeg   /* ebp + 12 */
                   );
#endif

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY DevHlp32_SaveMessage(
   			                  char *msg,		/* ebp + 8  */
			                  int   len		/* ebp + 12 */
                		         ) {
    return DevHelp32.version_1.DevHlp32_SaveMessage(msg, len);
}
#else
extern int DH32ENTRY DevHlp32_SaveMessage(
   			                  char *msg,		/* ebp + 8  */
			                  int   len		/* ebp + 12 */
                		         );
#endif



#ifdef DYNAMIC_DEVHELP
INLINE void DH32ENTRY DevHlp32_InternalError(
   			                     char *msg,		/* ebp + 8  */
			                     int   len		/* ebp + 12 */
                		            ) {
    DevHelp32.version_1.DevHlp32_InternalError(msg, len);
}
#else
extern void DH32ENTRY DevHlp32_InternalError(
   			                     char *msg,		/* ebp + 8  */
			                     int   len		/* ebp + 12 */
                		            );
#endif

#ifdef DYNAMIC_DEVHELP
INLINE void DH32ENTRY DevHlp32_Yield(void) {
    DevHelp32.version_1.DevHlp32_Yield();
}
#else
extern void DH32ENTRY DevHlp32_Yield(void);
#endif

#ifdef DYNAMIC_DEVHELP
INLINE void DH32ENTRY fsh32_yield(void) {
    DevHelp32.version_1.DevHlp32_Yield();
}
#else
INLINE void DH32ENTRY fsh32_yield(void) {
    DevHlp32_Yield();
}
#endif


#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY sec32_attach_ses (void *SecHlp) {
    return DevHelp32.version_4.sec32_attach_ses(SecHlp);
}
#else
extern int DH32ENTRY sec32_attach_ses (void *SecHlp);
#endif

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY vsprintf(char *buf, const char *fmt, va_list args) {
    return DevHelp32.version_2.vsprintf(buf, fmt, args);
}
#else
extern int DH32ENTRY vsprintf(char *buf, const char *fmt, va_list args);
#endif

#ifdef DYNAMIC_DEVHELP
INLINE unsigned long DH32ENTRY __mwdd32_strtoul (const char *string, char **end_ptr, int radix) {
    return DevHelp32.version_2.strtoul (string, end_ptr, radix);
}
#else
extern unsigned long DH32ENTRY __mwdd32_strtoul (const char *string, char **end_ptr, int radix);
#endif

#ifdef DYNAMIC_DEVHELP
INLINE long DH32ENTRY __mwdd32_strtol (const char *string, char **end_ptr, int radix) {
    return DevHelp32.version_3.strtol (string, end_ptr, radix);
}
#else
extern long DH32ENTRY __mwdd32_strtol (const char *string, char **end_ptr, int radix);
#endif

#ifdef DYNAMIC_DEVHELP
INLINE long DH32ENTRY __mwdd32_atol (const char *string) {
    return DevHelp32.version_2.atol(string);
}
#else
extern long DH32ENTRY __mwdd32_atol (const char *string);
#endif

#ifdef DYNAMIC_DEVHELP
INLINE char * DH32ENTRY __mwdd32_strupr (char *string) {
    return DevHelp32.version_2.strupr(string);
}
#else
extern char * DH32ENTRY __mwdd32_strupr (char *string);
#endif

#ifdef DYNAMIC_DEVHELP
INLINE char * DH32ENTRY __mwdd32_strpbrk (const char *string1, const char *string2) {
    return DevHelp32.version_2.strpbrk (string1, string2);
}
#else
extern char * DH32ENTRY __mwdd32_strpbrk (const char *string1, const char *string2);
#endif

#ifdef DYNAMIC_DEVHELP
INLINE int DH32ENTRY __mwdd32_fnmatch (const char *mask, const char *name, int flags) {
    return DevHelp32.version_2.fnmatch (mask, name, flags);
}
#else
extern int DH32ENTRY __mwdd32_fnmatch (const char *mask, const char *name, int flags);
#endif

#define strtoul(__s, __e, __r) __mwdd32_strtoul((__s), (__e), (__r))
#define strtol(__s, __e, __r)  __mwdd32_strtol((__s), (__e), (__r))
#define atol(__s)              __mwdd32_atol((__s))
#define strupr(__s)            __mwdd32_strupr((__s))
#define strpbrk(__s1, __s2)    __mwdd32_strpbrk((__s1), (__s2))
#define fnmatch(__m, __n, __f) __mwdd32_fnmatch((__m), (__n), (__f))

#endif
