;
; $Header: D:/32bits/ext2-os2/devhlp32/RCS/DevHlp32_GetDosVar.asm,v 1.1 1996/08/26 19:01:49 Willm Exp Willm $
;

; 32 bits OS/2 device driver and IFS support driver. Provides 32 bits kernel 
; services (DevHelp) and utility functions to 32 bits OS/2 ring 0 code 
; (device drivers and installable file system drivers).
; Copyright (C) 1995, 1996 Matthieu WILLM
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        .386p

        INCL_DOSERRORS equ 1
        include bseerr.inc
        include devhlp.inc
        include segdef.inc
        include r0thunk.inc

CODE16 segment
        ASSUME CS:CODE16, DS:FLAT

        public thunk16$DevHlp32_GetDosVar
        public thunk16$DevHlp32_GetDosVar_1

thunk16$DevHlp32_GetDosVar:
        call [DevHelp2]
;        jmp far ptr FLAT:thunk32$DevHlp32_GetDosVar
        jmp32 thunk32$DevHlp32_GetDosVar
thunk16$DevHlp32_GetDosVar_1:
        call [DevHelp2]
;        jmp far ptr FLAT:thunk32$DevHlp32_GetDosVar_1
        jmp32 thunk32$DevHlp32_GetDosVar_1

CODE16 ends

CODE32 segment
ASSUME CS:FLAT, DS:FLAT, ES:FLAT, SS:NOTHING

        public thunk32$DevHlp32_GetDosVar
        public thunk32$DevHlp32_GetDosVar_1
        public         DevHlp32_GetDosVar

;
; int DH32ENTRY DevHlp32_GetDosVar(
;                    int            index,                [ebp + 8]
;                    unsigned long *value                 [ebp + 12]
;                   );
;
DevHlp32_GetDosVar proc near
        push ebp
        mov  ebp, esp
	push ebx
	push esi
	push edi

	mov eax, [ebp + 8]			; index
	xor ecx, ecx				; nothing
        mov edx, DevHlp_GetDOSVar
        jmp far ptr thunk16$DevHlp32_GetDosVar
thunk32$DevHlp32_GetDosVar:
        jc short @@error           		; if error, EAX = error code
						; else AX:BX points to the value
	movzx esi, bx				; offset
	mov edx, DevHlp_VirtToLin		; converts returned pointer to FLAT
	jmp far ptr thunk16$DevHlp32_GetDosVar_1
thunk32$DevHlp32_GetDosVar_1:
	jc short @@error
	mov edi, [ebp + 12]
	mov [edi], eax		                ; value
        mov eax, NO_ERROR
@@error:
	pop edi
	pop esi
	pop ebx
        leave
        ret
DevHlp32_GetDosVar endp

CODE32  ends

        end
