// MainFrm.h : interface of the CGameFrame class
//
/////////////////////////////////////////////////////////////////////////////

#include <DDraw.h>

class CGameFrame : public CFrameWnd
{
public:
	CGameFrame();
	virtual ~CGameFrame();

// Attributes
public:
	BOOL m_bUseEmulation;

  // DirectDraw variables
  LPDIRECTDRAW            m_pDD;
  LPDIRECTDRAWSURFACE     m_pFrontBuffer;
  LPDIRECTDRAWSURFACE     m_pBackBuffer;
  LPDIRECTDRAWPALETTE     m_pGamePalette;

// Operations
public:
  virtual BOOL InitGraphics();
	virtual void KillGraphics();

protected:
	virtual CString GetWindowTitle();

	virtual BOOL InitPalette();
  virtual BOOL RestoreSurfaces();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGameFrame)
	protected:
	//}}AFX_VIRTUAL

// Implementation
public:
  virtual BOOL UpdateGame();

// Generated message map functions
protected:
	//{{AFX_MSG(CGameFrame)
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnActivateApp(BOOL bActive, HTASK hTask);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Diagnostics
public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};

/////////////////////////////////////////////////////////////////////////////
