/**************************************************************************/
/*                             Extract Utility                            */
/*                                                                        */
/*                                 M\Cooper                               */
/*                                PO Box 237                              */
/*                        St. David, AZ 85630-0237                        */
/*                        -------------------------------                 */
/*                        Email:  thegrendel@theriver.com                 */
/*                                                                        */
/*                $2.00 to register the entire WORDY package              */
/*                                                                        */
/**************************************************************************/


#include <conio.h>
#include "srch.h"


#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 8
#define CR "\n"
#define FILE_SUFFIX ".xtr"
#define MAXLEN 60
#define LINE_LEN 80
#define NOARGS 1
#define INCREMENT 1
#define SPACE ' '
#define NOT "~!"
#define SINGLE 1
#define MINLEN 4

#define BUFFERSIZE 8192
/*******8K buffer******/

char ad[] =
"XTRACT tool by M\\Cooper, PO Box 237, St. David, AZ 85630-0237";

typedef enum { FALSE, TRUE } Boolean;

void getword( char *lset, char *nlset, char *wrdfile );
void center( char *strng );
void parse( char *argument, char *lset, char *not_letterset );
Boolean wordtest( char *letterset, char *word );
char *nw_test( char *nlset, char *word );


void main( int argc, char **argv )
{

   char letterset[ MAXLEN ],
	   n_letterset[ MAXLEN ],
	   input_set[ MAXLEN ],
    wfile [ MAXLEN ];  

	 strcpy ( n_letterset, NULL );

	 if( argc == NOARGS )
	    {
	    clrscr();
	    puts( "Enter a LETTERSET to test [~ or ! for excluded letters]..." );
	    gets( input_set );
	    parse( input_set, letterset, n_letterset );

      printf( "\n\n" );
      puts( "Enter the name of the word file to search... " );
      gets( wfile );

	    }
	 else
	    parse( argv[1], letterset, n_letterset );

      if( argc == NOARGS + 1 )
         strcpy( wfile, "word.lst" );
      else
         if( argc == NOARGS + 2 )
            strcpy( wfile, argv [2] );

	 getword( letterset, n_letterset, wfile );
}



/**********************************WORDTEST********************************/
/*       Function tests if word is constructible from Letterset           */
/*                 Args in: char *letterset, char *word                   */
/*   Returns: error_flag == TRUE (1) if constructible, FALSE (0) if not   */
/**************************************************************************/

Boolean wordtest( char *letterset, char *word )
{
   char temp [MAXLEN],
	   *t;
   Boolean error_flag = TRUE;

	 if( *letterset == NULL )
	    return( error_flag );  //All valid if no specs given

	 strcpy( temp, word );  //Preserve WORD

	 while( *letterset )
	    {
	    t = strchr( temp, *letterset++ );

	    if( !t )
		  {
		  error_flag = FALSE;
		  return( error_flag );
		  } 
		
	    *t = '*';  //Remove occurrence of letter
	    }

		return( error_flag );
}

char *nw_test( char *nlset, char *word )
{
   char *ptr;

	 ptr = ( strpbrk( word, nlset ) );

	 return( ptr );
}

/*************************************************************/

void getword( char *letter_set, char *nlset, char *wordfile )
{

	char	l_set [ MAXLEN ],
		word [ MAXLEN ],
		tempstr [ LINE_LEN + 1 ],
		targetfile [ MAXLEN ],
		bar [ LINE_LEN + 1 ],
		double_bar [ LINE_LEN + 1 ],
  msg1 [ MAXLEN ], 
  msg2 [ MAXLEN ];

	FILE *fptr,
		*tfile;
	int fnamelen;
	long wcount = 0L;

	   memset( bar, '-', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, '=', LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
	   printf( CR );
	   printf( double_bar );
	   printf( CR );
	   /****************************************/


	   strcpy ( l_set, letter_set );
//	   strcat ( letter_set, CR );

	   /*   Create name of file to store derived words in   */
	   /*********************************************************/
	   fnamelen = strlen( l_set );

	   if( fnamelen > 0 )
		 {
		 if( fnamelen  > FILENAME_MAXLEN )
			fnamelen = FILENAME_MAXLEN;
		 strncpy( targetfile, l_set, fnamelen );
		 *( targetfile + fnamelen ) = NULL;
            //NULL-terminate string, so strcat works, ha, ha.
		 }
	   else
		 strcpy( targetfile, "not" );

	   strcat( targetfile, FILE_SUFFIX );
	   /*********************************************************/

	   if( !( fptr = fopen( wordfile, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open Wordfile!" );
		 exit( FILE_OPENING_ERROR );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, 2 * BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR );

	   if( !( tfile = fopen( targetfile, "wt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file to save words in!" );
		 exit ( FILE_OPENING_ERROR + 1 );
		 }
      if( setvbuf( tfile, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR );

	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "This will take a few seconds.\n" );
	   printf( "Please be patient.\n\n" );
	   printf( "Now searching word file %s\nand writing file of valid words containing -%s-", 
		  wordfile, letter_set );

	    if( *nlset )
		  printf( " but NOT -%s-", nlset );

	    printf( ".\n\n" );
	   /*****************************************/





	   sprintf( tempstr, "Word(s) containing: %s", strupr( l_set ) );
	   if( *nlset )
			{
			strcat( tempstr, ", but NOT -" );
			strcat( tempstr, nlset );
			strcat( tempstr, "-" );
			}
	   strcat( tempstr, CR );

	   center( tempstr );
	   fprintf( tfile, double_bar );
    fprintf( tfile, CR );
	   fprintf( tfile, tempstr );
	   fprintf( tfile, double_bar );
	   fprintf( tfile, CR );


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

			if( wordtest( letter_set, word ) )
			   if( !nw_test( nlset, word ) )
				 {
				 fprintf( tfile, "%s", word );
				 wcount++;
				 }
		  /*******************************************/

      if( wcount == SINGLE )
          {
          strcpy( msg1, "word" );
          strcpy( msg2, "word contains" );
          }
      else
          {
          strcpy( msg1, "words" );
          strcpy( msg2, "words contain" );
          }

		  fprintf( tfile, bar );
		  sprintf( tempstr, "%ld %s %s.",
				 wcount, msg2, l_set );
		  if( *nlset )
			{
			strcat( tempstr, ".. but NOT --- " );
			strcat( tempstr, nlset );
			strcat( tempstr, "." );
			}

    fprintf( tfile, "\n" );
		  center( tempstr );		      
		  fprintf( tfile, tempstr );
		  fprintf( tfile, "\n\n" );

		  center( ad );
		  fprintf( tfile, ad );

		  fcloseall();

		  sprintf( tempstr,
				 "The file %s has %ld %s containing %s.",
				 targetfile, wcount, msg1, l_set );
		  if( *nlset )
			{
			strcat( tempstr, ".. but NOT --> " );
			strcat( tempstr, nlset );
			strcat( tempstr, "." );
			}

		  center( tempstr );
		  printf( CR CR );
		  printf( tempstr );
		  printf( "\7" );  //Bell

}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}

void parse( char *arg, char *letterset, char *nls )
{
   char *p;

	 if( *arg == '~' || *arg == '!' )
	    {
	    *letterset = NULL;
	    strcpy( nls, ++arg );
	    return;
	    }


	 p = strtok( arg, NOT );
	 strcpy( letterset, p );

	 p = strtok( NULL, NULL );

	 if( *p )
	    strcpy( nls, p );
  else
     *nls = NULL;

	 return;
}
