/**************************************************************************/
/*                                                                        */
/*                               UnReFormat                               */
/*                                                                        */
/*                 Reverses effect of ReFormat Utility                    */
/*                       [Back to 1 word / line]                          */
/*                                                                        */
/*                                M\Cooper                                */
/*                               PO Box 237                               */
/*                          St. David, AZ 85630                           */
/*                    E-mail: thegrendel@theriver.com                     */
/*                                                                        */
/**************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define MAXFILENAMELEN 40
#define MAXWORDLEN 98
#define TEMPFILE "temp.$x$"
#define COMMANDLINEPRAMS 2

   typedef enum { FALSE, TRUE } Boolean;

   Boolean unrf( char *file );

void main( int argc, char **argv )
{
   char filename [MAXFILENAMELEN];

      if( argc == COMMANDLINEPRAMS )
         strcpy( filename,  *( argv + 1 ) );
      else
         {
         printf( "\n\nName of file to UnReFormat? " );
         gets( filename );
         }

      if( unrf( filename ) )
         {
         printf( "\n\nFile %s UnReFormatted back to \"standard\" format.\n",
                 filename );
         unlink( filename ); //Delete original file.
         rename( TEMPFILE, filename );
         }
      else
         printf( "\n\nCan't find or create files.\n" );

}

/***************************************************************************/

Boolean unrf( char *fname )
{
   FILE *fsource,
        *fobject;
   char word [MAXWORDLEN];

      if( !( fsource = fopen( fname, "r" ) ) )
         return( FALSE );

      if( !( fobject = fopen( TEMPFILE, "w" ) ) )
         return( FALSE );

         while( !feof( fsource ) )
            {
            if( fscanf( fsource, " %s", word ) == EOF )
               break;

            if( isdigit( *word ) )
               break;  //If forgot to delete bottom comment lines...

            if( islower ( *word ) )
               fprintf( fobject, "%s\n", word );
             }  


      fclose( fsource );
      fclose( fobject );
      return( TRUE );
}



