/*
 *  MSGED.H
 *
 *  Written on 30-Jul-90 by jim nutt.  Changes on 10-Jul-94 by John Dennis.
 *  Released to the public domain.
 *
 *  Main header file for all Msged source files.
 */

#ifndef MSGED_H_INCLUDED
#define MSGED_H_INCLUDED

#define NOSPELL                 /* no spelling checker support */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "mcompile.h"           /* compiler specifics */
#include "nedit.h"              /* line definitions */
#include "dirute.h"
#include "unused.h"

#define ALPHA 0                 /* alpha test release? */

#if ALPHA
#define CLOSED    " alpha 10"
#define PIDALPHA  ".a10"
#else
#define CLOSED    ""
#define PIDALPHA  ""
#endif

/*
 *  PID version is not allowed to have trailing 0's, but we like them
 *  on the tearline.
 */

#ifndef PIDVER
#define PIDVER   "4"
#endif

#ifndef VERSION
#define VERSION  "4.00"
#endif

#ifdef MSDOS
#ifndef __FLAT__
#define PROG  "Msged"
#else
#define PROG  "Msged/386"
#endif
#endif

#ifdef OS2
#define PROG  "Msged/2"
#endif

#ifdef WINNT
#define PROG  "Msged/NT"
#endif

#ifdef SASC
#define PROG "Msged/AM"
#endif

#ifdef UNIX
#define PROG "Msged/UNX"
#endif

#ifndef PROG
#define PROG  "Msged"
#endif


#define NO        0
#define YES       1
#define FAIL      0
#define OK        1
#define HIDE      2
#define RIGHT     0
#define LEFT      1
#define SAVE      1
#define ABORT     -1

#define GDOMAINS  0x01          /* gate domains */
#define GZONES    0x02          /* gate zones */
#define BOTH      0x04          /* gate both */

#define FIDO      0x00
#define QUICK     0x01
#define SQUISH    0x02

#define USENET    0x01
#define FIDONET   0x02

#define PATHLEN   64
#define BLOCKLEN  255
#define BUFLEN    4096

#define MAXUSERS  11

#define MT_QUO    0x0001        /* msg has a quote */
#define MT_REP    0x0002        /* msg is a reply (no quote) */
#define MT_ARC    0x0004        /* check for dest. area */
#define MT_FOL    0x0008        /* insert followup template */
#define MT_NEW    0x0010        /* msg is new (no to:) */
#define MT_FOR    0x0020        /* forwarded message */
#define MT_RED    0x0040        /* redirected message */

#define WR_HEADER        0x0001 /* write header only */
#define WR_ALL           0x0002 /* write all msg */
#define RD_HEADER        0x0004 /* read header only */
#define RD_ALL           0x0008 /* read all msg */
#define RD_HEADER_BRIEF  0x0010 /* read header without replies */

#define ERR_OPEN_MSG     -1     /* error opening msg */
#define ERR_CLOSE_MSG    -2     /* error closing message */
#define ERR_OPEN_AREA    -3     /* error opening area */
#define ERR_CLOSE_AREA   -4     /* error closing area */
#define ERR_NO_AREA      -5     /* no area currently open! */

/* useful time-saving macros */

#define ST        string_vars
#define SW        switch_vars
#define thisnode  alias[0]
#define CurArea   arealist[SW->area]

/* structures and typedefs */

/* Attributes used & recognized by Msged */

struct _attributes
{
    unsigned int priv:1;        /* private message flag     */
    unsigned int crash:1;       /* crash mail               */
    unsigned int rcvd:1;        /* received by addressee    */
    unsigned int sent:1;        /* message sent             */
    unsigned int attach:1;      /* file attached            */
    unsigned int forward:1;     /* message in transit       */
    unsigned int orphan:1;      /* unknown destination      */
    unsigned int killsent:1;    /* kill after sending       */
    unsigned int local:1;       /* local message            */
    unsigned int hold:1;        /* hold for pickup          */
    unsigned int direct:1;      /* do no gating on this msg */
    unsigned int freq:1;        /* file request             */
    unsigned int rreq:1;        /* return receipt requested */
    unsigned int rcpt:1;        /* return receipt           */
    unsigned int areq:1;        /* audit trail request      */
    unsigned int ureq:1;        /* update file request      */
};

/*
 *  Structure defining a "five-dimensional" FidoNet address, or an
 *  Internet address (stored in the domain).
 */

typedef struct _address
{
    unsigned int zone;
    unsigned int net;
    unsigned int node;
    unsigned int point;
    char *domain;
    unsigned int notfound:1;
    unsigned int fidonet:1;
    unsigned int internet:1;
    unsigned int bangpath:1;
}
ADDRESS;

/* Structure defining an alias for header and cc: entry */

typedef struct _alias
{
    int attr;                   /* wuz an attribute specified? */
    char *alias;                /* the alias */
    char *name;                 /* the real name */
    char *subj;                 /* the subject */
    struct _attributes attrib;  /* the attributes (if used) */
    ADDRESS addr;               /* the address (if used) */
}
ALIAS;

/* Structure defining a Version7 nodelist */

typedef struct _domain_list
{
    char *name;                 /* full domain name eg. fidonet.org */
    char *base_name;            /* base name of nodelist ie. nodex */
    char *sysop;                /* sysop lookup filename eg. sysop.ndx */
}
D_LIST;

/*
 *  Defines a user plus the corresponding useroffset and lastread
 *  values.  The current values are copied to the global equivalents
 *  (to avoid extra work).
 */

typedef struct _user
{
    char *name;
    char *lastread;
    char *robotname;
    unsigned long offset;
}
USER;

/*
 *  Defines an area group.  This is used to determine what username
 *  and template to use in an area.  Only used on startup.
 */

typedef struct _group
{
    char *search;
    unsigned int username;
    unsigned int template;
}
GROUP;

/* The internal area structure. Contains all info relevant for an area. */

typedef struct _area
{
    int status;                 /* status of the area, 0 = closed, 1 =
                                   open */
    ADDRESS addr;               /* the address to use in this message */
    char *description;          /* what the user calls the area */
    char *tag;                  /* what confmail calls it! */
    char *path;                 /* where the area is on disk */

    unsigned int local:1;       /* local message area */
    unsigned int netmail:1;     /* netmail message area */
    unsigned int echomail:1;    /* echomail area */
    unsigned int news:1;        /* usenet news area */
    unsigned int uucp:1;        /* usenet mail area */
    unsigned int new:1;         /* a message has been entered */
    unsigned int priv:1;        /* default private */
    unsigned int hold:1;        /* default hold */
    unsigned int direct:1;      /* default direct */
    unsigned int crash:1;       /* default crash */
    unsigned int killsent:1;    /* default crash */

    unsigned int template;      /* index into template array */
    unsigned int username;      /* index into username array */

    unsigned int msgtype;       /* the message type */
    int board;                  /* if a quickbbs area, which board */
    unsigned long first;        /* first message in the area ?? */
    unsigned long last;         /* last message in the area */
    unsigned long current;      /* current message in the area */
    unsigned long messages;     /* how many messages in the area */
    unsigned long lastread;     /* the highest message read */
}
AREA;

/*
 *  The internal message structure.  Built to reflect both Squish
 *  (32-bit) and other messagebase structures.
 */

typedef struct _msg
{
    unsigned long msgnum;       /* message number (UMSGID) */
    char *reply;                /* id of message this is a reply to */
    char *msgid;                /* this messages msgid */
    char *isfrom;               /* who from */
    char *isto;                 /* who to */
    char *subj;                 /* message subject */

    unsigned int new:1;         /* new message ? */
    unsigned int change:1;      /* message been changed ? */
    unsigned int scanned:1;     /* msg been scanned ? */
    unsigned int newrcvd:1;     /* msg just received? */
    unsigned int soteot:1;      /* msg sot/eot protected? */

    time_t timestamp;           /* creation date, */
    time_t time_arvd;           /* time message arrived */

    unsigned long replyto;      /* thread to previous msg */
    unsigned long replies[10];  /* thread to next msg(s) */

    struct _attributes attrib;  /* message attribute */
    int times_read;             /* times msg been read */
    int cost;                   /* cost of message */

    ADDRESS to;                 /* destination address of message */
    ADDRESS from;               /* origin address of message */
    LINE *text;                 /* the message buffer */
}
msg;

/* A command/label assignment structure (for the keyboard) */

struct _command
{
    char *label;
    void (*action) (void);
};

/* Handle for msgbase access functions */

typedef struct _msghandle
{
    msg *(*MsgReadHeader) (unsigned long n, int type);
    char *(*MsgReadText) (unsigned long n);
    int (*MsgWriteHeader) (msg * m, int type);
    int (*MsgWriteText) (char *text, unsigned long n, unsigned long mlen);
    int (*MsgDelete) (unsigned long n);
    int (*AreaSetLast) (AREA * a);
    long (*MsgAreaOpen) (AREA * a);
    int (*MsgAreaClose) (void);
    int (*MsgClose) (void);
    unsigned long (*UidToMsgn) (unsigned long n);
    unsigned long (*MsgnToUid) (unsigned long n);
}
msghandle;

/* These are the system strings, for access across the system */

struct _sv
{
    char *username,             /* who is you */
    *quotestr,                  /* how to prefix a quote */
    *fidolist,                  /* nodelist user list */
    *userlist,                  /* personal user list */
    *origin,                    /* origin line */
    *outfile,                   /* default export filename */
    *home,                      /* home directory */
    *lastread,                  /* name of the lastread file */
    *cfgfile,                   /* name of the config file */
    *confmail,                  /* confmail log file name */
    *template,                  /* template file */
    *nodepath,                  /* path to current nodelist */
    *nodebase,                  /* base (current) nodelist name */
    *sysop,                     /* name of sysop */
    *swap_path,                 /* swap path... */
    *helpfile,                  /* helpfile name */
    *uucpgate,                  /* the UUCP gate name to send to */
    *comspec,                   /* file spec of command processor */
    *editorName,                /* name of external editor */
    *quickbbs;                  /* where a quickbbs file is */
};

/* These are the system switches, for access across the system */

struct _swv
{
    unsigned long useroffset;   /* offset into lastread file */
    int area;                   /* current area number */
    int areas;                  /* how many message areas */
    int aliascount;             /* how many aliases do you have? */
    int otheraliases;           /* how many "other" aliases? */
    int numtemplates;           /* how many templates in use ? */
    int domains;                /* how many domains listed */
    int rm;                     /* the right margin */
    int qm;                     /* the quote margin */
    int pointnet;               /* private net number of point */
    int tabsize;                /* how many spaces for a tab */
    int nodelists;              /* number of nodelists */
    int rquote;                 /* dfns for the reply funcs; quote */
    int rotharea;               /* reply other area */
    int rfollow;                /* reply followup */
    int rextra;                 /* reply extra - user definable */
    int gate;                   /* zone/domain gate messages? */
    int override;               /* override the area origin line */
    int scanned;                /* areas have been scanned */
    int redraw;                 /* redraw screen header? */
    int msgids;                 /* add msgid lines */
    int opusdate;               /* put in the opus time stamp */
    int shownotes;              /* show hidden lines */
    int seenbys;                /* show seenby lines */
    int confirmations;          /* confirm deletes, aborts? */
    int datearrived;            /* show the date msg arrived? */
    int showaddr;               /* shows curr address on screen */
    int use_lastr;              /* whether to use lastread/current */
    int qquote;                 /* quote quotes? */
    int savecc;                 /* save cc original copy? */
    int rawcc;                  /* save the raw cc msg? */
    int chopquote;              /* chop off the end of quoted msgs? */
    int hardquote;              /* don't reformat quoted text? */
    int showcr;                 /* show CRs ? */
    int showeol;                /* show eol? */
    int showrealmsgn;           /* show real msg#s in <alt><l> */
    int usemouse;               /* use the mouse? */
    int tabexpand;              /* expand tabs? */
    int editcronly;             /* show CRs in editor only */
    int usepid;                 /* use a pidinstead of a tearline */
    int soteot;                 /* use SOT/EOT */
    int showtime;               /* show time in main message area? */
    int importfn;               /* show the filename headers on import */
    int dmore;                  /* display msg numbers at top of screen */
    int statbar;                /* show statbar */
    int showsystem;             /* show system name? */
    int extformat;              /* format externally-edited messages? */
};

#ifndef INCL_MAIN

extern struct _swv *switch_vars;  /* array of switches */
extern struct _sv *string_vars; /* array of strings */
extern msghandle msgdo[];       /* msgbase functions */
extern ADDRESS *domain_list;    /* list of ^aDOMAIN lookups */
extern ADDRESS *alias;          /* list of AKA's */
extern ADDRESS uucp_gate;       /* closest UUCP gate */
extern D_LIST *node_lists;      /* list of v7 nodelists */
extern AREA *arealist;          /* list of areas for system */
extern ALIAS *aliaslist;        /* list of alias lookups */
extern USER user_list[11];      /* list of system users */
extern char **templates;        /* list of templates */
extern msg *message;            /* current message */
extern unsigned int *macros[41];  /* macros */
extern int maxy;                /* max y pos, 1 origin */
extern int maxx;                /* max x pos, 1 origin */
extern int cur_start;           /* these are ega/vga default */
extern int cur_end;             /* cursor sizes */
extern int rot13;               /* rot13 this message? */
extern int stripSoft;           /* strip soft-crs? */
extern char msgbuf[BUFLEN];     /* message buffer for reading */
extern int msgederr;            /* global error number */
extern int cmd_dbginfo;         /* show debugging info at startup? */

#endif

#include "mprotos.h"            /* all the various prototypes */

/* various and sundry macros */

#define release(s)                {if (s != NULL) free(s); s = NULL;}

#define MsgReadHeader(n,type)     (msgdo[CurArea.msgtype].MsgReadHeader(n,type))
#define MsgReadText(n)            (msgdo[CurArea.msgtype].MsgReadText(n))
#define MsgWriteHeader(m,type)    (msgdo[CurArea.msgtype].MsgWriteHeader(m,type))
#define MsgWriteText(text,n,mlen) (msgdo[CurArea.msgtype].MsgWriteText(text,n,mlen))
#define MsgDelete(n)              (msgdo[CurArea.msgtype].MsgDelete(n))
#define AreaSetLast(a)            (msgdo[CurArea.msgtype].AreaSetLast(a))
#define MsgAreaOpen(a)            (msgdo[CurArea.msgtype].MsgAreaOpen(a))
#define MsgAreaClose()            (msgdo[CurArea.msgtype].MsgAreaClose())
#define MsgClose()                (msgdo[CurArea.msgtype].MsgClose())
#define UidToMsgn(n)              (msgdo[CurArea.msgtype].UidToMsgn(n))
#define MsgnToUid(n)              (msgdo[CurArea.msgtype].MsgnToUid(n))

#define DOROT13(c) ((rot13==0) ? (c) : handle_rot((c)))

msg *KillMsg(msg * m);

#endif
