/*
 *  LIST.C
 *
 *  Written on 10-Jul-94 by John Dennis and released to the public domain.
 *
 *  Lists the messages in the messagebase.
 */

#include "msged.h"
#include "main.h"
#include "keys.h"
#include "list.h"
#include "help.h"
#include "strextra.h"
#include "memextra.h"
#include "specch.h"

static MLIST *head;
static int long_subj = FALSE;
static int display_address = TRUE;

/*
   **
   ** Checks to see if the message has been selected.
   **
 */

int MLselected(unsigned long uid)
{
    MLIST *temp;

    temp = head;
    while (temp != NULL)
    {
        if (temp->uid == uid)
            return TRUE;

        temp = temp->next;
    }
    return FALSE;
}

/*
   **
   ** Removes a selection from the list.
   **
 */

void MLkill(unsigned long uid)
{
    MLIST *temp, *temp2;

    /* Find it in the list, keeping track of the previous link. */

    temp = head;
    while (temp != NULL)
    {
        if (temp->uid == uid)
            break;

        temp2 = temp;
        temp = temp->next;
    }
    if (temp != NULL)
    {
        /* Remove it from the list. */

        if (temp == head)
            head = temp->next;
        else
        {
            if (temp2)
                temp2->next = temp->next;
        }
        xfree(temp);
    }
}

/*
   **
   ** Adds a new UMSGID to the list of selected messages.
   **
 */

static void AddMlist(unsigned long uid)
{
    MLIST *temp;

    temp = xcalloc(1, sizeof *temp);

    if (head == NULL)
    {
        head = temp;
    }
    else
    {
        temp->next = head;
        head = temp;
    }
    head->uid = uid;
}

/*
   **
   ** Frees the list of msgnumbers.
   **
 */

static void KillMlist(void)
{
    MLIST *temp;

    while (head != NULL)
    {
        temp = head;
        head = head->next;
        xfree(temp);
    }
    head = NULL;
}

/*
   **
   ** Re-displays the entire screen.
   **
 */

static void update(MLHEAD * headers, unsigned long i, int y)
{
    while ((i <= CurArea.messages) && (y <= (maxy - 4)))
    {
        getheader(i, &headers[y - 1]);
        showit(&headers[y - 1], y, 0);
        i++;
        y++;
    }
    if (y <= (maxy - 4))
    {
        WClear(1, y, maxx - 2, maxy - 4, cm[LS_NTXT]);
    }
}

/*
   **
   ** Shows a header on the screen.
   **
 */

static void showit(MLHEAD * h, int y, int sel)
{
    unsigned long msgn;
    char line[256];
    char msgnbuf[9];

    msgn = SW->showrealmsgn ? h->umsgid : h->msgnum;
    sprintf(msgnbuf, "%5ld %c", msgn, h->sel ? SC14 : ' ');

    if (long_subj)
    {
        sprintf(line, "%s%-15.15s %-70s",
                msgnbuf,
                h->fr_name,
                h->subj);
    }
    else
    {
        sprintf(line, "%s%-15.15s %-15.15s %-70s",
                msgnbuf,
                h->fr_name,
                h->to_name,
                h->subj);
    }

    if (sel)
        WPutsn(1, y, 78, cm[LS_STXT], line);
    else if ((stricmp(h->to_name, ST->username) == 0)
             || (stricmp(h->fr_name, ST->username) == 0))
    {
        WPutsn(1, y, 78, cm[LS_ITXT], line);
    }
    else
    {
        WPutsn(1, y, 78, cm[LS_NTXT], line);
    }
}

/*
   **
   ** Gets a header from the msgbase.
   **
 */

static void getheader(unsigned long n, MLHEAD * h)
{
    msg *i;

    memset(h, 0, sizeof(MLHEAD));
    if ((i = MsgReadHeader((unsigned int)n, RD_HEADER_BRIEF)) == NULL)
        return;

    if (MLselected(i->msgnum))
        h->sel = 1;
    else
        h->sel = 0;

    h->msgnum = n;
    h->umsgid = i->msgnum;
    h->to_net = i->to.net;
    h->to_node = i->to.node;
    h->fr_net = i->from.net;
    h->fr_node = i->from.node;

    strncpy(h->subj, i->subj, 72);
    strncpy(h->to_name, i->isto, 36);
    strncpy(h->fr_name, i->isfrom, 36);

    dispose(i);
}

/*
   **
   ** Deletes the selected messages, or the current one if none.
   **
 */

static void DeleteMsgs(unsigned long *CurrMsgn)
{
    MLIST *temp;
    unsigned long msgn;
    unsigned long oldmsgn;
    int t;

    if (!confirm("Erase message?"))
        return;

    temp = head;
    t = SW->confirmations;
    SW->confirmations = 0;

    if (head == NULL)
    {
        CurArea.current = *CurrMsgn;
        deletemsg();
    }
    else
    {
        oldmsgn = 0;
        while (temp != NULL)
        {
            msgn = UidToMsgn(temp->uid);
            if (oldmsgn == 0)
            {
                oldmsgn = msgn - 1;
            }
            if (msgn)
            {
                CurArea.current = msgn;
                deletemsg();
            }
            temp = temp->next;
        }
        if (oldmsgn == 0)
        {
            oldmsgn = *CurrMsgn;
        }
        CurArea.current = *CurrMsgn = oldmsgn;
    }
    SW->confirmations = t;
}

/*
   **
   ** Puts a list of messages up in a window on the screen.  Alows for some
   ** basic management of those messages.
   **
 */

void do_list(void)
{
    EVT event;
    WND *hWnd, *hCurr;
    static int in_list = 0;     /* stop recursion */
    MLHEAD *headers;            /* headers */
    int done = 0;               /* finished ? */
    int down = 0;
    int ForceEvt = 0;           /* forced/piped keypress */
    int Msg;                    /* message */
    int lbutton = 0;
    unsigned long i, a;
    int y;

    if (in_list || !CurArea.status)  /* stop recursion */
        return;
    else
        in_list = 1;

    /* Open the window and draw the screen and allocate the memory. */

    hCurr = Wtop();
    hWnd = WndOpen(0, 1, maxx - 1, maxy - 2, NBDR | NOSAVE, 0, cm[LS_NTXT]);
    headers = xcalloc(maxy, sizeof(MLHEAD));

    WBox(0, 0, maxx - 1, maxy - 3, cm[LS_BTXT], SBDR);

    message = KillMsg(message);
    head = NULL;
    a = CurArea.current;
    y = 1;
    update(headers, a, y);

    while (!done)
    {
#if defined(MSDOS) && !defined(__FLAT__)
        /* shows memory if compiled under dos */

        if (SW->statbar)
        {
            char line[255];
            sprintf(line, "%c %3ldk ", SC7, (long)(corerem() / 1024));
            WCurr(Wtop());
            WPutsn(maxx - 7, maxy - 1, 7, cm[CM_ITXT], line);
            WCurr(hWnd);
        }
#endif

        WWriteStr(3, 0, cm[LS_TTXT], "Msg");
        WWriteStr(8, 0, cm[LS_TTXT], "From");
        WWriteStr(24, 0, cm[LS_TTXT], "To");
        WWriteStr(40, 0, cm[LS_TTXT], "Subject");
        showit(&headers[y - 1], y, 1);

        if (down)
        {
            /* If a selection has occured, then force cursor down. */

            Msg = Key_Dwn;
            event.msg = Msg;
            event.msgtype = WM_CHAR;
            down = 0;
        }
        else
        {
            if (ForceEvt)
            {
                /* These events are from the mouse (no * point in
                   duplicating * code). */

                Msg = ForceEvt;
                event.msg = Msg;
                event.msgtype = WM_CHAR;
                ForceEvt = 0;
            }
            else
            {
                Msg = MnuGetMsg(&event, hWnd->wid);
            }
        }
        switch (event.msgtype)
        {
        case WM_MOUSE:
            switch (Msg)
            {
            case LMOU_RPT:
                {
                    int y1 = event.y;

                    if (y1 > maxy - 4 && lbutton)
                        ForceEvt = Key_Dwn;
                    else if (y1 < 1 && lbutton)
                        ForceEvt = Key_Up;
                }
                break;

            case LMOU_CLCK:
            case MOU_LBTDN:
            case MOU_LBTUP:
            case MOUSE_EVT:
                {
                    int y1 = event.y, ok = 0;

                    if (Msg == MOU_LBTDN)
                        lbutton = 1;
                    else if (Msg == MOU_LBTUP)
                        lbutton = 0;

                    if (y1 > maxy - 4)
                    {
                        if (( /* Msg == MOUSE_EVT || */ Msg == MOU_LBTDN)
                            && lbutton)
                        {
                            ForceEvt = Key_Dwn;
                        }
                    }
                    else
                    {
                        if (y1 < 1)
                        {
                            if (( /* Msg == MOUSE_EVT || */ Msg == MOU_LBTDN) && lbutton)
                                ForceEvt = Key_Up;
                        }
                        else
                        {
                            /* The event occured on the list... */

                            if (y == y1 && (Msg == MOU_LBTUP || Msg == LMOU_CLCK))
                            {
                                ForceEvt = Key_Ent;
                                continue;
                            }
                            showit(&headers[y - 1], y, 0);
                            if (y > y1)
                            {
                                if ((a - (y - y1)) >= 1)
                                {
                                    a -= (y - y1);
                                    ok = TRUE;
                                }
                            }
                            else
                            {
                                if ((a + (y1 - y)) <= CurArea.messages)
                                {
                                    a += (y1 - y);
                                    ok = TRUE;
                                }
                            }
                            if (ok == TRUE)
                            {
                                y = y1;
                                if ((Msg == MOU_LBTUP)
                                    || (Msg == LMOU_CLCK))
                                {
                                    ForceEvt = Key_Ent;
                                }
                            }
                        }
                    }
                }
                break;

            default:
                break;
            }
            break;

        case WM_CHAR:
            switch (Msg)
            {
            case Key_PgDn:
                i = maxy - 4 - y;
                while (i > 0 && a < CurArea.messages)
                {
                    i--;
                    a++;
                }
                y = 1;
                update(headers, a, y);
                break;

            case Key_PgUp:
                if (y == 1)
                {
                    i = maxy - 5;
                }
                else
                {
                    i = y - 1;
                }
                while (i > 0 && a > 1)
                {
                    i--;
                    a--;
                }
                y = 1;
                update(headers, a, y);
                break;

            case Key_Up:
                if (a > 1)
                {
                    showit(&headers[y - 1], y, 0);
                    a--;
                    y--;

                    if (y < 1)
                    {
                        y = 1;
                        WScroll(1, 1, maxx - 2, maxy - 4, 0);
                        if (SW->statbar)
                        {
                            memmove((headers + 1),
                                    headers,
                                    sizeof(MLHEAD) * (maxy - 2));
                        }
                        else
                        {
                            memmove((headers + 1),
                                    headers,
                                    sizeof(MLHEAD) * (maxy - 1));
                        }
                        getheader(a, &headers[0]);
                    }
                }
                break;

            case Key_Dwn:
                if (a < CurArea.messages)
                {
                    showit(&headers[y - 1], y, 0);
                    a++;
                    y++;

                    if (y > maxy - 4)
                    {
                        y = maxy - 4;
                        WScroll(1, 1, maxx - 2, y, 1);
                        if (SW->statbar)
                        {
                            memmove(headers,
                                    (headers + 1),
                                    sizeof(MLHEAD) * (maxy - 2));
                        }
                        else
                        {
                            memmove(headers,
                                    (headers + 1),
                                    sizeof(MLHEAD) * (maxy - 1));
                        }
                        getheader(a, &headers[y - 1]);
                    }
                }
                break;

            case Key_Home:
                a = CurArea.first;
                update(headers, a, y = 1);
                break;

            case Key_End:
                a = CurArea.last;
                update(headers, a, y = 1);
                break;

            case Key_Spc:
                if (headers[y - 1].sel == 0)
                {
                    headers[y - 1].sel = 1;
                    AddMlist(headers[y - 1].umsgid);
                }
                else
                {
                    MLkill(headers[y - 1].umsgid);
                    headers[y - 1].sel = 0;
                }
                showit(&headers[y - 1], y, 1);
                down = 1;
                break;

            case Key_Del:
                DeleteMsgs(&a);
                if (a > CurArea.last)
                {
                    a = CurArea.last;
                }
                update(headers, a, y = 1);
                break;

            case Key_A_H:
                if (ST->helpfile)
                    DoHelp(2);
                break;

            case Key_Ent:
                CurArea.current = a;
                done = 1;
                break;

            case Key_A_X:
            case Key_Esc:
                done = 1;
                break;

            case Key_A_S:
                long_subj ^= 1;
                update(headers, a, y = 1);
                break;

            case Key_A_A:
                display_address ^= 1;
                update(headers, a, y = 1);
                break;


            default:
                break;
            }
            break;
        }
    }
    in_list = 0;
    KillMlist();
    xfree(headers);
    WClose(hWnd);
    WCurr(hCurr);
}
